/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.relaxng;

import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.extensions.relaxng.grammar.RelaxNGURIResolverExtension;
import org.eclipse.lemminx.extensions.relaxng.xml.contentmodel.CMRelaxNGContentModelProvider;
import org.eclipse.lemminx.services.extensions.IXMLExtension;
import org.eclipse.lemminx.services.extensions.XMLExtensionsRegistry;
import org.eclipse.lemminx.services.extensions.save.ISaveContext;
import org.eclipse.lemminx.uriresolver.URIResolverExtension;
import org.eclipse.lemminx.utils.DOMUtils;
import org.eclipse.lsp4j.InitializeParams;

public class RelaxNGPlugin
implements IXMLExtension {
    private ContentModelManager contentModelManager;
    private URIResolverExtension uiResolver;

    @Override
    public void doSave(ISaveContext context) {
        String documentURI = context.getUri();
        DOMDocument document = context.getDocument(documentURI);
        if (DOMUtils.isRelaxNG(document)) {
            context.collectDocumentToValidate(d -> {
                DOMDocument xml = context.getDocument(d.getDocumentURI());
                return this.contentModelManager.dependsOnGrammar(xml, context.getUri());
            });
        }
    }

    @Override
    public void start(InitializeParams params, XMLExtensionsRegistry registry) {
        this.uiResolver = new RelaxNGURIResolverExtension();
        registry.getResolverExtensionManager().registerResolver(this.uiResolver);
        CMRelaxNGContentModelProvider modelProvider = new CMRelaxNGContentModelProvider(registry.getResolverExtensionManager());
        this.contentModelManager = (ContentModelManager)registry.getComponent(ContentModelManager.class);
        this.contentModelManager.registerModelProvider(modelProvider);
    }

    @Override
    public void stop(XMLExtensionsRegistry registry) {
        registry.getResolverExtensionManager().unregisterResolver(this.uiResolver);
    }

    public ContentModelManager getContentModelManager() {
        return this.contentModelManager;
    }
}

