/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants.completion;

import java.util.Collection;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.extensions.contentmodel.model.CMAttributeDeclaration;
import org.eclipse.lemminx.extensions.contentmodel.model.CMDocument;
import org.eclipse.lemminx.extensions.contentmodel.model.CMElementDeclaration;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.extensions.contentmodel.participants.completion.AbstractCMCompletionResolver;
import org.eclipse.lemminx.extensions.contentmodel.utils.XMLGenerator;
import org.eclipse.lemminx.services.extensions.ISharedSettingsRequest;
import org.eclipse.lemminx.services.extensions.completion.ICompletionItemResolverRequest;
import org.eclipse.lemminx.uriresolver.CacheResourceDownloadingException;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.MarkupContent;

public class AttributeNameCompletionResolver
extends AbstractCMCompletionResolver {
    public static final String PARTICIPANT_ID = AttributeNameCompletionResolver.class.getName();

    @Override
    protected void addDocumentationToCompletion(ICompletionItemResolverRequest request, CompletionItem toResolve, DOMElement parentElement, DOMAttr attr) {
        String attributeName = request.getUnresolved().getFilterText();
        try {
            ContentModelManager contentModelManager = (ContentModelManager)request.getComponent(ContentModelManager.class);
            Collection<CMDocument> cmDocuments = contentModelManager.findCMDocument(parentElement);
            for (CMDocument cmDocument : cmDocuments) {
                MarkupContent documentation;
                CMElementDeclaration cmElement = cmDocument.findCMElement(parentElement, parentElement.getNamespaceURI());
                if (cmElement == null || (documentation = AttributeNameCompletionResolver.getDocumentationForAttributeValue(cmElement, attributeName, request)) == null) continue;
                toResolve.setDocumentation(documentation);
                return;
            }
        }
        catch (CacheResourceDownloadingException cacheResourceDownloadingException) {
            // empty catch block
        }
    }

    private static MarkupContent getDocumentationForAttributeValue(CMElementDeclaration cmElement, String attributeName, ICompletionItemResolverRequest request) {
        CMAttributeDeclaration cmAttribute = cmElement.findCMAttribute(attributeName, null);
        if (cmAttribute != null) {
            return XMLGenerator.createMarkupContent(cmAttribute, cmElement, (ISharedSettingsRequest)request);
        }
        return null;
    }
}

