/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants.completion;

import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.services.extensions.completion.ICompletionItemResolveParticipant;
import org.eclipse.lemminx.services.extensions.completion.ICompletionItemResolverRequest;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public abstract class AbstractCMCompletionResolver
implements ICompletionItemResolveParticipant {
    public static final String OFFSET_KEY = "OFFSET";

    @Override
    public CompletionItem resolveCompletionItem(ICompletionItemResolverRequest request, CancelChecker cancelChecker) {
        CompletionItem toResolve = request.getUnresolved();
        DOMDocument document = request.getDocument();
        Integer offset = request.getDataPropertyAsInt(OFFSET_KEY);
        if (document == null || offset == null) {
            return toResolve;
        }
        DOMAttr attr = document.findAttrAt(offset);
        DOMNode parentNode = document.findNodeAt(offset);
        if (parentNode == null || !parentNode.isElement()) {
            return toResolve;
        }
        DOMElement parentElement = (DOMElement)parentNode;
        this.addDocumentationToCompletion(request, toResolve, parentElement, attr);
        return toResolve;
    }

    protected abstract void addDocumentationToCompletion(ICompletionItemResolverRequest var1, CompletionItem var2, DOMElement var3, DOMAttr var4);
}

