/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.xerces.impl.XMLEntityManager;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.xs.XSDDescription;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.eclipse.lemminx.extensions.contentmodel.participants.DTDErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics.LSPXMLGrammarPool;

class LSPXMLEntityManager
extends XMLEntityManager {
    private final XMLErrorReporter errorReporter;
    private final LSPXMLGrammarPool grammarPool;
    private boolean hasProblemsWithReferencedDTD;
    private static final XMLLocator NULL_LOCATOR = new XMLLocator(){

        public String getXMLVersion() {
            return null;
        }

        public String getPublicId() {
            return null;
        }

        public String getLiteralSystemId() {
            return null;
        }

        public int getLineNumber() {
            return 0;
        }

        public String getExpandedSystemId() {
            return null;
        }

        public String getEncoding() {
            return null;
        }

        public int getColumnNumber() {
            return 0;
        }

        public int getCharacterOffset() {
            return 0;
        }

        public String getBaseSystemId() {
            return null;
        }
    };

    public LSPXMLEntityManager(XMLErrorReporter errorReporter, LSPXMLGrammarPool grammarPool) {
        this.errorReporter = errorReporter;
        this.grammarPool = grammarPool;
        this.hasProblemsWithReferencedDTD = false;
    }

    public XMLInputSource resolveEntity(XMLResourceIdentifier resourceIdentifier) throws IOException, XNIException {
        if (resourceIdentifier instanceof XSDDescription) {
            return super.resolveEntity(resourceIdentifier);
        }
        try {
            return super.resolveEntity(resourceIdentifier);
        }
        catch (Exception e) {
            this.reportError(resourceIdentifier.getLiteralSystemId(), e);
            XMLInputSource in = new XMLInputSource(resourceIdentifier);
            in.setCharacterStream((Reader)new StringReader(""));
            return in;
        }
    }

    public String setupCurrentEntity(String name, XMLInputSource xmlInputSource, boolean literal, boolean isExternal) throws IOException, XNIException {
        try {
            return super.setupCurrentEntity(name, xmlInputSource, literal, isExternal);
        }
        catch (Exception e) {
            this.reportError(xmlInputSource.getSystemId(), e);
            XMLInputSource in = new XMLInputSource(xmlInputSource.getPublicId(), xmlInputSource.getSystemId(), xmlInputSource.getBaseSystemId(), (Reader)new StringReader(""), null);
            return super.setupCurrentEntity(name, in, literal, isExternal);
        }
    }

    private void reportError(String location, Exception e) {
        this.hasProblemsWithReferencedDTD = true;
        this.errorReporter.reportError(NULL_LOCATOR, "https://www.w3.org/TR/xml-model/", DTDErrorCode.dtd_not_found.getCode(), new Object[]{null, location}, (short)1, e);
    }

    public void dispose() {
        if (this.hasProblemsWithReferencedDTD) {
            this.grammarPool.clear();
        }
    }
}

