/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xsd.participants.diagnostics;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.xs.XMLSchemaLoader;
import org.apache.xerces.util.XMLGrammarPoolImpl;
import org.apache.xerces.xni.grammars.XMLGrammarLoader;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParseException;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.extensions.xerces.AbstractLSPErrorReporter;
import org.eclipse.lemminx.extensions.xsd.participants.diagnostics.LSPErrorReporterForXSD;
import org.eclipse.lemminx.extensions.xsd.participants.diagnostics.LSPXMLGrammarPreparser;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class XSDValidator {
    private static final Logger LOGGER = Logger.getLogger(XSDValidator.class.getName());
    private static boolean canCustomizeReporter = true;

    public static void doDiagnostics(DOMDocument document, XMLEntityResolver entityResolver, List<Diagnostic> diagnostics, boolean isRelatedInformation, CancelChecker monitor) {
        try {
            LSPErrorReporterForXSD reporter = new LSPErrorReporterForXSD(document, diagnostics, isRelatedInformation);
            LSPXMLGrammarPreparser grammarPreparser = new LSPXMLGrammarPreparser();
            XMLSchemaLoader schemaLoader = XSDValidator.createSchemaLoader(reporter);
            grammarPreparser.registerPreparser("http://www.w3.org/2001/XMLSchema", (XMLGrammarLoader)schemaLoader);
            grammarPreparser.setProperty("http://apache.org/xml/properties/internal/grammar-pool", new XMLGrammarPoolImpl());
            grammarPreparser.setFeature("http://apache.org/xml/features/continue-after-fatal-error", false);
            grammarPreparser.setFeature("http://apache.org/xml/features/namespaces", true);
            grammarPreparser.setFeature("http://apache.org/xml/features/namespace-prefixes", true);
            grammarPreparser.setFeature("http://apache.org/xml/features/validation", true);
            grammarPreparser.setFeature("http://apache.org/xml/features/validation/schema", true);
            grammarPreparser.setFeature("http://apache.org/xml/features/external-general-entities", true);
            grammarPreparser.setFeature("http://apache.org/xml/features/external-parameter-entities", true);
            grammarPreparser.setFeature("http://apache.org/xml/features/validation/warn-on-duplicate-attdef", true);
            grammarPreparser.setProperty("http://apache.org/xml/properties/internal/error-reporter", (Object)reporter);
            if (entityResolver != null) {
                grammarPreparser.setEntityResolver(entityResolver);
            }
            String content = document.getText();
            String uri = document.getDocumentURI();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));
            XMLInputSource is = new XMLInputSource(null, uri, uri, (InputStream)inputStream, null);
            grammarPreparser.getLoader("http://www.w3.org/2001/XMLSchema");
            grammarPreparser.preparseGrammar("http://www.w3.org/2001/XMLSchema", is);
        }
        catch (IOException | CancellationException | XMLParseException reporter) {
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Unexpected XSDValidator error", e);
        }
    }

    private static XMLSchemaLoader createSchemaLoader(XMLErrorReporter reporter) {
        XMLSchemaLoader schemaLoader = new XMLSchemaLoader();
        if (canCustomizeReporter) {
            canCustomizeReporter = AbstractLSPErrorReporter.initializeReporter(schemaLoader, reporter);
        }
        return schemaLoader;
    }
}

