/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics;

import java.util.List;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.extensions.contentmodel.ContentModelPlugin;
import org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics.XMLValidator;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLValidationSettings;
import org.eclipse.lemminx.services.extensions.diagnostics.IDiagnosticsParticipant;
import org.eclipse.lemminx.uriresolver.URIResolverExtensionManager;
import org.eclipse.lemminx.utils.DOMUtils;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class ContentModelDiagnosticsParticipant
implements IDiagnosticsParticipant {
    private final ContentModelPlugin contentModelPlugin;

    public ContentModelDiagnosticsParticipant(ContentModelPlugin contentModelPlugin) {
        this.contentModelPlugin = contentModelPlugin;
    }

    @Override
    public void doDiagnostics(DOMDocument xmlDocument, List<Diagnostic> diagnostics, XMLValidationSettings validationSettings, CancelChecker monitor) {
        if (xmlDocument.isDTD() || DOMUtils.isXSD(xmlDocument)) {
            return;
        }
        URIResolverExtensionManager entityResolver = xmlDocument.getResolverExtensionManager();
        XMLValidator.doDiagnostics(xmlDocument, entityResolver, diagnostics, validationSettings, this.contentModelPlugin.getContentModelManager(), monitor);
    }
}

