/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.settings.capabilities;

import java.util.Set;
import org.eclipse.lemminx.MockXMLLanguageClient;
import org.eclipse.lemminx.XMLTextDocumentService;
import org.eclipse.lemminx.settings.capabilities.ClientCapabilitiesWrapper;
import org.eclipse.lemminx.settings.capabilities.ServerCapabilitiesConstants;
import org.eclipse.lemminx.settings.capabilities.ServerCapabilitiesInitializer;
import org.eclipse.lemminx.settings.capabilities.XMLCapabilityManager;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.CodeActionCapabilities;
import org.eclipse.lsp4j.CompletionCapabilities;
import org.eclipse.lsp4j.DidChangeWatchedFilesCapabilities;
import org.eclipse.lsp4j.DocumentHighlightCapabilities;
import org.eclipse.lsp4j.DocumentLinkCapabilities;
import org.eclipse.lsp4j.DocumentSymbolCapabilities;
import org.eclipse.lsp4j.FoldingRangeCapabilities;
import org.eclipse.lsp4j.FormattingCapabilities;
import org.eclipse.lsp4j.HoverCapabilities;
import org.eclipse.lsp4j.RangeFormattingCapabilities;
import org.eclipse.lsp4j.RenameCapabilities;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentClientCapabilities;
import org.eclipse.lsp4j.WorkspaceClientCapabilities;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageClient;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class XMLCapabilitiesTest {
    private static final Either<Boolean, ?> TRUE = Either.forLeft((Object)true);
    private static final Either<Boolean, ?> FALSE = Either.forLeft((Object)false);
    private LanguageClient languageClient = new MockXMLLanguageClient();
    private XMLCapabilityManager manager;
    private ClientCapabilities clientCapabilities;
    private TextDocumentClientCapabilities textDocument;
    private WorkspaceClientCapabilities workspace;
    private XMLTextDocumentService textDocumentService;
    private Set<String> capabilityIDs;

    @BeforeEach
    public void startup() {
        this.textDocumentService = new XMLTextDocumentService(null);
        this.textDocumentService.getSharedSettings().getFormattingSettings().setEnabled(true);
        this.textDocument = new TextDocumentClientCapabilities();
        this.workspace = new WorkspaceClientCapabilities();
        this.manager = new XMLCapabilityManager(this.languageClient, this.textDocumentService);
        this.clientCapabilities = new ClientCapabilities();
        this.capabilityIDs = null;
    }

    @Test
    public void testAllDynamicCapabilities() {
        this.setAllCapabilities(true);
        this.setAndInitializeCapabilities();
        Assertions.assertEquals((int)11, (int)this.capabilityIDs.size());
        ServerCapabilities serverCapabilities = ServerCapabilitiesInitializer.getNonDynamicServerCapabilities((ClientCapabilitiesWrapper)this.manager.getClientCapabilities(), (boolean)false);
        Assertions.assertEquals(FALSE, (Object)serverCapabilities.getDocumentRangeFormattingProvider());
        Assertions.assertEquals(FALSE, (Object)serverCapabilities.getDocumentFormattingProvider());
        Assertions.assertEquals(FALSE, (Object)serverCapabilities.getDocumentSymbolProvider());
        Assertions.assertEquals(FALSE, (Object)serverCapabilities.getHoverProvider());
        Assertions.assertEquals(FALSE, (Object)serverCapabilities.getDocumentHighlightProvider());
        Assertions.assertEquals(FALSE, (Object)serverCapabilities.getRenameProvider());
        Assertions.assertEquals(FALSE, (Object)serverCapabilities.getFoldingRangeProvider());
        Assertions.assertEquals(FALSE, (Object)serverCapabilities.getCodeActionProvider());
        Assertions.assertEquals(null, (Object)serverCapabilities.getCompletionProvider());
        Assertions.assertEquals(null, (Object)serverCapabilities.getDocumentLinkProvider());
    }

    @Test
    public void testNoDynamicCapabilities() {
        this.setAllCapabilities(false);
        this.setAndInitializeCapabilities();
        Assertions.assertEquals((int)0, (int)this.capabilityIDs.size());
        ServerCapabilities serverCapabilities = ServerCapabilitiesInitializer.getNonDynamicServerCapabilities((ClientCapabilitiesWrapper)this.manager.getClientCapabilities(), (boolean)false);
        Assertions.assertEquals(TRUE, (Object)serverCapabilities.getDocumentRangeFormattingProvider());
        Assertions.assertEquals(TRUE, (Object)serverCapabilities.getDocumentFormattingProvider());
        Assertions.assertEquals(TRUE, (Object)serverCapabilities.getDocumentSymbolProvider());
        Assertions.assertEquals(TRUE, (Object)serverCapabilities.getHoverProvider());
        Assertions.assertEquals(TRUE, (Object)serverCapabilities.getDocumentHighlightProvider());
        Assertions.assertEquals(TRUE, (Object)serverCapabilities.getRenameProvider());
        Assertions.assertEquals(TRUE, (Object)serverCapabilities.getFoldingRangeProvider());
        Assertions.assertEquals(TRUE, (Object)serverCapabilities.getCodeActionProvider());
        Assertions.assertEquals((Object)ServerCapabilitiesConstants.DEFAULT_COMPLETION_OPTIONS, (Object)serverCapabilities.getCompletionProvider());
        Assertions.assertEquals((Object)ServerCapabilitiesConstants.DEFAULT_LINK_OPTIONS, (Object)serverCapabilities.getDocumentLinkProvider());
    }

    @Test
    public void testBothCapabilityTypes() {
        this.textDocument.setRangeFormatting(new RangeFormattingCapabilities(Boolean.valueOf(true)));
        this.textDocument.setFormatting(new FormattingCapabilities(Boolean.valueOf(true)));
        CompletionCapabilities completion = new CompletionCapabilities();
        completion.setDynamicRegistration(Boolean.valueOf(true));
        this.textDocument.setCompletion(completion);
        this.textDocument.setDocumentSymbol(new DocumentSymbolCapabilities(Boolean.valueOf(true)));
        this.workspace.setDidChangeWatchedFiles(new DidChangeWatchedFilesCapabilities(Boolean.valueOf(true)));
        this.textDocument.setHover(new HoverCapabilities(Boolean.valueOf(false)));
        this.textDocument.setDocumentHighlight(new DocumentHighlightCapabilities(Boolean.valueOf(false)));
        this.textDocument.setRename(new RenameCapabilities(Boolean.valueOf(false)));
        FoldingRangeCapabilities folding = new FoldingRangeCapabilities();
        folding.setDynamicRegistration(Boolean.valueOf(false));
        this.textDocument.setFoldingRange(folding);
        this.textDocument.setDocumentLink(new DocumentLinkCapabilities(Boolean.valueOf(false)));
        this.textDocument.setCodeAction(new CodeActionCapabilities(Boolean.valueOf(false)));
        this.setAndInitializeCapabilities();
        Assertions.assertEquals((int)5, (int)this.capabilityIDs.size());
        Assertions.assertEquals((Object)true, (Object)this.capabilityIDs.contains(ServerCapabilitiesConstants.FORMATTING_ID));
        Assertions.assertEquals((Object)true, (Object)this.capabilityIDs.contains(ServerCapabilitiesConstants.FORMATTING_RANGE_ID));
        Assertions.assertEquals((Object)true, (Object)this.capabilityIDs.contains(ServerCapabilitiesConstants.COMPLETION_ID));
        Assertions.assertEquals((Object)true, (Object)this.capabilityIDs.contains(ServerCapabilitiesConstants.DOCUMENT_SYMBOL_ID));
        ServerCapabilities serverCapabilities = ServerCapabilitiesInitializer.getNonDynamicServerCapabilities((ClientCapabilitiesWrapper)this.manager.getClientCapabilities(), (boolean)false);
        Assertions.assertEquals(FALSE, (Object)serverCapabilities.getDocumentRangeFormattingProvider());
        Assertions.assertEquals(FALSE, (Object)serverCapabilities.getDocumentFormattingProvider());
        Assertions.assertEquals(FALSE, (Object)serverCapabilities.getDocumentSymbolProvider());
        Assertions.assertEquals(TRUE, (Object)serverCapabilities.getHoverProvider());
        Assertions.assertEquals(TRUE, (Object)serverCapabilities.getDocumentHighlightProvider());
        Assertions.assertEquals(TRUE, (Object)serverCapabilities.getRenameProvider());
        Assertions.assertEquals(TRUE, (Object)serverCapabilities.getFoldingRangeProvider());
        Assertions.assertEquals(TRUE, (Object)serverCapabilities.getCodeActionProvider());
        Assertions.assertEquals(null, (Object)serverCapabilities.getCompletionProvider());
        Assertions.assertEquals((Object)ServerCapabilitiesConstants.DEFAULT_LINK_OPTIONS, (Object)serverCapabilities.getDocumentLinkProvider());
    }

    @Test
    public void testDynamicFormattingWithPreferenceFalse() {
        this.textDocumentService.getSharedFormattingSettings().setEnabled(false);
        this.textDocument.setRangeFormatting(new RangeFormattingCapabilities(Boolean.valueOf(true)));
        this.textDocument.setFormatting(new FormattingCapabilities(Boolean.valueOf(true)));
        this.setAndInitializeCapabilities();
        Set capabilityIDs = this.manager.getRegisteredCapabilities();
        Assertions.assertEquals((int)0, (int)capabilityIDs.size());
        ServerCapabilities serverCapabilities = ServerCapabilitiesInitializer.getNonDynamicServerCapabilities((ClientCapabilitiesWrapper)this.manager.getClientCapabilities(), (boolean)false);
        Assertions.assertEquals(FALSE, (Object)serverCapabilities.getDocumentRangeFormattingProvider());
        Assertions.assertEquals(FALSE, (Object)serverCapabilities.getDocumentFormattingProvider());
    }

    @Test
    public void testDynamicFormattingWithPreferenceTrue() {
        this.textDocumentService.getSharedFormattingSettings().setEnabled(true);
        this.textDocument.setRangeFormatting(new RangeFormattingCapabilities(Boolean.valueOf(true)));
        this.textDocument.setFormatting(new FormattingCapabilities(Boolean.valueOf(true)));
        this.setAndInitializeCapabilities();
        Set capabilityIDs = this.manager.getRegisteredCapabilities();
        Assertions.assertEquals((int)2, (int)capabilityIDs.size());
        Assertions.assertEquals((Object)true, (Object)capabilityIDs.contains(ServerCapabilitiesConstants.FORMATTING_ID));
        Assertions.assertEquals((Object)true, (Object)capabilityIDs.contains(ServerCapabilitiesConstants.FORMATTING_RANGE_ID));
        ServerCapabilities serverCapabilities = ServerCapabilitiesInitializer.getNonDynamicServerCapabilities((ClientCapabilitiesWrapper)this.manager.getClientCapabilities(), (boolean)false);
        Assertions.assertEquals(FALSE, (Object)serverCapabilities.getDocumentRangeFormattingProvider());
        Assertions.assertEquals(FALSE, (Object)serverCapabilities.getDocumentFormattingProvider());
    }

    private void setAllCapabilities(boolean areAllDynamic) {
        this.textDocument.setRangeFormatting(new RangeFormattingCapabilities(Boolean.valueOf(areAllDynamic)));
        this.textDocument.setFormatting(new FormattingCapabilities(Boolean.valueOf(areAllDynamic)));
        CompletionCapabilities completion = new CompletionCapabilities();
        completion.setDynamicRegistration(Boolean.valueOf(areAllDynamic));
        this.textDocument.setCompletion(completion);
        this.textDocument.setDocumentSymbol(new DocumentSymbolCapabilities(Boolean.valueOf(areAllDynamic)));
        this.textDocument.setHover(new HoverCapabilities(Boolean.valueOf(areAllDynamic)));
        this.textDocument.setDocumentHighlight(new DocumentHighlightCapabilities(Boolean.valueOf(areAllDynamic)));
        this.textDocument.setRename(new RenameCapabilities(Boolean.valueOf(areAllDynamic)));
        FoldingRangeCapabilities folding = new FoldingRangeCapabilities();
        folding.setDynamicRegistration(Boolean.valueOf(areAllDynamic));
        this.textDocument.setFoldingRange(folding);
        this.textDocument.setDocumentLink(new DocumentLinkCapabilities(Boolean.valueOf(areAllDynamic)));
        this.textDocument.setCodeAction(new CodeActionCapabilities(Boolean.valueOf(areAllDynamic)));
        this.workspace.setDidChangeWatchedFiles(new DidChangeWatchedFilesCapabilities(Boolean.valueOf(areAllDynamic)));
    }

    private void setAndInitializeCapabilities() {
        this.clientCapabilities.setTextDocument(this.textDocument);
        this.clientCapabilities.setWorkspace(this.workspace);
        this.manager.setClientCapabilities(this.clientCapabilities, null);
        this.manager.initializeCapabilities();
        this.capabilityIDs = this.manager.getRegisteredCapabilities();
    }
}

