/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.dtd;

import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.junit.jupiter.api.Test;

public class DTDCodeLensExtensionsTest {
    @Test
    public void codeLensOnDTDElementInDOCTYPE() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<!DOCTYPE note [\r\n\t<!ELEMENT note (to,from,heading,body, note?)>\r\n\t<!ELEMENT from (#PCDATA)>\r\n\t<!ATTLIST note version CDATA #REQUIRED>\r\n]>";
        XMLAssert.testCodeLensFor(xml, "test.xml", XMLAssert.cl(XMLAssert.r(2, 11, 2, 15), "2 references", "xml.show.references"), XMLAssert.cl(XMLAssert.r(3, 11, 3, 15), "1 reference", "xml.show.references"));
    }

    @Test
    public void codeLensOnDTDElementInDTD() throws BadLocationException {
        String xml = "<!ELEMENT note (to,from,heading,body, note?)>\r\n\t<!ELEMENT from (#PCDATA)>\r\n\t<!ATTLIST note version CDATA #REQUIRED>";
        XMLAssert.testCodeLensFor(xml, "test.dtd", XMLAssert.cl(XMLAssert.r(0, 10, 0, 14), "2 references", "xml.show.references"), XMLAssert.cl(XMLAssert.r(1, 11, 1, 15), "1 reference", "xml.show.references"));
    }
}

