/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lemminx.MockXMLLanguageClient;
import org.eclipse.lemminx.XMLLanguageServer;
import org.eclipse.lemminx.XMLTextDocumentService;
import org.eclipse.lemminx.customservice.ActionableNotification;
import org.eclipse.lemminx.services.extensions.commands.IXMLCommandService;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.services.LanguageClient;

public class MockXMLLanguageServer
extends XMLLanguageServer {
    public MockXMLLanguageServer() {
        super.setClient((LanguageClient)new MockXMLLanguageClient());
    }

    public List<PublishDiagnosticsParams> getPublishDiagnostics() {
        return this.getLanguageClient().getPublishDiagnostics();
    }

    public MockXMLLanguageClient getLanguageClient() {
        return (MockXMLLanguageClient)super.getLanguageClient();
    }

    public List<MessageParams> getShowMessages() {
        return this.getLanguageClient().getShowMessages();
    }

    public List<ActionableNotification> getActionableNotifications() {
        return this.getLanguageClient().getActionableNotifications();
    }

    public void registerCommand(String commandId, IXMLCommandService.IDelegateCommandHandler handler) {
        this.getXMLLanguageService().getCommandService().registerCommand(commandId, handler);
    }

    public void unregisterCommand(String commandId) {
        this.getXMLLanguageService().getCommandService().unregisterCommand(commandId);
    }

    public CompletableFuture<Object> executeCommand(String command, Object ... arguments) {
        this.getXMLLanguageService().initializeIfNeeded();
        ExecuteCommandParams params = new ExecuteCommandParams(command, Arrays.asList(arguments));
        return this.getWorkspaceService().executeCommand(params);
    }

    public TextDocumentIdentifier didOpen(String fileURI, String xml) {
        TextDocumentIdentifier xmlIdentifier = new TextDocumentIdentifier(fileURI);
        DidOpenTextDocumentParams params = new DidOpenTextDocumentParams(new TextDocumentItem(xmlIdentifier.getUri(), "xml", 1, xml));
        XMLTextDocumentService textDocumentService = (XMLTextDocumentService)super.getTextDocumentService();
        textDocumentService.didOpen(params);
        try {
            textDocumentService.getDocument(params.getTextDocument().getUri()).getModel().get();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return xmlIdentifier;
    }

    public TextDocumentIdentifier didChange(String fileURI, List<TextDocumentContentChangeEvent> contentChanges) {
        TextDocumentIdentifier xmlIdentifier = new TextDocumentIdentifier(fileURI);
        DidChangeTextDocumentParams params = new DidChangeTextDocumentParams(new VersionedTextDocumentIdentifier(xmlIdentifier.getUri(), Integer.valueOf(1)), contentChanges);
        XMLTextDocumentService textDocumentService = (XMLTextDocumentService)super.getTextDocumentService();
        textDocumentService.didChange(params);
        try {
            textDocumentService.getDocument(params.getTextDocument().getUri()).getModel().get();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return xmlIdentifier;
    }

    public TextDocumentIdentifier didClose(String fileURI) {
        TextDocumentIdentifier xmlIdentifier = new TextDocumentIdentifier(fileURI);
        DidCloseTextDocumentParams params = new DidCloseTextDocumentParams(xmlIdentifier);
        XMLTextDocumentService textDocumentService = (XMLTextDocumentService)super.getTextDocumentService();
        textDocumentService.didClose(params);
        return xmlIdentifier;
    }

    public TextDocumentIdentifier didSave(String fileURI) {
        TextDocumentIdentifier xmlIdentifier = new TextDocumentIdentifier(fileURI);
        DidSaveTextDocumentParams params = new DidSaveTextDocumentParams(xmlIdentifier);
        XMLTextDocumentService textDocumentService = (XMLTextDocumentService)super.getTextDocumentService();
        textDocumentService.didSave(params);
        try {
            textDocumentService.getDocument(params.getTextDocument().getUri()).getModel().get();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return xmlIdentifier;
    }
}

