/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.xerces.xni.XMLLocator;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMRange;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.extensions.contentmodel.model.ReferencedGrammarInfo;
import org.eclipse.lemminx.extensions.contentmodel.participants.DTDErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.participants.XMLSchemaErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.participants.XMLSyntaxErrorCode;
import org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics.LSPXMLGrammarPool;
import org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics.ReferencedGrammarDiagnosticsInfo;
import org.eclipse.lemminx.extensions.xerces.AbstractLSPErrorReporter;
import org.eclipse.lemminx.extensions.xsd.participants.XSDErrorCode;
import org.eclipse.lemminx.uriresolver.URIResolverExtensionManager;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticRelatedInformation;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public class LSPErrorReporterForXML
extends AbstractLSPErrorReporter {
    private static final String XML_DIAGNOSTIC_SOURCE = "xml";
    private final ContentModelManager contentModelManager;
    private Set<ReferencedGrammarInfo> referencedGrammars;
    private final Map<String, ReferencedGrammarDiagnosticsInfo> referencedGrammarDiagnosticsInfoCache;
    private final boolean hasRelatedInformation;

    public LSPErrorReporterForXML(DOMDocument xmlDocument, List<Diagnostic> diagnostics, ContentModelManager contentModelManager, boolean hasRelatedInformation, Map<String, ReferencedGrammarDiagnosticsInfo> referencedGrammarDiagnosticsInfoCache) {
        super(XML_DIAGNOSTIC_SOURCE, xmlDocument, diagnostics, hasRelatedInformation);
        this.contentModelManager = contentModelManager;
        this.hasRelatedInformation = hasRelatedInformation;
        this.referencedGrammarDiagnosticsInfoCache = referencedGrammarDiagnosticsInfoCache == null ? new HashMap() : referencedGrammarDiagnosticsInfoCache;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected Range toLSPRange(XMLLocator location, String key, Object[] arguments, String message, DiagnosticSeverity diagnosticSeverity, boolean fatalError, DOMDocument document) {
        String documentOrGrammarURI = location.getExpandedSystemId();
        boolean errorForDocument = documentOrGrammarURI != null ? documentOrGrammarURI.endsWith(document.getDocumentURI()) : true;
        XMLSyntaxErrorCode syntaxCode = XMLSyntaxErrorCode.get(key);
        if (syntaxCode != null) {
            if (!errorForDocument) {
                this.fillReferencedGrammarDiagnostic(location, key, arguments, message, diagnosticSeverity, fatalError, document.getResolverExtensionManager(), syntaxCode, null, null, documentOrGrammarURI);
                return NO_RANGE;
            }
            Range range = XMLSyntaxErrorCode.toLSPRange(location, syntaxCode, arguments, document);
            if (range != null) {
                return range;
            }
        } else {
            XMLSchemaErrorCode schemaCode = XMLSchemaErrorCode.get(key);
            if (schemaCode != null) {
                Range range = XMLSchemaErrorCode.toLSPRange(location, schemaCode, arguments, document);
                if (range != null) {
                    return range;
                }
            } else {
                DTDErrorCode dtdCode = DTDErrorCode.get(key);
                if (dtdCode != null) {
                    if (!errorForDocument) {
                        this.fillReferencedGrammarDiagnostic(location, key, arguments, message, diagnosticSeverity, fatalError, document.getResolverExtensionManager(), null, dtdCode, null, documentOrGrammarURI);
                        return NO_RANGE;
                    }
                    Range range = DTDErrorCode.toLSPRange(location, dtdCode, arguments, document);
                    if (range != null) {
                        return range;
                    }
                } else {
                    XSDErrorCode xsdCode = XSDErrorCode.get(key);
                    if (xsdCode != null && !errorForDocument) {
                        this.fillReferencedGrammarDiagnostic(location, key, arguments, message, diagnosticSeverity, fatalError, document.getResolverExtensionManager(), null, null, xsdCode, documentOrGrammarURI);
                        return NO_RANGE;
                    }
                }
            }
        }
        if (!errorForDocument) {
            return NO_RANGE;
        }
        return null;
    }

    private void fillReferencedGrammarDiagnostic(XMLLocator location, String key, Object[] arguments, String message, DiagnosticSeverity diagnosticSeverity, boolean fatalError, URIResolverExtensionManager resolverExtensionManager, XMLSyntaxErrorCode syntaxCode, DTDErrorCode dtdCode, XSDErrorCode xsdCode, String grammarURI) {
        ReferencedGrammarDiagnosticsInfo info = this.getReferencedGrammarDiagnosticsInfo(grammarURI, resolverExtensionManager);
        if (info.isFatalError()) {
            return;
        }
        info.addError(fatalError);
        if (this.hasRelatedInformation && info.getGrammarDocument() != null) {
            DOMDocument grammarDocument = info.getGrammarDocument();
            Range range = null;
            range = dtdCode != null ? DTDErrorCode.toLSPRange(location, dtdCode, arguments, grammarDocument) : (xsdCode != null ? XSDErrorCode.toLSPRange(location, xsdCode, arguments, grammarDocument) : XMLSyntaxErrorCode.toLSPRange(location, syntaxCode, arguments, grammarDocument));
            if (range == null) {
                range = this.createDefaultRange(location, grammarDocument);
            }
            if (range == null) {
                try {
                    range = new Range(new Position(0, 0), grammarDocument.positionAt(grammarDocument.getEnd()));
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            DiagnosticRelatedInformation r = new DiagnosticRelatedInformation(range != null ? new Location(grammarURI, range) : null, message);
            info.addDiagnosticRelatedInformation(r);
        }
    }

    private ReferencedGrammarDiagnosticsInfo getReferencedGrammarDiagnosticsInfo(String grammarURI, URIResolverExtensionManager resolverExtensionManager) {
        ReferencedGrammarDiagnosticsInfo info = this.referencedGrammarDiagnosticsInfoCache.get(grammarURI);
        if (info == null) {
            Range range = this.getReferencedGrammarRange(grammarURI);
            String message = "";
            Diagnostic diagnostic = super.addDiagnostic(range, message, DiagnosticSeverity.Error, null, null);
            info = new ReferencedGrammarDiagnosticsInfo(grammarURI, resolverExtensionManager, diagnostic);
            this.referencedGrammarDiagnosticsInfoCache.put(grammarURI, info);
        }
        return info;
    }

    private Range getReferencedGrammarRange(String grammarURI) {
        Set<ReferencedGrammarInfo> referencedGrammars = this.getReferencedGrammars();
        for (ReferencedGrammarInfo referencedGrammarInfo : referencedGrammars) {
            DOMRange range;
            if (!grammarURI.equals(referencedGrammarInfo.getResolvedURIInfo().getResolvedURI()) || (range = referencedGrammarInfo.getIdentifier() != null ? referencedGrammarInfo.getIdentifier().getRange() : null) == null) continue;
            return XMLPositionUtility.createRange(range);
        }
        return XMLPositionUtility.selectRootStartTag(this.getDOMDocument());
    }

    private Set<ReferencedGrammarInfo> getReferencedGrammars() {
        if (this.referencedGrammars != null) {
            return this.referencedGrammars;
        }
        this.referencedGrammars = this.contentModelManager.getReferencedGrammarInfos(super.getDOMDocument());
        return this.referencedGrammars;
    }

    @Override
    protected boolean isIgnoreFatalError(String key) {
        return DTDErrorCode.EntityNotDeclared.name().equals(key);
    }

    public void endReport() {
        if (this.referencedGrammarDiagnosticsInfoCache.isEmpty()) {
            return;
        }
        LSPXMLGrammarPool grammarPool = (LSPXMLGrammarPool)this.contentModelManager.getGrammarPool();
        if (grammarPool == null) {
            return;
        }
        Set<String> grammarURIs = this.referencedGrammarDiagnosticsInfoCache.keySet();
        for (String grammarURI : grammarURIs) {
            grammarPool.removeGrammar(grammarURI);
        }
    }
}

