/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.xpath.matcher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lemminx.xpath.matcher.IXPathNodeMatcher;
import org.eclipse.lemminx.xpath.matcher.XPathAttributeMatcher;
import org.eclipse.lemminx.xpath.matcher.XPathAttributeNameMatcher;
import org.eclipse.lemminx.xpath.matcher.XPathElementMatcher;
import org.eclipse.lemminx.xpath.matcher.XPathTextMatcher;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XPathMatcher
extends ArrayList<IXPathNodeMatcher> {
    private static final long serialVersionUID = 1L;
    private static final String ATTR_NODE_SELECTOR = "@";
    private static final String TEXT_NODE_SELECTOR = "text()";
    private int nbWildCard = -1;

    public XPathMatcher(String xpathExpression) {
        this.parse(xpathExpression != null ? xpathExpression.trim() : "");
    }

    private void parse(String xpathExpression) {
        String prefix = null;
        String localName = null;
        if (xpathExpression.startsWith("/")) {
            xpathExpression = xpathExpression.substring(1, xpathExpression.length());
        }
        boolean endsWithAny = false;
        if (xpathExpression.endsWith("//")) {
            endsWithAny = true;
            xpathExpression = xpathExpression.substring(0, xpathExpression.length() - 2);
        }
        IXPathNodeMatcher nodeMatcher = null;
        String[] paths = xpathExpression.split("/");
        for (int i = 0; i < paths.length; ++i) {
            int indexSquareBracket;
            localName = paths[i];
            if (StringUtils.isEmpty(localName)) {
                this.createAnyElementMatcher();
                continue;
            }
            int indexNS = localName.indexOf(58);
            if (indexNS != -1) {
                prefix = localName.substring(0, indexNS);
                localName = localName.substring(indexNS + 1, localName.length());
            }
            if ((indexSquareBracket = localName.indexOf("[")) == -1) {
                this.createAndAddNodeMatcher(prefix, localName);
                continue;
            }
            String elementName = localName.substring(0, indexSquareBracket);
            nodeMatcher = this.createAndAddNodeMatcher(prefix, elementName);
            String attributesCondition = localName.substring(indexSquareBracket, localName.length());
            StringBuilder attrName = null;
            StringBuilder attrValue = null;
            boolean firstQuote = false;
            boolean attrCondition = false;
            char[] chars = attributesCondition.toCharArray();
            for (int j = 0; j < chars.length; ++j) {
                char c = chars[j];
                if (attrName == null) {
                    if (c == '[' || c == ']') continue;
                    attrName = new StringBuilder();
                    attrName.append(c);
                    attrCondition = c == '@';
                    continue;
                }
                if (attrValue == null) {
                    if (c != '=') {
                        attrName.append(c);
                        continue;
                    }
                    attrValue = new StringBuilder();
                    continue;
                }
                if (c == '\'') {
                    int index;
                    XPathAttributeMatcher attributematcher;
                    if (!firstQuote) {
                        firstQuote = true;
                        continue;
                    }
                    if (attrCondition && (attributematcher = this.createAttributeMatcher((XPathElementMatcher)nodeMatcher, attrName.toString().substring(1, attrName.length()), attrValue.toString())).hasWildcard() && (index = attributematcher.getIndexWildcard()) > this.nbWildCard) {
                        this.nbWildCard = index;
                    }
                    attrName = null;
                    attrValue = null;
                    firstQuote = false;
                    attrCondition = false;
                    continue;
                }
                attrValue.append(c);
            }
        }
        if (endsWithAny) {
            this.createAnyElementMatcher();
        }
    }

    public boolean match(Node node) {
        return this.match(node, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean match(Node node, Collection<String> wildcardValues) {
        if (node == null) {
            return false;
        }
        Node testNode = node;
        IXPathNodeMatcher condition = null;
        for (int i = super.size() - 1; i >= 0; --i) {
            if (testNode == null) {
                return false;
            }
            condition = (IXPathNodeMatcher)super.get(i);
            if (condition.isAny()) {
                if (i <= 0) return true;
                boolean previousConditionFounded = false;
                IXPathNodeMatcher previousElementCondition = (IXPathNodeMatcher)super.get(i - 1);
                if (previousElementCondition == null) {
                    return true;
                }
                while (testNode != null && testNode.getNodeType() != 9) {
                    if (previousElementCondition.match(testNode, wildcardValues)) {
                        previousConditionFounded = true;
                        break;
                    }
                    testNode = testNode.getParentNode();
                }
                if (!previousConditionFounded) {
                    return false;
                }
                --i;
            } else if (!condition.match(testNode, wildcardValues)) {
                return false;
            }
            testNode = this.getTestParentNode(testNode);
        }
        return true;
    }

    public List<String> getWildcardValues(Node selectedNode) {
        ArrayList<String> wildcardValues = new ArrayList<String>();
        if (this.nbWildCard == -1 || selectedNode == null) {
            return wildcardValues;
        }
        Node testNode = this.getTestNode(selectedNode);
        this.match(testNode, wildcardValues);
        return wildcardValues;
    }

    private Node getTestNode(Node node) {
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 2: {
                return ((Attr)node).getOwnerElement();
            }
            case 3: {
                return ((Text)node).getParentNode();
            }
        }
        return node;
    }

    private Node getTestParentNode(Node node) {
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 2: {
                return ((Attr)node).getOwnerElement();
            }
        }
        return node.getParentNode();
    }

    public int getNbWildCard() {
        return this.nbWildCard;
    }

    private IXPathNodeMatcher createAndAddNodeMatcher(String prefix, String localName) {
        IXPathNodeMatcher matcher = this.createNodeMatcher(prefix, localName);
        super.add(matcher);
        return matcher;
    }

    private IXPathNodeMatcher createNodeMatcher(String prefix, String localName) {
        if (TEXT_NODE_SELECTOR.equals(localName)) {
            return new XPathTextMatcher(this);
        }
        if (localName.startsWith(ATTR_NODE_SELECTOR)) {
            return new XPathAttributeNameMatcher(prefix, localName.substring(1, localName.length()), this);
        }
        return new XPathElementMatcher(prefix, localName, this);
    }

    protected XPathElementMatcher createAnyElementMatcher() {
        XPathElementMatcher matcher = new XPathElementMatcher(null, "*", this);
        super.add(matcher);
        return matcher;
    }

    protected XPathAttributeMatcher createAttributeMatcher(XPathElementMatcher elementmatcher, String attrName, String attrValue) {
        XPathAttributeMatcher matcher = new XPathAttributeMatcher(attrName, attrValue, this);
        elementmatcher.add(matcher);
        return matcher;
    }

    public IXPathNodeMatcher.MatcherType getNodeSelectorType() {
        if (this.isEmpty()) {
            return IXPathNodeMatcher.MatcherType.ELEMENT;
        }
        IXPathNodeMatcher matcher = (IXPathNodeMatcher)this.get(this.size() - 1);
        return matcher.getType();
    }
}

