/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import org.eclipse.lemminx.NoOpInputStream;
import org.eclipse.lemminx.NoOpPrintStream;
import org.eclipse.lemminx.XMLLanguageServer;
import org.eclipse.lemminx.commons.ParentProcessWatcher;
import org.eclipse.lemminx.customservice.XMLLanguageClientAPI;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.jsonrpc.MessageConsumer;
import org.eclipse.lsp4j.launch.LSPLauncher;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageServer;

public class XMLServerLauncher {
    public static void main(String[] args) {
        final String username = System.getProperty("http.proxyUser");
        final String password = System.getProperty("http.proxyPassword");
        if (username != null && password != null) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(username, password.toCharArray());
                }
            });
        }
        InputStream in = System.in;
        PrintStream out = System.out;
        System.setIn(new NoOpInputStream());
        System.setOut(new NoOpPrintStream());
        System.setErr(new NoOpPrintStream());
        XMLServerLauncher.launch(in, out);
    }

    public static Future<?> launch(InputStream in, OutputStream out) {
        XMLLanguageServer server = new XMLLanguageServer();
        ParentProcessWatcher wrapper = "false".equals(System.getProperty("watchParentProcess")) ? it -> it : new ParentProcessWatcher(server);
        Launcher<LanguageClient> launcher = XMLServerLauncher.createServerLauncher(server, in, out, Executors.newCachedThreadPool(), wrapper);
        server.setClient((LanguageClient)launcher.getRemoteProxy());
        return launcher.startListening();
    }

    private static Launcher<LanguageClient> createServerLauncher(LanguageServer server, InputStream in, OutputStream out, ExecutorService executorService, Function<MessageConsumer, MessageConsumer> wrapper) {
        return new LSPLauncher.Builder().setLocalService((Object)server).setRemoteInterface(XMLLanguageClientAPI.class).setInput(in).setOutput(out).setExecutorService(executorService).wrapMessages(wrapper).create();
    }
}

