/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants.codeactions;

import java.util.List;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.commons.CodeActionFactory;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.dom.LineIndentInfo;
import org.eclipse.lemminx.services.extensions.ICodeActionParticipant;
import org.eclipse.lemminx.services.extensions.IComponentProvider;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public class CloseStartTagCodeAction
implements ICodeActionParticipant {
    @Override
    public void doCodeAction(Diagnostic diagnostic, Range range, DOMDocument document, List<CodeAction> codeActions, SharedSettings sharedSettings, IComponentProvider componentProvider) {
        Range diagnosticRange = diagnostic.getRange();
        try {
            int startOffset = document.offsetAt(diagnosticRange.getStart());
            DOMNode node = document.findNodeAt(startOffset);
            if (node != null && node.isElement()) {
                int diagnosticEndOffset = document.offsetAt(diagnosticRange.getEnd());
                DOMElement element = (DOMElement)node;
                if (!element.hasStartTag()) {
                    DOMElement parent = element.getParentElement();
                    if (parent != null && parent.getTagName() != null) {
                        String tagName = parent.getTagName();
                        Range replaceRange = XMLPositionUtility.selectEndTagName(element);
                        CodeAction replaceTagAction = CodeActionFactory.replace("Replace with '" + tagName + "' closing tag", replaceRange, tagName, document.getTextDocument(), diagnostic);
                        codeActions.add(replaceTagAction);
                    }
                } else {
                    boolean startTagClosed = element.isStartTagClosed();
                    char c = document.getText().charAt(diagnosticEndOffset - 1);
                    if (c != '/') {
                        if (startTagClosed) {
                            String tagName = element.getTagName();
                            if (tagName != null) {
                                String label;
                                String insertText = label = "</" + tagName + ">";
                                Position endPosition = null;
                                if (!element.hasChildNodes()) {
                                    int endOffset = element.getStartTagCloseOffset() + 1;
                                    endPosition = document.positionAt(endOffset);
                                } else {
                                    String text = document.getText();
                                    int endOffset = element.getLastChild().getEnd() - 1;
                                    if (endOffset < text.length()) {
                                        char ch = text.charAt(endOffset);
                                        while (Character.isWhitespace(ch)) {
                                            ch = text.charAt(--endOffset);
                                        }
                                    }
                                    endPosition = document.positionAt(++endOffset);
                                    if (CloseStartTagCodeAction.hasElements(element)) {
                                        LineIndentInfo indentInfo = document.getLineIndentInfo(diagnosticRange.getStart().getLine());
                                        insertText = indentInfo.getLineDelimiter() + indentInfo.getWhitespacesIndent() + insertText;
                                    }
                                }
                                CodeAction closeEndTagAction = CodeActionFactory.insert("Close with '" + label + "'", endPosition, insertText, document.getTextDocument(), diagnostic);
                                codeActions.add(closeEndTagAction);
                            }
                        } else {
                            CodeAction autoCloseAction = CodeActionFactory.insert("Close with '/>'", diagnosticRange.getEnd(), "/>", document.getTextDocument(), diagnostic);
                            codeActions.add(autoCloseAction);
                            String tagName = element.getTagName();
                            if (tagName != null) {
                                String insertText = "></" + tagName + ">";
                                CodeAction closeEndTagAction = CodeActionFactory.insert("Close with '" + insertText + "'", diagnosticRange.getEnd(), insertText, document.getTextDocument(), diagnostic);
                                codeActions.add(closeEndTagAction);
                            }
                        }
                    }
                    if (!startTagClosed) {
                        CodeAction closeAction = CodeActionFactory.insert("Close with '>'", diagnosticRange.getEnd(), ">", document.getTextDocument(), diagnostic);
                        codeActions.add(closeAction);
                    }
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private static boolean hasElements(DOMElement element) {
        for (DOMNode node : element.getChildren()) {
            if (!node.isElement()) continue;
            return true;
        }
        return false;
    }
}

