/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.client;

import java.net.URI;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.lemminx.client.LimitFeature;
import org.eclipse.lemminx.customservice.ActionableNotification;
import org.eclipse.lemminx.customservice.XMLLanguageClientAPI;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;

public class LimitExceededWarnings {
    private final XMLLanguageClientAPI client;
    private final SharedSettings sharedSettings;
    private final Set<String> cache;

    public LimitExceededWarnings(XMLLanguageClientAPI client, SharedSettings sharedSettings) {
        this.client = client;
        this.sharedSettings = sharedSettings;
        this.cache = new HashSet<String>();
    }

    public void onResultLimitExceeded(String uri, LimitFeature feature) {
        int resultLimit = 0;
        switch (feature) {
            case SYMBOLS: {
                resultLimit = this.sharedSettings.getSymbolSettings().getMaxItemsComputed();
            }
        }
        this.onResultLimitExceeded(uri, resultLimit, feature.getName());
    }

    public void onResultLimitExceeded(String uri, int resultLimit, String featureName) {
        if (this.cache.contains(uri)) {
            return;
        }
        this.sendLimitExceededWarning(uri, resultLimit, featureName);
        this.cache.add(uri);
    }

    public void evict(String uri) {
        this.cache.remove(uri);
    }

    public void evictAll() {
        this.cache.clear();
    }

    private void sendLimitExceededWarning(String uri, int resultLimit, String featureName) {
        String filename = Paths.get(URI.create(uri)).getFileName().toString();
        String message = filename != null ? filename + ": " : "";
        message = message + "For performance reasons, " + featureName + " have been limited to " + resultLimit + " items.\nIf a new limit is set, please close and reopen this file to recompute " + featureName + ".";
        if (this.sharedSettings.isActionableNotificationSupport() && this.sharedSettings.isOpenSettingsCommandSupport()) {
            Command command = new Command("Configure limit", "xml.open.settings", Collections.singletonList("xml.symbols.maxItemsComputed"));
            ActionableNotification notification = new ActionableNotification().withSeverity(MessageType.Info).withMessage(message).withCommands(Collections.singletonList(command));
            this.client.actionableNotification(notification);
        } else {
            this.client.showMessage(new MessageParams(MessageType.Warning, message));
        }
    }
}

