/**
 *  Copyright (c) 2018 Angelo ZERR
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v2.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v20.html
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 *  Contributors:
 *  Angelo Zerr <angelo.zerr@gmail.com> - initial API and implementation
 */
package org.eclipse.lemminx.services;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.services.extensions.IDocumentLinkParticipant;
import org.eclipse.lemminx.services.extensions.XMLExtensionsRegistry;
import org.eclipse.lsp4j.DocumentLink;

/**
 * XML document link support.
 *
 */
class XMLDocumentLink {

	private final XMLExtensionsRegistry extensionsRegistry;

	public XMLDocumentLink(XMLExtensionsRegistry extensionsRegistry) {
		this.extensionsRegistry = extensionsRegistry;
	}

	public List<DocumentLink> findDocumentLinks(DOMDocument document) {
		List<DocumentLink> newLinks = new ArrayList<>();
		for (IDocumentLinkParticipant participant : extensionsRegistry.getDocumentLinkParticipants()) {
			participant.findDocumentLinks(document, newLinks);
		}
		// TODO: call extension
		/*
		 * let rootAbsoluteUrl: Uri | null = null;
		 * 
		 * Scanner scanner = XMLScanner.createScanner(document.getText(), 0); TokenType
		 * token = scanner.scan(); let afterHrefOrSrc = false; let afterBase = false;
		 * let base: string | undefined = void 0; while (token != TokenType.EOS) {
		 * switch (token) { case TokenType.StartTag: if (!base) { let tagName =
		 * scanner.getTokenText().toLowerCase(); afterBase = tagName === 'base'; }
		 * break; case TokenType.AttributeName: let attributeName =
		 * scanner.getTokenText().toLowerCase(); afterHrefOrSrc = attributeName ===
		 * 'src' || attributeName === 'href'; break; case TokenType.AttributeValue: if
		 * (afterHrefOrSrc) { let attributeValue = scanner.getTokenText(); if
		 * (!afterBase) { // don't highlight the base link itself let link =
		 * createLink(document, documentContext, attributeValue,
		 * scanner.getTokenOffset(), scanner.getTokenEnd(), base); if (link) {
		 * newLinks.push(link); } } if (afterBase && typeof base === 'undefined') { base
		 * = normalizeRef(attributeValue, document.languageId); if (base &&
		 * documentContext) { base = documentContext.resolveReference(base,
		 * document.uri); } } afterBase = false; afterHrefOrSrc = false; } break; }
		 * token = scanner.scan(); }
		 */
		return newLinks;
	}
}
