/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xsd.contentmodel;

import org.apache.xerces.impl.xs.XSLoaderImpl;
import org.apache.xerces.xs.XSModel;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.NoNamespaceSchemaLocation;
import org.eclipse.lemminx.dom.SchemaLocation;
import org.eclipse.lemminx.extensions.contentmodel.model.CMDocument;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelProvider;
import org.eclipse.lemminx.extensions.xsd.contentmodel.CMXSDDocument;
import org.eclipse.lemminx.uriresolver.CacheResourceDownloadingException;
import org.eclipse.lemminx.uriresolver.URIResolverExtensionManager;
import org.eclipse.lemminx.utils.DOMUtils;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMErrorHandler;

public class CMXSDContentModelProvider
implements ContentModelProvider {
    private final URIResolverExtensionManager resolverExtensionManager;
    private XSLoaderImpl loader;

    public CMXSDContentModelProvider(URIResolverExtensionManager resolverExtensionManager) {
        this.resolverExtensionManager = resolverExtensionManager;
    }

    @Override
    public boolean adaptFor(DOMDocument document, boolean internal) {
        if (internal) {
            return false;
        }
        return document.hasSchemaLocation() || document.hasNoNamespaceSchemaLocation();
    }

    @Override
    public boolean adaptFor(String uri) {
        return DOMUtils.isXSD(uri);
    }

    @Override
    public String getSystemId(DOMDocument xmlDocument, String namespaceURI) {
        SchemaLocation schemaLocation = xmlDocument.getSchemaLocation();
        if (schemaLocation != null) {
            return schemaLocation.getLocationHint(namespaceURI);
        }
        NoNamespaceSchemaLocation noNamespaceSchemaLocation = xmlDocument.getNoNamespaceSchemaLocation();
        if (noNamespaceSchemaLocation != null) {
            if (namespaceURI != null) {
                return null;
            }
            return noNamespaceSchemaLocation.getLocation();
        }
        return null;
    }

    @Override
    public CMDocument createCMDocument(String key) {
        XSModel model = this.getLoader().loadURI(key);
        if (model != null) {
            return new CMXSDDocument(model, key);
        }
        return null;
    }

    @Override
    public CMDocument createInternalCMDocument(DOMDocument xmlDocument) {
        return null;
    }

    public XSLoaderImpl getLoader() {
        if (this.loader == null) {
            this.loader = this.getSynchLoader();
        }
        return this.loader;
    }

    private synchronized XSLoaderImpl getSynchLoader() {
        if (this.loader != null) {
            return this.loader;
        }
        XSLoaderImpl loader = new XSLoaderImpl();
        loader.setParameter("http://apache.org/xml/properties/internal/entity-resolver", (Object)this.resolverExtensionManager);
        loader.setParameter("error-handler", (Object)new DOMErrorHandler(){

            @Override
            public boolean handleError(DOMError error) {
                if (error.getRelatedException() instanceof CacheResourceDownloadingException) {
                    throw (CacheResourceDownloadingException)error.getRelatedException();
                }
                return false;
            }
        });
        return loader;
    }
}

