/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.prolog;

import com.google.common.base.Charsets;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.dom.parser.ScannerState;
import org.eclipse.lemminx.dom.parser.TokenType;
import org.eclipse.lemminx.services.AttributeCompletionItem;
import org.eclipse.lemminx.services.XMLCompletions;
import org.eclipse.lemminx.services.extensions.ICompletionRequest;
import org.eclipse.lemminx.services.extensions.ICompletionResponse;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lemminx.settings.XMLFormattingOptions;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.w3c.dom.NamedNodeMap;

public class PrologModel {
    private static final Logger LOGGER = Logger.getLogger(PrologModel.class.getName());
    public static final String VERSION_NAME = "version";
    public static final String ENCODING_NAME = "encoding";
    public static final String STANDALONE_NAME = "standalone";
    public static final String VERSION_1 = "1.0";
    public static final String VERSION_1_1 = "1.1";
    public static final String UTF_8 = Charsets.UTF_8.toString();
    public static final String ISO_8859_1 = Charsets.ISO_8859_1.toString();
    public static final String WINDOWS_1251 = "Windows-1251";
    public static final String WINDOWS_1252 = "Windows-1252";
    public static final String SHIFT_JIS = "Shift JIS";
    public static final String GB2312 = "GB2312";
    public static final String EUC_KR = "EUC-KR";
    public static final String YES = "yes";
    public static final String NO = "no";
    public static final List<String> VERSION_VALUES = Arrays.asList("1.0", "1.1");
    public static final List<String> ENCODING_VALUES = Arrays.asList(UTF_8, ISO_8859_1, "Windows-1251", "Windows-1252", "Shift JIS", "GB2312", "EUC-KR");
    public static final List<String> STANDALONE_VALUES = Arrays.asList("yes", "no");

    public static void computePrologCompletionResponses(int tokenEndOffset, String tag, ICompletionRequest request, ICompletionResponse response, boolean inPIState, SharedSettings settings) {
        DOMDocument document = request.getXMLDocument();
        CompletionItem item = new CompletionItem();
        item.setLabel("<?xml ... ?>");
        item.setKind(CompletionItemKind.Property);
        item.setFilterText("xml version=\"1.0\" encoding=\"UTF-8\"?>");
        boolean isSnippetsSupported = request.isCompletionSnippetsSupported();
        InsertTextFormat insertText = isSnippetsSupported ? InsertTextFormat.Snippet : InsertTextFormat.PlainText;
        item.setInsertTextFormat(insertText);
        int closingBracketOffset = inPIState ? XMLCompletions.getOffsetFollowedBy(document.getText(), tokenEndOffset, ScannerState.WithinPI, TokenType.PIEnd) : XMLCompletions.getOffsetFollowedBy(document.getText(), tokenEndOffset, ScannerState.WithinTag, TokenType.PrologEnd);
        closingBracketOffset = closingBracketOffset != -1 ? (closingBracketOffset += 2) : ((closingBracketOffset = XMLCompletions.getOffsetFollowedBy(document.getText(), tokenEndOffset, ScannerState.WithinTag, TokenType.StartTagClose)) == -1 ? tokenEndOffset : ++closingBracketOffset);
        int startOffset = tokenEndOffset - tag.length();
        try {
            Range editRange = XMLCompletions.getReplaceRange(startOffset, closingBracketOffset, request);
            String q = settings.getFormattingSettings().getQuotationAsString();
            String cursor = isSnippetsSupported ? "$0" : "";
            String text = MessageFormat.format("xml version={0}{1}{0} encoding={0}{2}{0}?>" + cursor, q, VERSION_1, UTF_8);
            item.setTextEdit(new TextEdit(editRange, text));
        }
        catch (BadLocationException e) {
            LOGGER.log(Level.SEVERE, "While performing getReplaceRange for prolog completion.", e);
        }
        response.addCompletionItem(item);
    }

    private static void createCompletionItem(String attrName, boolean canSupportSnippet, boolean generateValue, Range editRange, String defaultValue, Collection<String> enumerationValues, String documentation, ICompletionResponse response, XMLFormattingOptions formattingsSettings) {
        AttributeCompletionItem item = new AttributeCompletionItem(attrName, canSupportSnippet, editRange, generateValue, defaultValue, enumerationValues, formattingsSettings);
        MarkupContent markup = new MarkupContent();
        markup.setKind("markdown");
        markup.setValue(StringUtils.getDefaultString(documentation));
        item.setDocumentation(markup);
        response.addCompletionItem(item);
    }

    public static void computeAttributeNameCompletionResponses(ICompletionRequest request, ICompletionResponse response, Range editRange, DOMDocument document, XMLFormattingOptions formattingsSettings) throws BadLocationException {
        if (!document.hasProlog()) {
            return;
        }
        int offset = document.offsetAt(editRange.getStart());
        DOMNode prolog = document.findNodeAt(offset);
        if (!prolog.isProlog()) {
            return;
        }
        boolean isSnippetsSupported = request.isCompletionSnippetsSupported();
        int attrIndex = PrologModel.getAttributeCompletionPosition(offset, prolog);
        if (attrIndex == 0) {
            if (PrologModel.isCurrentAttributeEqual(VERSION_NAME, prolog, 0)) {
                return;
            }
            PrologModel.createCompletionItem(VERSION_NAME, isSnippetsSupported, true, editRange, VERSION_1, VERSION_VALUES, null, response, formattingsSettings);
            return;
        }
        if (attrIndex == 1) {
            if (PrologModel.isCurrentAttributeEqual(ENCODING_NAME, prolog, 1)) {
                return;
            }
            PrologModel.createCompletionItem(ENCODING_NAME, isSnippetsSupported, true, editRange, UTF_8, ENCODING_VALUES, null, response, formattingsSettings);
            if (!PrologModel.isCurrentAttributeEqual(STANDALONE_NAME, prolog, 1)) {
                PrologModel.createCompletionItem(STANDALONE_NAME, isSnippetsSupported, true, editRange, YES, STANDALONE_VALUES, null, response, formattingsSettings);
            }
            return;
        }
        if (attrIndex == 2) {
            DOMAttr attrBefore = prolog.getAttributeAtIndex(1);
            if (!STANDALONE_NAME.equals(attrBefore.getName()) && !PrologModel.isCurrentAttributeEqual(STANDALONE_NAME, prolog, 2)) {
                PrologModel.createCompletionItem(STANDALONE_NAME, isSnippetsSupported, true, editRange, YES, STANDALONE_VALUES, null, response, formattingsSettings);
            }
            return;
        }
    }

    public static void computeValueCompletionResponses(ICompletionRequest request, ICompletionResponse response, Range editRange, DOMDocument document, XMLFormattingOptions formattingSettings) throws BadLocationException {
        if (!document.hasProlog()) {
            return;
        }
        int offset = document.offsetAt(editRange.getStart());
        DOMNode prolog = document.findNodeAt(offset);
        if (!prolog.isProlog()) {
            return;
        }
        DOMAttr attr = prolog.findAttrAt(offset);
        if (VERSION_NAME.equals(attr.getName())) {
            PrologModel.createCompletionItemsForValues(VERSION_VALUES, editRange, document, request, response);
        } else if (ENCODING_NAME.equals(attr.getName())) {
            PrologModel.createCompletionItemsForValues(ENCODING_VALUES, editRange, document, request, response);
        } else if (STANDALONE_NAME.equals(attr.getName())) {
            PrologModel.createCompletionItemsForValues(STANDALONE_VALUES, editRange, document, request, response);
        }
    }

    private static void createCompletionItemsForValues(Collection<String> enumerationValues, Range editRange, DOMDocument document, ICompletionRequest request, ICompletionResponse response) {
        int sortText = 1;
        for (String option : enumerationValues) {
            String insertText = request.getInsertAttrValue(option);
            CompletionItem item = new CompletionItem();
            item.setLabel(option);
            item.setFilterText(insertText);
            item.setKind(CompletionItemKind.Enum);
            item.setTextEdit(new TextEdit(editRange, insertText));
            item.setSortText(Integer.toString(sortText));
            ++sortText;
            response.addCompletionItem(item);
        }
    }

    private static int getAttributeCompletionPosition(int completionOffset, DOMNode element) {
        NamedNodeMap attributeList = element.getAttributes();
        if (attributeList == null) {
            return 0;
        }
        int attributeListLength = attributeList.getLength();
        if (attributeListLength == 0) {
            return 0;
        }
        for (int i = 0; i < attributeListLength; ++i) {
            DOMAttr attr = element.getAttributeAtIndex(i);
            if (completionOffset > attr.getStart()) continue;
            return i;
        }
        return attributeListLength;
    }

    private static boolean isCurrentAttributeEqual(String attributeName, DOMNode element, int index) {
        NamedNodeMap attributeList = element.getAttributes();
        if (attributeList == null) {
            return false;
        }
        if (index >= attributeList.getLength()) {
            return false;
        }
        return attributeName.equals(element.getAttributeAtIndex(index).getName());
    }
}

