/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.cloud;

import java.util.Date;
import java.util.concurrent.Callable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.cloud.CloudClient;
import org.eclipse.kura.cloud.Cloudlet;
import org.eclipse.kura.cloud.CloudletTopic;
import org.eclipse.kura.message.KuraPayload;
import org.eclipse.kura.message.KuraRequestPayload;
import org.eclipse.kura.message.KuraResponsePayload;

class MessageHandlerCallable
implements Callable<Void> {
    private static final Logger logger = LogManager.getLogger(MessageHandlerCallable.class);
    private final Cloudlet cloudApp;
    private final String deviceId;
    private final String appTopic;
    private final KuraPayload msg;
    private final int qos;
    private final boolean retain;

    public MessageHandlerCallable(Cloudlet cloudApp, String deviceId, String appTopic, KuraPayload msg, int qos, boolean retain) {
        this.cloudApp = cloudApp;
        this.deviceId = deviceId;
        this.appTopic = appTopic;
        this.msg = msg;
        this.qos = qos;
        this.retain = retain;
    }

    @Override
    public Void call() throws Exception {
        logger.debug("Control Arrived on topic: {}", (Object)this.appTopic);
        KuraRequestPayload reqPayload = KuraRequestPayload.buildFromKuraPayload(this.msg);
        KuraResponsePayload respPayload = new KuraResponsePayload(200);
        try {
            CloudletTopic reqTopic = CloudletTopic.parseAppTopic(this.appTopic);
            CloudletTopic.Method method = reqTopic.getMethod();
            switch (method) {
                case GET: {
                    logger.debug("Handling GET request topic: {}", (Object)this.appTopic);
                    this.cloudApp.doGet(reqTopic, reqPayload, respPayload);
                    break;
                }
                case PUT: {
                    logger.debug("Handling PUT request topic: {}", (Object)this.appTopic);
                    this.cloudApp.doPut(reqTopic, reqPayload, respPayload);
                    break;
                }
                case POST: {
                    logger.debug("Handling POST request topic: {}", (Object)this.appTopic);
                    this.cloudApp.doPost(reqTopic, reqPayload, respPayload);
                    break;
                }
                case DEL: {
                    logger.debug("Handling DEL request topic: {}", (Object)this.appTopic);
                    this.cloudApp.doDel(reqTopic, reqPayload, respPayload);
                    break;
                }
                case EXEC: {
                    logger.debug("Handling EXEC request topic: {}", (Object)this.appTopic);
                    this.cloudApp.doExec(reqTopic, reqPayload, respPayload);
                    break;
                }
                default: {
                    logger.error("Bad request topic: {}", (Object)this.appTopic);
                    respPayload.setResponseCode(400);
                    break;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error("Bad request topic: {}", (Object)this.appTopic);
            respPayload.setResponseCode(400);
        }
        catch (KuraException e) {
            logger.error("Error handling request topic: {}\n{}", (Object)this.appTopic, (Object)e);
            respPayload.setResponseCode(500);
            respPayload.setException(e);
        }
        try {
            CloudClient cloudClient = this.cloudApp.getCloudApplicationClient();
            respPayload.setTimestamp(new Date());
            StringBuilder sb = new StringBuilder("REPLY").append("/").append(reqPayload.getRequestId());
            String requesterClientId = reqPayload.getRequesterClientId();
            logger.debug("Publishing response topic: {}", (Object)sb.toString());
            cloudClient.controlPublish(requesterClientId, sb.toString(), respPayload, 0, false, 1);
        }
        catch (KuraException e) {
            logger.error("Error publishing response for topic: {}\n{}", (Object)this.appTopic, (Object)e);
        }
        return null;
    }
}

