/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.shared.model;

import java.io.Serializable;
import java.util.List;
import org.eclipse.kura.web.shared.GwtSafeHtmlUtils;
import org.eclipse.kura.web.shared.model.GwtBaseModel;
import org.eclipse.kura.web.shared.model.GwtWifiBgscanModule;
import org.eclipse.kura.web.shared.model.GwtWifiCiphers;
import org.eclipse.kura.web.shared.model.GwtWifiHotspotEntry;
import org.eclipse.kura.web.shared.model.GwtWifiRadioMode;
import org.eclipse.kura.web.shared.model.GwtWifiSecurity;
import org.eclipse.kura.web.shared.model.GwtWifiWirelessMode;

public class GwtWifiConfig
extends GwtBaseModel
implements Serializable {
    private static final long serialVersionUID = -7610506986073264800L;
    private static final String IGNORE_SSID = "ignoreSSID";
    private static final String PING_ACCESS_POINT = "pingAccessPoint";
    private static final String BGSCAN_LONG_INTERVAL = "bgscanLongInterval";
    private static final String BGSCAN_SHORT_INTERVAL = "bgscanShortInterval";
    private static final String BGSCAN_RSSI_THRESHOLD = "bgscanRssiThreshold";
    private static final String BGSCAN_MODULE = "bgscanModule";
    private static final String PASSWORD = "password";
    private static final String GROUP_CIPHERS = "groupCiphers";
    private static final String PAIRWISE_CIPHERS = "pairwiseCiphers";
    private static final String SECURITY = "security";
    private static final String CHANNELS = "channels";
    private static final String RADIO_MODE = "radioMode";
    private static final String DRIVER = "driver";
    private static final String WIRELESS_SSID = "wirelessSsid";
    private static final String WIRELESS_MODE = "wirelessMode";
    private static final String CHANNELS_FREQUENCY = "ChannelsFrequency";
    private static final String COUNTRY_CODE = "CountryCode";

    public GwtWifiConfig() {
        this.setWirelessMode(GwtWifiWirelessMode.netWifiWirelessModeStation.name());
        this.setRadioMode(GwtWifiRadioMode.netWifiRadioModeBGN.name());
        this.setSecurity(GwtWifiSecurity.netWifiSecurityWPA2.name());
    }

    @Override
    public void set(String name, Object value) {
        Object escapedValue = value;
        if (value instanceof String) {
            escapedValue = GwtSafeHtmlUtils.htmlEscape((String)value);
        }
        super.set(name, escapedValue);
    }

    public String getWirelessMode() {
        return (String)this.get(WIRELESS_MODE);
    }

    public void setWirelessMode(String wirelessMode) {
        this.set(WIRELESS_MODE, wirelessMode);
    }

    public GwtWifiWirelessMode getWirelessModeEnum() {
        return GwtWifiWirelessMode.valueOf(this.getWirelessMode());
    }

    public String getWirelessSsid() {
        return (String)this.get(WIRELESS_SSID);
    }

    public void setWirelessSsid(String wirelessSsid) {
        this.set(WIRELESS_SSID, wirelessSsid);
    }

    public String getDriver() {
        return (String)this.get(DRIVER);
    }

    public void setDriver(String driver) {
        this.set(DRIVER, driver);
    }

    public String getRadioMode() {
        return (String)this.get(RADIO_MODE);
    }

    public void setRadioMode(String radioMode) {
        this.set(RADIO_MODE, radioMode);
    }

    public GwtWifiRadioMode getRadioModeEnum() {
        return GwtWifiRadioMode.valueOf(this.getRadioMode());
    }

    public List<Integer> getChannels() {
        return (List)this.get(CHANNELS);
    }

    public void setChannels(List<Integer> channels) {
        this.set(CHANNELS, channels);
    }

    public String getSecurity() {
        return (String)this.get(SECURITY);
    }

    public void setSecurity(String security) {
        this.set(SECURITY, security);
    }

    public GwtWifiSecurity getSecurityEnum() {
        return GwtWifiSecurity.valueOf(this.getSecurity());
    }

    public String getPairwiseCiphers() {
        return (String)this.get(PAIRWISE_CIPHERS);
    }

    public void setPairwiseCiphers(String ciphers) {
        this.set(PAIRWISE_CIPHERS, ciphers);
    }

    public GwtWifiCiphers getPairwiseCiphersEnum() {
        return GwtWifiCiphers.valueOf(this.getPairwiseCiphers());
    }

    public String getGroupCiphers() {
        return (String)this.get(GROUP_CIPHERS);
    }

    public void setGroupCiphers(String ciphers) {
        this.set(GROUP_CIPHERS, ciphers);
    }

    public GwtWifiCiphers getGroupCiphersEnum() {
        return GwtWifiCiphers.valueOf(this.getGroupCiphers());
    }

    public String getPassword() {
        String password = (String)this.get(PASSWORD);
        if (password != null) {
            return password;
        }
        return "";
    }

    public void setPassword(String password) {
        this.set(PASSWORD, password);
    }

    public String getBgscanModule() {
        return (String)this.get(BGSCAN_MODULE);
    }

    public void setBgscanModule(String bgscanModule) {
        this.set(BGSCAN_MODULE, bgscanModule);
    }

    public GwtWifiBgscanModule getBgscanModuleEnum() {
        return GwtWifiBgscanModule.valueOf(this.getBgscanModule());
    }

    public int getBgscanRssiThreshold() {
        Object bgScanRssiThreshold = this.get(BGSCAN_RSSI_THRESHOLD);
        if (bgScanRssiThreshold != null) {
            return (Integer)bgScanRssiThreshold;
        }
        return 0;
    }

    public void setBgscanRssiThreshold(int bgscanRssiThreshold) {
        this.set(BGSCAN_RSSI_THRESHOLD, bgscanRssiThreshold);
    }

    public int getBgscanShortInterval() {
        Object bgScanShortInterval = this.get(BGSCAN_SHORT_INTERVAL);
        if (bgScanShortInterval != null) {
            return (Integer)bgScanShortInterval;
        }
        return 0;
    }

    public void setBgscanShortInterval(int bgscanShortInterval) {
        this.set(BGSCAN_SHORT_INTERVAL, bgscanShortInterval);
    }

    public int getBgscanLongInterval() {
        Object bgScanLongInterval = this.get(BGSCAN_LONG_INTERVAL);
        if (bgScanLongInterval != null) {
            return (Integer)bgScanLongInterval;
        }
        return 0;
    }

    public void setBgscanLongInterval(int bgscanLongInterval) {
        this.set(BGSCAN_LONG_INTERVAL, bgscanLongInterval);
    }

    public boolean pingAccessPoint() {
        Object pingAccessPoint = this.get(PING_ACCESS_POINT);
        if (pingAccessPoint != null) {
            return (Boolean)pingAccessPoint;
        }
        return false;
    }

    public void setPingAccessPoint(boolean pingAccessPoint) {
        this.set(PING_ACCESS_POINT, pingAccessPoint);
    }

    public boolean ignoreSSID() {
        Object ignoreSsid = this.get(IGNORE_SSID);
        if (ignoreSsid != null) {
            return (Boolean)ignoreSsid;
        }
        return false;
    }

    public void setIgnoreSSID(boolean ignoreSSID) {
        this.set(IGNORE_SSID, ignoreSSID);
    }

    public List<GwtWifiHotspotEntry> getChannelsFrequency() {
        return (List)this.get(CHANNELS_FREQUENCY);
    }

    public void setChannelsFrequency(List<GwtWifiHotspotEntry> list) {
        this.set(CHANNELS_FREQUENCY, list);
    }

    public String getCountryCode() {
        return (String)this.get(COUNTRY_CODE);
    }

    public void setCountryCode(String countryCode) {
        this.set(COUNTRY_CODE, countryCode);
    }
}

