/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jkube.kit.service.buildpacks;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.jkube.kit.common.ExternalCommand;
import org.eclipse.jkube.kit.common.KitLogger;

public class BuildPackCommand
extends ExternalCommand {
    private final File packCli;
    private final List<String> commandLineArgs;
    private final StringBuilder errorBuilder;
    private final Consumer<String> commandOutputConsumer;

    public BuildPackCommand(KitLogger log, File packCli, List<String> cmdArgs, Consumer<String> outputConsumer) {
        super(log);
        this.packCli = packCli;
        this.commandLineArgs = cmdArgs;
        this.commandOutputConsumer = outputConsumer;
        this.errorBuilder = new StringBuilder();
    }

    public String[] getArgs() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.packCli.getAbsolutePath());
        args.addAll(this.commandLineArgs);
        return args.toArray(new String[0]);
    }

    public void processLine(String line) {
        this.commandOutputConsumer.accept(line);
    }

    public void processError(String error) {
        this.errorBuilder.append(error);
    }

    public String getError() {
        return this.errorBuilder.toString();
    }

    public int getExitCode() {
        return this.getStatusCode();
    }
}

