/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.managers;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.ls.core.internal.WorkspaceHelper;
import org.eclipse.jdt.ls.core.internal.managers.AbstractProjectsManagerBasedTest;
import org.junit.Assert;
import org.junit.Test;

public class MultiRootTest
extends AbstractProjectsManagerBasedTest {
    private static String EclipseFolder = "eclipse/hello";
    private static String MavenFolder = "maven/salut";
    private static String MavenMultiFolder = "maven/multi";
    private static String GradleFolder = "gradle/simple-gradle";

    @Test
    public void testInitializeWithMultiFolders() throws Exception {
        List<String> folders = Arrays.asList(EclipseFolder, MavenFolder);
        this.importProjects(folders);
        Assert.assertEquals((long)3L, (long)WorkspaceHelper.getAllProjects().size());
        Assert.assertNotNull((Object)WorkspaceHelper.getProject("hello"));
        Assert.assertNotNull((Object)WorkspaceHelper.getProject("salut"));
        folders = Arrays.asList(MavenMultiFolder, EclipseFolder);
        this.importProjects(folders);
        Assert.assertEquals((long)4L, (long)WorkspaceHelper.getAllProjects().size());
        Assert.assertNotNull((Object)WorkspaceHelper.getProject("hello"));
        Assert.assertNull((Object)WorkspaceHelper.getProject("salut"));
        Assert.assertNotNull((Object)WorkspaceHelper.getProject("project1"));
        Assert.assertNotNull((Object)WorkspaceHelper.getProject("project2"));
    }

    @Test
    public void testUpdateMultiFolders() throws Exception {
        List<String> folders = Arrays.asList(EclipseFolder, MavenFolder);
        this.importProjects(folders);
        Assert.assertEquals((long)3L, (long)WorkspaceHelper.getAllProjects().size());
        Assert.assertNotNull((Object)WorkspaceHelper.getProject("hello"));
        Assert.assertNotNull((Object)WorkspaceHelper.getProject("salut"));
        List<String> toAdd = Arrays.asList(MavenMultiFolder);
        List<String> toRemove = Arrays.asList(MavenFolder);
        this.updateProjects(toAdd, toRemove);
        Assert.assertEquals((long)4L, (long)WorkspaceHelper.getAllProjects().size());
        Assert.assertNotNull((Object)WorkspaceHelper.getProject("hello"));
        Assert.assertNull((Object)WorkspaceHelper.getProject("salut"));
        Assert.assertNotNull((Object)WorkspaceHelper.getProject("project1"));
        Assert.assertNotNull((Object)WorkspaceHelper.getProject("project2"));
        toAdd = Arrays.asList(MavenFolder);
        toRemove = Arrays.asList(MavenMultiFolder);
        this.updateProjects(toAdd, toRemove);
        Assert.assertEquals((long)3L, (long)WorkspaceHelper.getAllProjects().size());
        Assert.assertNotNull((Object)WorkspaceHelper.getProject("hello"));
        Assert.assertNotNull((Object)WorkspaceHelper.getProject("salut"));
        Assert.assertNull((Object)WorkspaceHelper.getProject("project1"));
        Assert.assertNull((Object)WorkspaceHelper.getProject("project2"));
        toAdd = Arrays.asList(GradleFolder);
        toRemove = Arrays.asList(EclipseFolder, MavenFolder);
        this.updateProjects(toAdd, toRemove);
        Assert.assertEquals((long)2L, (long)WorkspaceHelper.getAllProjects().size());
        Assert.assertNull((Object)WorkspaceHelper.getProject("hello"));
        Assert.assertNull((Object)WorkspaceHelper.getProject("salut"));
        Assert.assertNotNull((Object)WorkspaceHelper.getProject("simple-gradle"));
    }

    private void updateProjects(Collection<String> added, Collection<String> removed) throws Exception {
        ArrayList<IPath> addedRootPaths = new ArrayList<IPath>();
        for (String a : added) {
            File file = this.copyFiles(a, false);
            addedRootPaths.add(Path.fromOSString((String)file.getAbsolutePath()));
        }
        ArrayList<IPath> removedRootPaths = new ArrayList<IPath>();
        for (String r : removed) {
            File file = new File(this.getWorkingProjectDirectory(), r);
            removedRootPaths.add(Path.fromOSString((String)file.getAbsolutePath()));
        }
        Job job = this.projectsManager.updateWorkspaceFolders(addedRootPaths, removedRootPaths);
        job.join();
        this.waitForBackgroundJobs();
    }
}

