/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.Arrays;
import org.eclipse.jdt.ls.core.internal.handlers.WorkspaceExecuteCommandHandler;
import org.eclipse.jdt.ls.core.internal.managers.AbstractProjectsManagerBasedTest;
import org.eclipse.lsp4j.ExecuteCommandParams;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class WorkspaceExecuteCommandHandlerTest
extends AbstractProjectsManagerBasedTest {
    @Rule
    public ExpectedException expectedEx = ExpectedException.none();

    @Test
    public void testExecuteCommand() {
        WorkspaceExecuteCommandHandler handler = new WorkspaceExecuteCommandHandler();
        ExecuteCommandParams params = new ExecuteCommandParams();
        params.setCommand("testcommand1");
        params.setArguments(Arrays.asList("hello", "world"));
        Object result = handler.executeCommand(params, this.monitor);
        Assert.assertEquals((Object)"testcommand1: helloworld0", (Object)result);
        params.setCommand("testcommand2");
        result = handler.executeCommand(params, this.monitor);
        Assert.assertEquals((Object)"testcommand2: helloworld1", (Object)result);
    }

    @Test
    public void testExecuteCommandNonexistingCommand() {
        this.expectedEx.expect(ResponseErrorException.class);
        this.expectedEx.expectMessage("No delegateCommandHandler for testcommand.not.existing");
        WorkspaceExecuteCommandHandler handler = new WorkspaceExecuteCommandHandler();
        ExecuteCommandParams params = new ExecuteCommandParams();
        params.setCommand("testcommand.not.existing");
        params.setArguments(Arrays.asList("hello", "world"));
        Object result = handler.executeCommand(params, this.monitor);
    }

    @Test
    public void testExecuteCommandMorethanOneCommand() {
        this.expectedEx.expect(ResponseErrorException.class);
        this.expectedEx.expectMessage((Matcher)new Matcher<String>(){

            public void describeTo(Description description) {
            }

            public boolean matches(Object item) {
                return ((String)item).startsWith("Found multiple delegateCommandHandlers");
            }

            public void describeMismatch(Object item, Description mismatchDescription) {
            }

            public void _dont_implement_Matcher___instead_extend_BaseMatcher_() {
            }
        });
        WorkspaceExecuteCommandHandler handler = new WorkspaceExecuteCommandHandler();
        ExecuteCommandParams params = new ExecuteCommandParams();
        params.setCommand("dup");
        handler.executeCommand(params, this.monitor);
    }

    @Test
    public void testExecuteCommandThrowsExceptionCommand() {
        this.expectedEx.expect(ResponseErrorException.class);
        this.expectedEx.expectMessage("Unsupported");
        WorkspaceExecuteCommandHandler handler = new WorkspaceExecuteCommandHandler();
        ExecuteCommandParams params = new ExecuteCommandParams();
        params.setCommand("testcommand.throwexception");
        handler.executeCommand(params, this.monitor);
    }

    @Test
    public void testExecuteCommandInvalidParameters() {
        this.expectedEx.expect(ResponseErrorException.class);
        this.expectedEx.expectMessage("The workspace/executeCommand has empty params or command");
        WorkspaceExecuteCommandHandler handler = new WorkspaceExecuteCommandHandler();
        ExecuteCommandParams params = null;
        handler.executeCommand(params, this.monitor);
    }
}

