/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.handlers.InitHandler;
import org.eclipse.jdt.ls.core.internal.handlers.WorkspaceDiagnosticsHandler;
import org.eclipse.jdt.ls.core.internal.managers.AbstractProjectsManagerBasedTest;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class WorkspaceDiagnosticsHandlerTest
extends AbstractProjectsManagerBasedTest {
    @Mock
    private JavaClientConnection connection;
    @InjectMocks
    private WorkspaceDiagnosticsHandler handler;

    @Test
    public void testToDiagnosticsArray() throws Exception {
        String msg1 = "Something's wrong Jim";
        IMarker m1 = this.createMarker(1, msg1, 2, 95, 100);
        String msg2 = "He's dead";
        IMarker m2 = this.createMarker(2, msg2, 10, 1015, 1025);
        String msg3 = "It's probably time to panic";
        IMarker m3 = this.createMarker(42, msg3, 100, 10000, 10005);
        IDocument d = (IDocument)Mockito.mock(IDocument.class);
        Mockito.when((Object)d.getLineOffset(1)).thenReturn((Object)90);
        Mockito.when((Object)d.getLineOffset(9)).thenReturn((Object)1000);
        Mockito.when((Object)d.getLineOffset(99)).thenReturn((Object)10000);
        List diags = WorkspaceDiagnosticsHandler.toDiagnosticsArray((IDocument)d, (IMarker[])new IMarker[]{m1, m2, m3});
        Assert.assertEquals((long)3L, (long)diags.size());
        Diagnostic d1 = (Diagnostic)diags.get(0);
        Assert.assertEquals((Object)msg1, (Object)d1.getMessage());
        Assert.assertEquals((Object)DiagnosticSeverity.Warning, (Object)d1.getSeverity());
        Range r = d1.getRange();
        Assert.assertEquals((long)1L, (long)r.getStart().getLine());
        Assert.assertEquals((long)5L, (long)r.getStart().getCharacter());
        Assert.assertEquals((long)1L, (long)r.getEnd().getLine());
        Assert.assertEquals((long)10L, (long)r.getEnd().getCharacter());
        Diagnostic d2 = (Diagnostic)diags.get(1);
        Assert.assertEquals((Object)msg2, (Object)d2.getMessage());
        Assert.assertEquals((Object)DiagnosticSeverity.Error, (Object)d2.getSeverity());
        r = d2.getRange();
        Assert.assertEquals((long)9L, (long)r.getStart().getLine());
        Assert.assertEquals((long)15L, (long)r.getStart().getCharacter());
        Assert.assertEquals((long)9L, (long)r.getEnd().getLine());
        Assert.assertEquals((long)25L, (long)r.getEnd().getCharacter());
        Diagnostic d3 = (Diagnostic)diags.get(2);
        Assert.assertEquals((Object)msg3, (Object)d3.getMessage());
        Assert.assertEquals((Object)DiagnosticSeverity.Information, (Object)d3.getSeverity());
        r = d3.getRange();
        Assert.assertEquals((long)99L, (long)r.getStart().getLine());
        Assert.assertEquals((long)0L, (long)r.getStart().getCharacter());
        Assert.assertEquals((long)99L, (long)r.getEnd().getLine());
        Assert.assertEquals((long)5L, (long)r.getEnd().getCharacter());
    }

    @Test
    public void testMavenMarkers() throws Exception {
        String msg1 = "Some dependency is missing";
        IMarker m1 = this.createMavenMarker(2, msg1, 2, 95, 100);
        IDocument d = (IDocument)Mockito.mock(IDocument.class);
        Mockito.when((Object)d.getLineOffset(1)).thenReturn((Object)90);
        IMarker[] iMarkerArray = new IMarker[2];
        iMarkerArray[0] = m1;
        List diags = WorkspaceDiagnosticsHandler.toDiagnosticsArray((IDocument)d, (IMarker[])iMarkerArray);
        Assert.assertEquals((long)1L, (long)diags.size());
        Diagnostic d1 = (Diagnostic)diags.get(0);
        Assert.assertEquals((Object)msg1, (Object)d1.getMessage());
        Assert.assertEquals((Object)DiagnosticSeverity.Error, (Object)d1.getSeverity());
        Range r = d1.getRange();
        Assert.assertEquals((long)1L, (long)r.getStart().getLine());
        Assert.assertEquals((long)95L, (long)r.getStart().getCharacter());
        Assert.assertEquals((long)1L, (long)r.getEnd().getLine());
        Assert.assertEquals((long)100L, (long)r.getEnd().getCharacter());
    }

    @Test
    public void testMarkerListening() throws Exception {
        InitHandler initHandler = new InitHandler(this.projectsManager, this.preferenceManager, this.connection);
        initHandler.addWorkspaceDiagnosticsHandler();
        this.importProjects("maven/broken");
        ArgumentCaptor captor = ArgumentCaptor.forClass(PublishDiagnosticsParams.class);
        ((JavaClientConnection)Mockito.verify((Object)this.connection, (VerificationMode)Mockito.atLeastOnce())).publishDiagnostics((PublishDiagnosticsParams)captor.capture());
        List allCalls = captor.getAllValues();
        Collections.reverse(allCalls);
        this.projectsManager.setConnection(this.client);
        Optional<PublishDiagnosticsParams> fooDiags = allCalls.stream().filter(p -> p.getUri().endsWith("Foo.java")).findFirst();
        Assert.assertTrue((String)"No Foo.java errors were found", (boolean)fooDiags.isPresent());
        List diags = fooDiags.get().getDiagnostics();
        Comparator comparator = (d1, d2) -> {
            int diff = d1.getRange().getStart().getLine() - d2.getRange().getStart().getLine();
            if (diff == 0) {
                diff = d1.getMessage().compareTo(d2.getMessage());
            }
            return diff;
        };
        Collections.sort(diags, comparator);
        Assert.assertEquals((String)diags.toString(), (long)2L, (long)diags.size());
        Assert.assertEquals((Object)"The import org cannot be resolved", (Object)((Diagnostic)diags.get(0)).getMessage());
        Assert.assertEquals((Object)"StringUtils cannot be resolved", (Object)((Diagnostic)diags.get(1)).getMessage());
        Optional<PublishDiagnosticsParams> pomDiags = allCalls.stream().filter(p -> p.getUri().endsWith("pom.xml")).findFirst();
        Assert.assertTrue((String)"No pom.xml errors were found", (boolean)pomDiags.isPresent());
        diags = pomDiags.get().getDiagnostics();
        Collections.sort(diags, comparator);
        Assert.assertEquals((String)diags.toString(), (long)3L, (long)diags.size());
        Assert.assertTrue((boolean)((Diagnostic)diags.get(0)).getMessage().startsWith("For artifact {org.apache.commons:commons-lang3:null:jar}: The version cannot be empty. (org.apache.maven.plugins:maven-resources-plugin:2.6:resources:default-resources:process-resources)"));
        Assert.assertTrue((boolean)((Diagnostic)diags.get(1)).getMessage().startsWith("For artifact {org.apache.commons:commons-lang3:null:jar}: The version cannot be empty. (org.apache.maven.plugins:maven-resources-plugin:2.6:testResources:default-testResources:process-test-resources)"));
        Assert.assertEquals((Object)"Project build error: 'dependencies.dependency.version' for org.apache.commons:commons-lang3:jar is missing.", (Object)((Diagnostic)diags.get(2)).getMessage());
    }

    private IMarker createMarker(int severity, String msg, int line, int start, int end) {
        IMarker m = (IMarker)Mockito.mock(IMarker.class);
        Mockito.when((Object)m.exists()).thenReturn((Object)true);
        Mockito.when((Object)m.getAttribute("severity", -1)).thenReturn((Object)severity);
        Mockito.when((Object)m.getAttribute("message", "")).thenReturn((Object)msg);
        Mockito.when((Object)m.getAttribute("lineNumber", -1)).thenReturn((Object)line);
        Mockito.when((Object)m.getAttribute("charStart", -1)).thenReturn((Object)start);
        Mockito.when((Object)m.getAttribute("charEnd", -1)).thenReturn((Object)end);
        return m;
    }

    private IMarker createMavenMarker(int severity, String msg, int line, int start, int end) throws Exception {
        IMarker m = this.createMarker(severity, msg, line, start, end);
        Mockito.when((Object)m.isSubtypeOf("org.eclipse.m2e.core.maven2Problem")).thenReturn((Object)true);
        Mockito.when((Object)m.getAttribute("message", "")).thenReturn((Object)msg);
        Mockito.when((Object)m.getAttribute("columnStart", -1)).thenReturn((Object)start);
        Mockito.when((Object)m.getAttribute("columnEnd", -1)).thenReturn((Object)end);
        return m;
    }

    @After
    public void removeResourceChangeListener() {
        InitHandler.removeWorkspaceDiagnosticsHandler();
    }
}

