/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.net.URI;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.JsonMessageHelper;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.WorkspaceHelper;
import org.eclipse.jdt.ls.core.internal.handlers.AbstractCompilationUnitBasedTest;
import org.eclipse.jdt.ls.core.internal.handlers.SignatureHelpHandler;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SignatureInformation;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class SignatureHelpHandlerTest
extends AbstractCompilationUnitBasedTest {
    private PreferenceManager preferenceManager;
    private static String HOVER_TEMPLATE = "{\n    \"id\": \"1\",\n    \"method\": \"textDocument/signatureHelp\",\n    \"params\": {\n        \"textDocument\": {\n            \"uri\": \"${file}\"\n        },\n        \"position\": {\n            \"line\": ${line},\n            \"character\": ${char}\n        }\n    },\n    \"jsonrpc\": \"2.0\"\n}";
    private SignatureHelpHandler handler;
    private IPackageFragmentRoot sourceFolder;

    @Override
    @Before
    public void setup() throws Exception {
        this.importProjects("eclipse/hello");
        this.project = WorkspaceHelper.getProject("hello");
        IJavaProject javaProject = JavaCore.create((IProject)this.project);
        this.sourceFolder = javaProject.getPackageFragmentRoot((IResource)javaProject.getProject().getFolder("src"));
        this.preferenceManager = (PreferenceManager)Mockito.mock(PreferenceManager.class);
        Preferences p = (Preferences)Mockito.mock(Preferences.class);
        Mockito.when((Object)this.preferenceManager.getPreferences(null)).thenReturn((Object)p);
        Mockito.when((Object)p.isSignatureHelpEnabled()).thenReturn((Object)true);
        this.handler = new SignatureHelpHandler(this.preferenceManager);
    }

    @Test
    public void testSignatureHelp_singleMethod() throws JavaModelException {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("   /** This is a method */\n");
        buf.append("   public int foo(String s) { }\n");
        buf.append("   public int bar(String s) { this.foo() }\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        SignatureHelp help = this.getSignatureHelp(cu, 4, 39);
        Assert.assertNotNull((Object)help);
        Assert.assertEquals((long)help.getSignatures().size(), (long)1L);
        Assert.assertEquals((Object)((SignatureInformation)help.getSignatures().get(0)).getLabel(), (Object)"foo(String s) : int");
        Assert.assertTrue((((SignatureInformation)help.getSignatures().get(0)).getDocumentation().length() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testSignatureHelp_multipeMethod() throws JavaModelException {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("   public int foo(String s) { }\n");
        buf.append("   public int foo(int s) { }\n");
        buf.append("   public int foo(int s, String s) { }\n");
        buf.append("   public int bar(String s) { this.foo(2,  ) }\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        SignatureHelp help = this.getSignatureHelp(cu, 5, 42);
        Assert.assertNotNull((Object)help);
        Assert.assertEquals((long)help.getSignatures().size(), (long)3L);
        Assert.assertEquals((Object)help.getActiveParameter(), (Object)1);
        Assert.assertEquals((Object)((SignatureInformation)help.getSignatures().get(help.getActiveSignature())).getLabel(), (Object)"foo(int s, String s) : int");
    }

    @Test
    public void testSignatureHelp_binary() throws JavaModelException {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        StringBuilder buf = new StringBuilder();
        buf.append("package test1;\n");
        buf.append("public class E {\n");
        buf.append("   public int bar(String s) { System.out.println(  }\n");
        buf.append("}\n");
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", buf.toString(), false, null);
        SignatureHelp help = this.getSignatureHelp(cu, 2, 50);
        Assert.assertNotNull((Object)help);
        Assert.assertTrue((help.getSignatures().size() >= 10 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)((SignatureInformation)help.getSignatures().get(help.getActiveSignature())).getLabel().matches("println\\(\\w+ \\w+\\) : void"));
    }

    private SignatureHelp getSignatureHelp(ICompilationUnit cu, int line, int character) {
        String payload = this.createSignatureHelpRequest(cu, line, character);
        TextDocumentPositionParams position = (TextDocumentPositionParams)JsonMessageHelper.getParams(payload);
        return this.handler.signatureHelp(position, this.monitor);
    }

    String createSignatureHelpRequest(ICompilationUnit cu, int line, int kar) {
        URI uri = cu.getResource().getRawLocationURI();
        return this.createSignatureHelpRequest(uri, line, kar);
    }

    String createSignatureHelpRequest(URI file, int line, int kar) {
        String fileURI = ResourceUtils.fixURI((URI)file);
        return HOVER_TEMPLATE.replace("${file}", fileURI).replace("${line}", String.valueOf(line)).replace("${char}", String.valueOf(kar));
    }
}

