/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.Collection;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.TextEditUtil;
import org.eclipse.jdt.ls.core.internal.handlers.RenameHandler;
import org.eclipse.jdt.ls.core.internal.managers.AbstractProjectsManagerBasedTest;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class RenameHandlerTest
extends AbstractProjectsManagerBasedTest {
    private RenameHandler handler;
    private PreferenceManager preferenceManager;
    private IPackageFragmentRoot sourceFolder;

    @Before
    public void setup() throws Exception {
        IJavaProject javaProject = this.newEmptyProject();
        this.sourceFolder = javaProject.getPackageFragmentRoot((IResource)javaProject.getProject().getFolder("src"));
        this.preferenceManager = (PreferenceManager)Mockito.mock(PreferenceManager.class);
        Preferences p = (Preferences)Mockito.mock(Preferences.class);
        Mockito.when((Object)this.preferenceManager.getPreferences()).thenReturn((Object)p);
        Mockito.when((Object)p.isRenameEnabled()).thenReturn((Object)true);
        this.handler = new RenameHandler(this.preferenceManager);
    }

    @Test
    public void testRenameParameter() throws JavaModelException, BadLocationException {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        String[] codes = new String[]{"package test1;\n", "public class E {\n", "   public int foo(String str) {\n", "  \t\tstr|*.length();\n", "   }\n", "   public int bar(String str) {\n", "   \tstr.length();\n", "   }\n", "}\n"};
        StringBuilder builder = new StringBuilder();
        Position pos = this.mergeCode(builder, codes);
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", builder.toString(), false, null);
        WorkspaceEdit edit = this.getRenameEdit(cu, pos, "newname");
        Assert.assertNotNull((Object)edit);
        Assert.assertEquals((long)edit.getChanges().size(), (long)1L);
        Assert.assertEquals((Object)TextEditUtil.apply(builder.toString(), (Collection<? extends TextEdit>)((Collection)edit.getChanges().get(JDTUtils.toURI((ICompilationUnit)cu)))), (Object)"package test1;\npublic class E {\n   public int foo(String newname) {\n  \t\tnewname.length();\n   }\n   public int bar(String str) {\n   \tstr.length();\n   }\n}\n");
    }

    @Test
    public void testRenameLocalVariable() throws JavaModelException, BadLocationException {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        String[] codes = new String[]{"package test1;\n", "public class E {\n", "   public int bar() {\n", "\t\tString str = new String();\n", "   \tstr.length();\n", "   }\n", "   public int foo() {\n", "\t\tString str = new String();\n", "   \tstr|*.length()\n", "   }\n", "}\n"};
        StringBuilder builder = new StringBuilder();
        Position pos = this.mergeCode(builder, codes);
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", builder.toString(), false, null);
        WorkspaceEdit edit = this.getRenameEdit(cu, pos, "newname");
        Assert.assertNotNull((Object)edit);
        Assert.assertEquals((long)edit.getChanges().size(), (long)1L);
        Assert.assertEquals((Object)TextEditUtil.apply(builder.toString(), (Collection<? extends TextEdit>)((Collection)edit.getChanges().get(JDTUtils.toURI((ICompilationUnit)cu)))), (Object)"package test1;\npublic class E {\n   public int bar() {\n\t\tString str = new String();\n   \tstr.length();\n   }\n   public int foo() {\n\t\tString newname = new String();\n   \tnewname.length()\n   }\n}\n");
    }

    @Test
    public void testRenameField() throws JavaModelException, BadLocationException {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        String[] codes = new String[]{"package test1;\n", "public class E {\n", "\tprivate int myValue = 2;\n", "   public void bar() {\n", "\t\tmyValue|* = 3;\n", "   }\n", "}\n"};
        StringBuilder builder = new StringBuilder();
        Position pos = this.mergeCode(builder, codes);
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", builder.toString(), false, null);
        WorkspaceEdit edit = this.getRenameEdit(cu, pos, "newname");
        Assert.assertNotNull((Object)edit);
        Assert.assertEquals((long)edit.getChanges().size(), (long)1L);
        Assert.assertEquals((Object)TextEditUtil.apply(builder.toString(), (Collection<? extends TextEdit>)((Collection)edit.getChanges().get(JDTUtils.toURI((ICompilationUnit)cu)))), (Object)"package test1;\npublic class E {\n\tprivate int newname = 2;\n   public void bar() {\n\t\tnewname = 3;\n   }\n}\n");
    }

    @Test
    public void testRenameMethod() throws JavaModelException, BadLocationException {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        String[] codes = new String[]{"package test1;\n", "public class E {\n", "   public int bar() {\n", "   }\n", "   public int foo() {\n", "\t\tthis.bar|*();\n", "   }\n", "}\n"};
        StringBuilder builder = new StringBuilder();
        Position pos = this.mergeCode(builder, codes);
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", builder.toString(), false, null);
        WorkspaceEdit edit = this.getRenameEdit(cu, pos, "newname");
        Assert.assertNotNull((Object)edit);
        Assert.assertEquals((long)edit.getChanges().size(), (long)1L);
        Assert.assertEquals((Object)TextEditUtil.apply(builder.toString(), (Collection<? extends TextEdit>)((Collection)edit.getChanges().get(JDTUtils.toURI((ICompilationUnit)cu)))), (Object)"package test1;\npublic class E {\n   public int newname() {\n   }\n   public int foo() {\n\t\tthis.newname();\n   }\n}\n");
    }

    @Test
    public void testRenameSystemLibrary() throws JavaModelException {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        String[] codes = new String[]{"package test1;\n", "public class E {\n", "   public int bar() {\n", "\t\tString str = new String();\n", "   \tstr.len|*gth();\n", "   }\n", "}\n"};
        StringBuilder builder = new StringBuilder();
        Position pos = this.mergeCode(builder, codes);
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", builder.toString(), false, null);
        WorkspaceEdit edit = this.getRenameEdit(cu, pos, "newname");
        Assert.assertNotNull((Object)edit);
        Assert.assertEquals((long)edit.getChanges().size(), (long)0L);
    }

    @Test
    public void testRenameMultipleFiles() throws JavaModelException, BadLocationException {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        String[] codes1 = new String[]{"package test1;\n", "public class A {\n", "   public void foo() {\n", "   }\n", "}\n"};
        String[] codes2 = new String[]{"package test1;\n", "public class B {\n", "   public void foo() {\n", "\t\tA a = new A();\n", "\t\ta.foo|*();\n", "   }\n", "}\n"};
        StringBuilder builderA = new StringBuilder();
        this.mergeCode(builderA, codes1);
        ICompilationUnit cuA = pack1.createCompilationUnit("A.java", builderA.toString(), false, null);
        StringBuilder builderB = new StringBuilder();
        Position pos = this.mergeCode(builderB, codes2);
        ICompilationUnit cuB = pack1.createCompilationUnit("B.java", builderB.toString(), false, null);
        WorkspaceEdit edit = this.getRenameEdit(cuB, pos, "newname");
        Assert.assertNotNull((Object)edit);
        Assert.assertEquals((long)edit.getChanges().size(), (long)2L);
        Assert.assertEquals((Object)TextEditUtil.apply(builderA.toString(), (Collection<? extends TextEdit>)((Collection)edit.getChanges().get(JDTUtils.toURI((ICompilationUnit)cuA)))), (Object)"package test1;\npublic class A {\n   public void newname() {\n   }\n}\n");
        Assert.assertEquals((Object)TextEditUtil.apply(builderB.toString(), (Collection<? extends TextEdit>)((Collection)edit.getChanges().get(JDTUtils.toURI((ICompilationUnit)cuB)))), (Object)"package test1;\npublic class B {\n   public void foo() {\n\t\tA a = new A();\n\t\ta.newname();\n   }\n}\n");
    }

    @Test
    public void testRenameOverrideMethodSimple() throws JavaModelException, BadLocationException {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        String[] codes1 = new String[]{"package test1;\n", "public class A {\n", "   public void foo(){}\n", "}\n"};
        String[] codes2 = new String[]{"package test1;\n", "public class B extends A {\n", "\t@Override\n", "   public void foo|*() {\n", "   }\n", "}\n"};
        StringBuilder builderA = new StringBuilder();
        this.mergeCode(builderA, codes1);
        ICompilationUnit cuA = pack1.createCompilationUnit("A.java", builderA.toString(), false, null);
        StringBuilder builderB = new StringBuilder();
        Position pos = this.mergeCode(builderB, codes2);
        ICompilationUnit cuB = pack1.createCompilationUnit("B.java", builderB.toString(), false, null);
        WorkspaceEdit edit = this.getRenameEdit(cuB, pos, "newname");
        Assert.assertNotNull((Object)edit);
        Assert.assertEquals((long)edit.getChanges().size(), (long)2L);
        Assert.assertEquals((Object)TextEditUtil.apply(builderA.toString(), (Collection<? extends TextEdit>)((Collection)edit.getChanges().get(JDTUtils.toURI((ICompilationUnit)cuA)))), (Object)"package test1;\npublic class A {\n   public void newname(){}\n}\n");
        Assert.assertEquals((Object)TextEditUtil.apply(builderB.toString(), (Collection<? extends TextEdit>)((Collection)edit.getChanges().get(JDTUtils.toURI((ICompilationUnit)cuB)))), (Object)"package test1;\npublic class B extends A {\n\t@Override\n   public void newname() {\n   }\n}\n");
    }

    @Test
    public void testRenameOverrideMethodComplex() throws JavaModelException, BadLocationException {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        String[] codes = new String[]{"package test1;\n", "class B extends A {\n", "\tpublic void foo|*() {\n", "\t};\n", "}\n", "abstract class A {\n", "\tpublic abstract void foo();\n", "}\n", "class C extends A implements D {\n", "\tpublic void foo() {\n", "\t};\n", "}\n", "interface D {\n", "\tvoid foo();\n", "}\n"};
        StringBuilder builder = new StringBuilder();
        Position pos = this.mergeCode(builder, codes);
        ICompilationUnit cu = pack1.createCompilationUnit("A.java", builder.toString(), false, null);
        WorkspaceEdit edit = this.getRenameEdit(cu, pos, "newfoo");
        Assert.assertNotNull((Object)edit);
        Assert.assertEquals((long)edit.getChanges().size(), (long)1L);
        Assert.assertEquals((Object)TextEditUtil.apply(builder.toString(), (Collection<? extends TextEdit>)((Collection)edit.getChanges().get(JDTUtils.toURI((ICompilationUnit)cu)))), (Object)"package test1;\nclass B extends A {\n\tpublic void newfoo() {\n\t};\n}\nabstract class A {\n\tpublic abstract void newfoo();\n}\nclass C extends A implements D {\n\tpublic void newfoo() {\n\t};\n}\ninterface D {\n\tvoid newfoo();\n}\n");
    }

    @Test
    public void testRenameInterfaceMethod() throws JavaModelException, BadLocationException {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        String[] codes1 = new String[]{"package test1;\n", "public interface A {\n", "   public void foo();\n", "}\n"};
        String[] codes2 = new String[]{"package test1;\n", "public class B implements A {\n", "\t@Override\n", "   public void foo|*() {\n", "   }\n", "}\n"};
        StringBuilder builderA = new StringBuilder();
        this.mergeCode(builderA, codes1);
        ICompilationUnit cuA = pack1.createCompilationUnit("A.java", builderA.toString(), false, null);
        StringBuilder builderB = new StringBuilder();
        Position pos = this.mergeCode(builderB, codes2);
        ICompilationUnit cuB = pack1.createCompilationUnit("B.java", builderB.toString(), false, null);
        WorkspaceEdit edit = this.getRenameEdit(cuB, pos, "newname");
        Assert.assertNotNull((Object)edit);
        Assert.assertEquals((long)edit.getChanges().size(), (long)2L);
        Assert.assertEquals((Object)TextEditUtil.apply(builderA.toString(), (Collection<? extends TextEdit>)((Collection)edit.getChanges().get(JDTUtils.toURI((ICompilationUnit)cuA)))), (Object)"package test1;\npublic interface A {\n   public void newname();\n}\n");
        Assert.assertEquals((Object)TextEditUtil.apply(builderB.toString(), (Collection<? extends TextEdit>)((Collection)edit.getChanges().get(JDTUtils.toURI((ICompilationUnit)cuB)))), (Object)"package test1;\npublic class B implements A {\n\t@Override\n   public void newname() {\n   }\n}\n");
    }

    @Test
    public void testRenameType() throws JavaModelException, BadLocationException {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        String[] codes1 = new String[]{"package test1;\n", "public class A {\n", "   public void foo(){\n", "\t\tB b = new B();\n", "\t\tb.foo();\n", "\t}\n", "}\n"};
        String[] codes2 = new String[]{"package test1;\n", "public class B|* {\n", "\tpublic B() {}\n", "   public void foo() {}\n", "}\n"};
        StringBuilder builderA = new StringBuilder();
        this.mergeCode(builderA, codes1);
        ICompilationUnit cuA = pack1.createCompilationUnit("A.java", builderA.toString(), false, null);
        StringBuilder builderB = new StringBuilder();
        Position pos = this.mergeCode(builderB, codes2);
        ICompilationUnit cuB = pack1.createCompilationUnit("B.java", builderB.toString(), false, null);
        WorkspaceEdit edit = this.getRenameEdit(cuB, pos, "NewType");
        Assert.assertNotNull((Object)edit);
        Assert.assertEquals((long)edit.getChanges().size(), (long)2L);
        Assert.assertEquals((Object)TextEditUtil.apply(builderA.toString(), (Collection<? extends TextEdit>)((Collection)edit.getChanges().get(JDTUtils.toURI((ICompilationUnit)cuA)))), (Object)"package test1;\npublic class A {\n   public void foo(){\n\t\tNewType b = new NewType();\n\t\tb.foo();\n\t}\n}\n");
        Assert.assertEquals((Object)TextEditUtil.apply(builderB.toString(), (Collection<? extends TextEdit>)((Collection)edit.getChanges().get(JDTUtils.toURI((ICompilationUnit)cuB)))), (Object)"package test1;\npublic class NewType {\n\tpublic NewType() {}\n   public void foo() {}\n}\n");
    }

    @Test
    public void testRenameSuperMethod() throws JavaModelException, BadLocationException {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        String[] codes = new String[]{"package test1;\n", "class A {\n", "   public void bar() {\n", "   }\n", "}\n", "class B extends A {\n", "   public void bar() {\n", "\t\tsuper|*.bar();\n", "   }\n", "}\n"};
        StringBuilder builder = new StringBuilder();
        Position pos = this.mergeCode(builder, codes);
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", builder.toString(), false, null);
        WorkspaceEdit edit = this.getRenameEdit(cu, pos, "TypeA");
        Assert.assertNotNull((Object)edit);
        Assert.assertEquals((long)1L, (long)edit.getChanges().size());
        Assert.assertEquals((Object)TextEditUtil.apply(builder.toString(), (Collection<? extends TextEdit>)((Collection)edit.getChanges().get(JDTUtils.toURI((ICompilationUnit)cu)))), (Object)"package test1;\nclass TypeA {\n   public void bar() {\n   }\n}\nclass B extends TypeA {\n   public void bar() {\n\t\tsuper.bar();\n   }\n}\n");
    }

    @Test
    public void testRenameConstructor() throws JavaModelException, BadLocationException {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        String[] codes1 = new String[]{"package test1;\n", "public class A {\n", "   public void foo(){\n", "\t\tB b = new B();\n", "\t\tb.foo();\n", "\t}\n", "}\n"};
        String[] codes2 = new String[]{"package test1;\n", "public class B {\n", "   public B|*() {}\n", "   public void foo() {}\n", "}\n"};
        StringBuilder builderA = new StringBuilder();
        this.mergeCode(builderA, codes1);
        ICompilationUnit cuA = pack1.createCompilationUnit("A.java", builderA.toString(), false, null);
        StringBuilder builderB = new StringBuilder();
        Position pos = this.mergeCode(builderB, codes2);
        ICompilationUnit cuB = pack1.createCompilationUnit("B.java", builderB.toString(), false, null);
        WorkspaceEdit edit = this.getRenameEdit(cuB, pos, "NewName");
        Assert.assertNotNull((Object)edit);
        Assert.assertEquals((long)edit.getChanges().size(), (long)2L);
        Assert.assertEquals((Object)TextEditUtil.apply(builderA.toString(), (Collection<? extends TextEdit>)((Collection)edit.getChanges().get(JDTUtils.toURI((ICompilationUnit)cuA)))), (Object)"package test1;\npublic class A {\n   public void foo(){\n\t\tNewName b = new NewName();\n\t\tb.foo();\n\t}\n}\n");
        Assert.assertEquals((Object)TextEditUtil.apply(builderB.toString(), (Collection<? extends TextEdit>)((Collection)edit.getChanges().get(JDTUtils.toURI((ICompilationUnit)cuB)))), (Object)"package test1;\npublic class NewName {\n   public NewName() {}\n   public void foo() {}\n}\n");
    }

    @Test
    public void testRenameTypeParameter() throws JavaModelException, BadLocationException {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        String[] codes = new String[]{"package test1;\n", "public class A<T|*> {\n", "\tprivate T t;\n", "\tpublic T get() { return t; }\n", "}\n"};
        StringBuilder builder = new StringBuilder();
        Position pos = this.mergeCode(builder, codes);
        ICompilationUnit cu = pack1.createCompilationUnit("A.java", builder.toString(), false, null);
        WorkspaceEdit edit = this.getRenameEdit(cu, pos, "TT");
        Assert.assertNotNull((Object)edit);
        Assert.assertEquals((long)edit.getChanges().size(), (long)1L);
        Assert.assertEquals((Object)TextEditUtil.apply(builder.toString(), (Collection<? extends TextEdit>)((Collection)edit.getChanges().get(JDTUtils.toURI((ICompilationUnit)cu)))), (Object)"package test1;\npublic class A<TT> {\n\tprivate TT t;\n\tpublic TT get() { return t; }\n}\n");
    }

    @Test
    public void testRenameTypeParameterInMethod() throws JavaModelException, BadLocationException {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        String[] codes = new String[]{"package test1;\n", "public class B<T> {\n", "\tprivate T t;\n", "\tpublic <U|* extends Number> inspect(U u) { return u; }\n", "}\n"};
        StringBuilder builder = new StringBuilder();
        Position pos = this.mergeCode(builder, codes);
        ICompilationUnit cu = pack1.createCompilationUnit("B.java", builder.toString(), false, null);
        WorkspaceEdit edit = this.getRenameEdit(cu, pos, "UU");
        Assert.assertNotNull((Object)edit);
        Assert.assertEquals((long)edit.getChanges().size(), (long)1L);
        Assert.assertEquals((Object)TextEditUtil.apply(builder.toString(), (Collection<? extends TextEdit>)((Collection)edit.getChanges().get(JDTUtils.toURI((ICompilationUnit)cu)))), (Object)"package test1;\npublic class B<T> {\n\tprivate T t;\n\tpublic <UU extends Number> inspect(UU u) { return u; }\n}\n");
    }

    @Test
    public void testRenameJavadoc() throws JavaModelException, BadLocationException {
        IPackageFragment pack1 = this.sourceFolder.createPackageFragment("test1", false, null);
        String[] codes = new String[]{"package test1;\n", "public class E {\n", "\t/**\n", "\t *@param i int\n", "\t */\n", "   public int foo(int i|*) {\n", "\t\tE e = new E();\n", "\t\te.foo();\n", "   }\n", "}\n"};
        StringBuilder builder = new StringBuilder();
        Position pos = this.mergeCode(builder, codes);
        ICompilationUnit cu = pack1.createCompilationUnit("E.java", builder.toString(), false, null);
        WorkspaceEdit edit = this.getRenameEdit(cu, pos, "i2");
        Assert.assertNotNull((Object)edit);
        Assert.assertEquals((long)edit.getChanges().size(), (long)1L);
        Assert.assertEquals((Object)TextEditUtil.apply(builder.toString(), (Collection<? extends TextEdit>)((Collection)edit.getChanges().get(JDTUtils.toURI((ICompilationUnit)cu)))), (Object)"package test1;\npublic class E {\n\t/**\n\t *@param i2 int\n\t */\n   public int foo(int i2) {\n\t\tE e = new E();\n\t\te.foo();\n   }\n}\n");
    }

    private Position mergeCode(StringBuilder builder, String[] codes) {
        Position pos = null;
        int i = 0;
        while (i < codes.length) {
            int ind = codes[i].indexOf("|*");
            if (ind > 0) {
                pos = new Position(i, ind);
                codes[i] = codes[i].replace("|*", "");
            }
            builder.append(codes[i]);
            ++i;
        }
        return pos;
    }

    private WorkspaceEdit getRenameEdit(ICompilationUnit cu, Position pos, String newName) {
        TextDocumentIdentifier identifier = new TextDocumentIdentifier(JDTUtils.toURI((ICompilationUnit)cu));
        RenameParams params = new RenameParams(identifier, pos, newName);
        return this.handler.rename(params, this.monitor);
    }
}

