/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.handlers.JDTLanguageServer;
import org.eclipse.jdt.ls.core.internal.managers.AbstractProjectsManagerBasedTest;
import org.eclipse.jdt.ls.core.internal.preferences.ClientPreferences;
import org.eclipse.jdt.ls.core.internal.preferences.Preferences;
import org.eclipse.lsp4j.ClientCapabilities;
import org.eclipse.lsp4j.DidChangeConfigurationCapabilities;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.ExecuteCommandCapabilities;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.RegistrationParams;
import org.eclipse.lsp4j.SynchronizationCapabilities;
import org.eclipse.lsp4j.TextDocumentClientCapabilities;
import org.eclipse.lsp4j.TextDocumentSyncOptions;
import org.eclipse.lsp4j.WorkspaceClientCapabilities;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class InitHandlerTest
extends AbstractProjectsManagerBasedTest {
    private static final String TEST_EXCLUSIONS = "**/test/**";
    protected JDTLanguageServer server;
    protected JDTLanguageServer protocol;
    @Mock
    private JavaClientConnection.JavaLanguageClient client;

    @Before
    public void setup() throws Exception {
        this.server = new JDTLanguageServer(this.projectsManager, this.preferenceManager);
        this.server.connectClient(this.client);
        this.protocol = JavaLanguageServerPlugin.getInstance().getProtocol();
        JavaLanguageServerPlugin.getInstance().setProtocol(this.server);
    }

    @After
    public void tearDown() {
        this.server.disconnectClient();
        JavaLanguageServerPlugin.getInstance().setProtocol(this.protocol);
        try {
            this.projectsManager.setAutoBuilding(true);
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException((String)e.getMessage(), (Throwable)e);
        }
    }

    @Test
    public void testExecuteCommandProvider() throws Exception {
        ClientPreferences mockCapabilies = (ClientPreferences)Mockito.mock(ClientPreferences.class);
        Mockito.when((Object)mockCapabilies.isExecuteCommandDynamicRegistrationSupported()).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)this.preferenceManager.getClientPreferences()).thenReturn((Object)mockCapabilies);
        InitializeResult result = this.initialize(false);
        List commands = result.getCapabilities().getExecuteCommandProvider().getCommands();
        Assert.assertFalse((boolean)commands.isEmpty());
    }

    @Test
    public void testExecuteCommandProviderDynamicRegistration() throws Exception {
        ClientPreferences mockCapabilies = (ClientPreferences)Mockito.mock(ClientPreferences.class);
        Mockito.when((Object)mockCapabilies.isExecuteCommandDynamicRegistrationSupported()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.preferenceManager.getClientPreferences()).thenReturn((Object)mockCapabilies);
        InitializeResult result = this.initialize(true);
        Assert.assertNull((Object)result.getCapabilities().getExecuteCommandProvider());
    }

    @Test
    public void testWillSaveAndWillSaveWaitUntilCapabilities() throws Exception {
        ClientPreferences mockCapabilies = (ClientPreferences)Mockito.mock(ClientPreferences.class);
        Mockito.when((Object)mockCapabilies.isExecuteCommandDynamicRegistrationSupported()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.preferenceManager.getClientPreferences()).thenReturn((Object)mockCapabilies);
        Mockito.when((Object)mockCapabilies.isWillSaveRegistered()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)mockCapabilies.isWillSaveWaitUntilRegistered()).thenReturn((Object)Boolean.TRUE);
        InitializeResult result = this.initialize(true);
        Either o = result.getCapabilities().getTextDocumentSync();
        Assert.assertTrue((boolean)o.isRight());
        Assert.assertTrue((boolean)((TextDocumentSyncOptions)o.getRight()).getWillSave());
        Assert.assertTrue((boolean)((TextDocumentSyncOptions)o.getRight()).getWillSaveWaitUntil());
    }

    @Test
    public void testRegisterDelayedCapability() throws Exception {
        ClientPreferences mockCapabilies = (ClientPreferences)Mockito.mock(ClientPreferences.class);
        Mockito.when((Object)this.preferenceManager.getClientPreferences()).thenReturn((Object)mockCapabilies);
        Mockito.when((Object)mockCapabilies.isDocumentSymbolDynamicRegistered()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)mockCapabilies.isWorkspaceSymbolDynamicRegistered()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)mockCapabilies.isDocumentSymbolDynamicRegistered()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)mockCapabilies.isCodeActionDynamicRegistered()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)mockCapabilies.isDefinitionDynamicRegistered()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)mockCapabilies.isHoverDynamicRegistered()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)mockCapabilies.isReferencesDynamicRegistered()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)mockCapabilies.isDocumentHighlightDynamicRegistered()).thenReturn((Object)Boolean.TRUE);
        InitializeResult result = this.initialize(true);
        Assert.assertNull((Object)result.getCapabilities().getDocumentSymbolProvider());
        DidChangeConfigurationParams params = new DidChangeConfigurationParams();
        this.server.didChangeConfiguration(params);
        ((JavaClientConnection.JavaLanguageClient)Mockito.verify((Object)this.client, (VerificationMode)Mockito.times((int)7))).registerCapability((RegistrationParams)Matchers.any());
    }

    @Test
    public void testJavaImportExclusions() throws Exception {
        Map<String, Object> initializationOptions = this.createInitializationOptions();
        Preferences prefs = Preferences.createFrom((Map)((Map)initializationOptions.get("settings")));
        Assert.assertEquals((Object)TEST_EXCLUSIONS, prefs.getJavaImportExclusions().get(0));
    }

    private Map<String, Object> createInitializationOptions() {
        ArrayList<String> javaImportExclusions = new ArrayList<String>();
        javaImportExclusions.add(TEST_EXCLUSIONS);
        HashMap<String, Object> exclusionsMap = this.getMap("exclusions", javaImportExclusions);
        HashMap<String, Object> importMap = this.getMap("import", exclusionsMap);
        HashMap<String, Object> javaMap = this.getMap("java", importMap);
        HashMap<String, Object> initializationOptions = new HashMap<String, Object>();
        initializationOptions.put("settings", javaMap);
        return initializationOptions;
    }

    private HashMap<String, Object> getMap(String key, Object obj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(key, obj);
        return map;
    }

    private InitializeResult initialize(boolean dynamicRegistration) throws InterruptedException, ExecutionException {
        InitializeParams params = new InitializeParams();
        ClientCapabilities capabilities = new ClientCapabilities();
        WorkspaceClientCapabilities workspaceCapabilities = new WorkspaceClientCapabilities();
        workspaceCapabilities.setDidChangeConfiguration(new DidChangeConfigurationCapabilities(Boolean.valueOf(dynamicRegistration)));
        ExecuteCommandCapabilities executeCommand = new ExecuteCommandCapabilities(Boolean.valueOf(dynamicRegistration));
        workspaceCapabilities.setExecuteCommand(executeCommand);
        capabilities.setWorkspace(workspaceCapabilities);
        TextDocumentClientCapabilities textDocument = new TextDocumentClientCapabilities();
        SynchronizationCapabilities synchronizationCapabilities = new SynchronizationCapabilities();
        synchronizationCapabilities.setWillSave(Boolean.TRUE);
        synchronizationCapabilities.setWillSaveWaitUntil(Boolean.TRUE);
        capabilities.setTextDocument(textDocument);
        params.setCapabilities(capabilities);
        CompletableFuture result = this.server.initialize(params);
        return (InitializeResult)result.get();
    }
}

