/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.ClassFileUtil;
import org.eclipse.jdt.ls.core.internal.WorkspaceHelper;
import org.eclipse.jdt.ls.core.internal.handlers.DocumentSymbolHandler;
import org.eclipse.jdt.ls.core.internal.managers.AbstractProjectsManagerBasedTest;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DocumentSymbolHandlerTest
extends AbstractProjectsManagerBasedTest {
    private IProject project;
    private DocumentSymbolHandler handler;

    @Before
    public void setup() throws Exception {
        this.importProjects("maven/salut");
        this.project = WorkspaceHelper.getProject("salut");
        this.handler = new DocumentSymbolHandler();
    }

    @Test
    public void testDocumentSymbolHandler() throws Exception {
        this.testClass("org.apache.commons.lang3.text.WordUtils");
    }

    @Test
    public void testSyntheticMember() throws Exception {
        String className = "org.apache.commons.lang3.text.StrTokenizer";
        List<? extends SymbolInformation> symbols = this.getSymbols(className);
        boolean overloadedMethod1Found = false;
        boolean overloadedMethod2Found = false;
        String overloadedMethod1 = "getCSVInstance(String)";
        String overloadedMethod2 = "reset()";
        for (SymbolInformation symbolInformation : symbols) {
            Location loc = symbolInformation.getLocation();
            Assert.assertTrue((String)("Class: " + className + ", Symbol:" + symbolInformation.getName() + " - invalid location."), (loc != null && this.isValid(loc.getRange()) ? 1 : 0) != 0);
            Assert.assertFalse((String)("Class: " + className + ", Symbol:" + symbolInformation.getName() + " - invalid name"), (boolean)symbolInformation.getName().startsWith("access$"));
            Assert.assertFalse((String)("Class: " + className + ", Symbol:" + symbolInformation.getName() + "- invalid name"), (boolean)symbolInformation.getName().equals("<clinit>"));
            if (overloadedMethod1.equals(symbolInformation.getName())) {
                overloadedMethod1Found = true;
            }
            if (!overloadedMethod2.equals(symbolInformation.getName())) continue;
            overloadedMethod2Found = true;
        }
        Assert.assertTrue((String)("The " + overloadedMethod1 + " method hasn't been found"), (boolean)overloadedMethod1Found);
        Assert.assertTrue((String)("The " + overloadedMethod2 + " method hasn't been found"), (boolean)overloadedMethod2Found);
    }

    @Test
    public void testTypes() throws Exception {
        String className = "org.sample.Bar";
        List<? extends SymbolInformation> symbols = this.getSymbols(className);
        this.assertHasSymbol("Bar", "Bar.java", SymbolKind.Class, symbols);
        this.assertHasSymbol("main(String[])", "Bar", SymbolKind.Method, symbols);
        this.assertHasSymbol("MyInterface", "Bar", SymbolKind.Interface, symbols);
        this.assertHasSymbol("foo()", "MyInterface", SymbolKind.Method, symbols);
        this.assertHasSymbol("MyClass", "Bar", SymbolKind.Class, symbols);
        this.assertHasSymbol("bar()", "MyClass", SymbolKind.Method, symbols);
    }

    private void assertHasSymbol(String expectedType, String expectedParent, SymbolKind expectedKind, Collection<? extends SymbolInformation> symbols) {
        Optional<SymbolInformation> symbol = symbols.stream().filter(s -> expectedType.equals(s.getName()) && expectedParent.equals(s.getContainerName())).findFirst();
        Assert.assertTrue((String)(String.valueOf(expectedType) + "(" + expectedParent + ")" + " is missing from " + symbols), (boolean)symbol.isPresent());
        this.assertKind(expectedKind, symbol.get());
    }

    private void assertKind(SymbolKind expectedKind, SymbolInformation symbol) {
        Assert.assertSame((String)("Unexpected SymbolKind in " + symbol.getName()), (Object)expectedKind, (Object)symbol.getKind());
    }

    private void testClass(String className) throws JavaModelException, UnsupportedEncodingException, InterruptedException, ExecutionException {
        List<? extends SymbolInformation> symbols = this.getSymbols(className);
        for (SymbolInformation symbolInformation : symbols) {
            Location loc = symbolInformation.getLocation();
            Assert.assertTrue((String)("Class: " + className + ", Symbol:" + symbolInformation.getName() + " - invalid location."), (loc != null && this.isValid(loc.getRange()) ? 1 : 0) != 0);
        }
    }

    private List<? extends SymbolInformation> getSymbols(String className) throws JavaModelException, UnsupportedEncodingException, InterruptedException, ExecutionException {
        String uri = ClassFileUtil.getURI(this.project, className);
        TextDocumentIdentifier identifier = new TextDocumentIdentifier(uri);
        DocumentSymbolParams params = new DocumentSymbolParams();
        params.setTextDocument(identifier);
        List symbols = this.handler.documentSymbol(params, this.monitor);
        Assert.assertTrue((symbols.size() > 0 ? 1 : 0) != 0);
        return symbols;
    }

    private boolean isValid(Range range) {
        return range != null && this.isValid(range.getStart()) && this.isValid(range.getEnd());
    }

    private boolean isValid(Position position) {
        return position != null && position.getLine() >= 0 && position.getCharacter() >= 0;
    }
}

