/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.LanguageServerWorkingCopyOwner;
import org.eclipse.jdt.ls.core.internal.WorkspaceHelper;
import org.eclipse.jdt.ls.core.internal.handlers.AbstractCompilationUnitBasedTest;
import org.eclipse.jdt.ls.core.internal.handlers.JDTLanguageServer;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class CodeActionHandlerTest
extends AbstractCompilationUnitBasedTest {
    @Mock
    private JavaClientConnection connection;

    @Override
    @Before
    public void setup() throws Exception {
        this.importProjects("eclipse/hello");
        this.project = WorkspaceHelper.getProject("hello");
        this.wcOwner = new LanguageServerWorkingCopyOwner(this.connection);
        this.server = new JDTLanguageServer(this.projectsManager, null);
    }

    @Test
    public void testCodeAction_removeUnusedImport() throws Exception {
        ICompilationUnit unit = this.getWorkingCopy("src/java/Foo.java", "import java.sql.*; \npublic class Foo {\n\tvoid foo() {\n\t}\n}\n");
        CodeActionParams params = new CodeActionParams();
        params.setTextDocument(new TextDocumentIdentifier(JDTUtils.toURI((ICompilationUnit)unit)));
        Range range = this.getRange(unit, "java.sql");
        params.setRange(range);
        params.setContext(new CodeActionContext(Arrays.asList(this.getDiagnostic(Integer.toString(268435844), range))));
        List commands = (List)this.server.codeAction(params).join();
        Assert.assertNotNull((Object)commands);
        Assert.assertEquals((long)2L, (long)commands.size());
        Command c = (Command)commands.get(0);
        Assert.assertEquals((Object)"java.apply.workspaceEdit", (Object)c.getCommand());
    }

    @Test
    public void testCodeAction_removeUnterminatedString() throws Exception {
        ICompilationUnit unit = this.getWorkingCopy("src/java/Foo.java", "public class Foo {\n\tvoid foo() {\nString s = \"some str\n\t}\n}\n");
        CodeActionParams params = new CodeActionParams();
        params.setTextDocument(new TextDocumentIdentifier(JDTUtils.toURI((ICompilationUnit)unit)));
        Range range = this.getRange(unit, "some str");
        params.setRange(range);
        params.setContext(new CodeActionContext(Arrays.asList(this.getDiagnostic(Integer.toString(1610612995), range))));
        List commands = (List)this.server.codeAction(params).join();
        Assert.assertNotNull((Object)commands);
        Assert.assertEquals((long)1L, (long)commands.size());
        Command c = (Command)commands.get(0);
        Assert.assertEquals((Object)"java.apply.workspaceEdit", (Object)c.getCommand());
    }

    @Test
    public void testCodeAction_exception() throws JavaModelException {
        URI uri = this.project.getFile("nopackage/Test.java").getRawLocationURI();
        ICompilationUnit cu = JDTUtils.resolveCompilationUnit((URI)uri);
        try {
            cu.becomeWorkingCopy((IProgressMonitor)new NullProgressMonitor());
            CodeActionParams params = new CodeActionParams();
            params.setTextDocument(new TextDocumentIdentifier(uri.toString()));
            Range range = new Range();
            range.setStart(new Position(0, 17));
            range.setEnd(new Position(0, 17));
            params.setRange(range);
            CodeActionContext context = new CodeActionContext();
            context.setDiagnostics(Collections.emptyList());
            params.setContext(context);
            List commands = (List)this.server.codeAction(params).join();
            Assert.assertNotNull((Object)commands);
            Assert.assertEquals((long)0L, (long)commands.size());
        }
        finally {
            cu.discardWorkingCopy();
        }
    }

    @Test
    @Ignore
    public void testCodeAction_superfluousSemicolon() throws Exception {
        ICompilationUnit unit = this.getWorkingCopy("src/java/Foo.java", "public class Foo {\n\tvoid foo() {\n;\t}\n}\n");
        CodeActionParams params = new CodeActionParams();
        params.setTextDocument(new TextDocumentIdentifier(JDTUtils.toURI((ICompilationUnit)unit)));
        Range range = this.getRange(unit, ";");
        params.setRange(range);
        params.setContext(new CodeActionContext(Arrays.asList(this.getDiagnostic(Integer.toString(536871092), range))));
        List commands = (List)this.server.codeAction(params).join();
        Assert.assertNotNull((Object)commands);
        Assert.assertEquals((long)1L, (long)commands.size());
        Command c = (Command)commands.get(0);
        Assert.assertEquals((Object)"java.apply.workspaceEdit", (Object)c.getCommand());
        Assert.assertNotNull((Object)c.getArguments());
        Assert.assertTrue((boolean)(c.getArguments().get(0) instanceof WorkspaceEdit));
        WorkspaceEdit we = (WorkspaceEdit)c.getArguments().get(0);
        List edits = (List)we.getChanges().get(JDTUtils.toURI((ICompilationUnit)unit));
        Assert.assertEquals((long)1L, (long)edits.size());
        Assert.assertEquals((Object)"", (Object)((TextEdit)edits.get(0)).getNewText());
        Assert.assertEquals((Object)range, (Object)((TextEdit)edits.get(0)).getRange());
    }

    private Range getRange(ICompilationUnit unit, String search) throws JavaModelException {
        String str = unit.getSource();
        int start = str.lastIndexOf(search);
        return JDTUtils.toRange((IOpenable)unit, (int)start, (int)search.length());
    }

    private Diagnostic getDiagnostic(String code, Range range) {
        Diagnostic $ = new Diagnostic();
        $.setCode(code);
        $.setRange(range);
        $.setSeverity(DiagnosticSeverity.Error);
        $.setMessage("Test Diagnostic");
        return $;
    }
}

