/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.ls.core.internal.JavaClientConnection;
import org.eclipse.jdt.ls.core.internal.LanguageServerWorkingCopyOwner;
import org.eclipse.jdt.ls.core.internal.SharedASTProvider;
import org.eclipse.jdt.ls.core.internal.WorkspaceHelper;
import org.eclipse.jdt.ls.core.internal.handlers.JDTLanguageServer;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.jdt.ls.core.internal.managers.AbstractProjectsManagerBasedTest;
import org.junit.After;
import org.junit.Before;
import org.mockito.Mock;

public abstract class AbstractCompilationUnitBasedTest
extends AbstractProjectsManagerBasedTest {
    @Mock
    protected JavaClientConnection connection;
    protected JDTLanguageServer server;
    protected WorkingCopyOwner wcOwner;
    protected IProject project;

    @Before
    public void setup() throws Exception {
        this.importProjects("eclipse/hello");
        this.project = WorkspaceHelper.getProject("hello");
        this.wcOwner = new LanguageServerWorkingCopyOwner(this.connection);
        this.server = new JDTLanguageServer(this.projectsManager, this.preferenceManager);
        JavaCore.initializeAfterLoad(null);
    }

    protected ICompilationUnit getWorkingCopy(String path, String source) throws JavaModelException {
        ICompilationUnit workingCopy = this.getCompilationUnit(path);
        workingCopy.getWorkingCopy(this.wcOwner, this.monitor);
        workingCopy.getBuffer().setContents(source);
        workingCopy.makeConsistent(this.monitor);
        return workingCopy;
    }

    protected ICompilationUnit getCompilationUnit(String path) {
        return (ICompilationUnit)JavaCore.create((IFile)this.getFile(path));
    }

    protected IFile getFile(String path) {
        return this.project.getFile((IPath)new Path(path));
    }

    protected int[] findCompletionLocation(ICompilationUnit unit, String completeBehind) throws JavaModelException {
        String str = unit.getSource();
        int cursorLocation = str.lastIndexOf(completeBehind) + completeBehind.length();
        return JsonRpcHelpers.toLine((IBuffer)unit.getBuffer(), (int)cursorLocation);
    }

    @After
    public void shutdown() throws Exception {
        SharedASTProvider.getInstance().invalidateAll();
    }
}

