/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.contentassist;

import java.util.ArrayList;
import org.eclipse.jdt.ls.core.internal.contentassist.SortTextHelper;
import org.junit.Assert;
import org.junit.Test;

public class SortTextHelperTest {
    @Test
    public void testConvertRelevance() throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < 1000) {
            String relevance = SortTextHelper.convertRelevance((int)i);
            if (i > 0) {
                int prev = i - 1;
                String previous = (String)result.get(prev);
                Assert.assertTrue((String)("relevance " + i + " should be sorted before " + prev + " : " + relevance + " vs " + previous), (relevance.compareTo(previous) < 0 ? 1 : 0) != 0);
            }
            result.add(relevance);
            ++i;
        }
        String min = SortTextHelper.convertRelevance((int)Integer.MIN_VALUE);
        String zero = SortTextHelper.convertRelevance((int)0);
        Assert.assertEquals((Object)zero, (Object)min);
        i = 99999999;
        String max = SortTextHelper.convertRelevance((int)i);
        Assert.assertEquals((Object)"900000000", (Object)max);
        try {
            SortTextHelper.convertRelevance((int)Integer.MAX_VALUE);
            Assert.fail((String)"Values greater than 99999999 are not supported");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

