/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.Arrays;
import org.eclipse.january.asserts.TestUtils;
import org.eclipse.january.dataset.ComplexDoubleDataset;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.IndexIterator;
import org.eclipse.january.dataset.Slice;
import org.eclipse.january.dataset.SliceIterator;
import org.junit.Assert;
import org.junit.Test;

public class SliceIteratorTest {
    @Test
    public void testIterations() {
        int size = 1024;
        this.testIterationsND(size, DoubleDataset.class);
        this.testIterationsND(size, ComplexDoubleDataset.class);
    }

    @Test
    public void testZeroSizedIteration() {
        DoubleDataset ta = DatasetFactory.createRange((double)24.0);
        IndexIterator it = ta.getSliceIterator(null, new int[1], null);
        Assert.assertFalse((boolean)it.hasNext());
    }

    private void testIterationsND(int size, Class<? extends Dataset> clazz) {
        TestUtils.verbosePrintf((String)"Size: %d\n", (Object[])new Object[]{size});
        Dataset ta = DatasetFactory.zeros(clazz, (int[])new int[0]);
        this.testDataset(ta);
        this.testDatasetSteps(ta, new int[0]);
        this.testDatasetSlice(ta, new int[0], new int[0]);
        this.testDatasetAxes(ta, new boolean[0]);
        ta = DatasetFactory.createRange(clazz, (double)0.0, (double)size, (double)1.0);
        this.testDataset(ta);
        this.testDatasetSteps(ta, new int[]{2});
        this.testDatasetSteps(ta.getSliceView(new Slice[]{new Slice(null, null, Integer.valueOf(-1))}), new int[]{2});
        this.testDatasetSteps(ta, new int[]{-3});
        this.testDatasetSlice(ta, new int[]{size / 3}, new int[]{2 * size / 3});
        this.testDatasetSlice(ta.getSliceView(new Slice[]{new Slice(null, null, Integer.valueOf(-1))}), new int[]{2 * size / 3}, new int[]{size / 3});
        this.testDatasetAxes(ta, new boolean[]{true});
        ta.setShape(new int[]{16, size / 16});
        TestUtils.verbosePrintf((String)" Shape: %s\n", (Object[])new Object[]{Arrays.toString(ta.getShapeRef())});
        this.testDataset(ta);
        this.testDatasetSteps(ta, new int[]{1, 2});
        this.testDatasetSteps(ta, new int[]{3, 1});
        int l = size / 16;
        this.testDatasetSlice(ta, new int[]{2, l / 3}, new int[]{12, 2 * l / 3});
        this.testDatasetSlice(ta.getSliceView(new Slice[]{new Slice(null, null, Integer.valueOf(-1))}), new int[]{12, l / 3}, new int[]{2, 2 * l / 3});
        this.testDatasetAxes(ta, new boolean[]{true, true});
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        this.testDatasetAxes(ta, blArray);
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        this.testDatasetAxes(ta, blArray2);
        ta.setShape(new int[]{size / 32, 32});
        TestUtils.verbosePrintf((String)" Shape: %s\n", (Object[])new Object[]{Arrays.toString(ta.getShapeRef())});
        this.testDataset(ta);
        this.testDatasetSteps(ta, new int[]{1, 2});
        this.testDatasetSteps(ta, new int[]{3, 1});
        this.testDatasetAxes(ta, new boolean[]{true, true});
        boolean[] blArray3 = new boolean[2];
        blArray3[0] = true;
        this.testDatasetAxes(ta, blArray3);
        boolean[] blArray4 = new boolean[2];
        blArray4[1] = true;
        this.testDatasetAxes(ta, blArray4);
        ta.setShape(new int[]{16, 8, size / 128});
        TestUtils.verbosePrintf((String)" Shape: %s\n", (Object[])new Object[]{Arrays.toString(ta.getShapeRef())});
        this.testDataset(ta);
        this.testDatasetSteps(ta, new int[]{1, 1, 3});
        this.testDatasetSteps(ta, new int[]{1, 2, 1});
        this.testDatasetSteps(ta, new int[]{3, 1, 1});
        this.testDatasetSteps(ta, new int[]{3, 1, 2});
        this.testDatasetSteps(ta, new int[]{3, -1, 2});
        this.testDatasetAxes(ta, new boolean[]{true, true, true});
        boolean[] blArray5 = new boolean[3];
        blArray5[0] = true;
        blArray5[1] = true;
        this.testDatasetAxes(ta, blArray5);
        boolean[] blArray6 = new boolean[3];
        blArray6[0] = true;
        blArray6[2] = true;
        this.testDatasetAxes(ta, blArray6);
        boolean[] blArray7 = new boolean[3];
        blArray7[0] = true;
        this.testDatasetAxes(ta, blArray7);
        boolean[] blArray8 = new boolean[3];
        blArray8[1] = true;
        blArray8[2] = true;
        this.testDatasetAxes(ta, blArray8);
        boolean[] blArray9 = new boolean[3];
        blArray9[1] = true;
        this.testDatasetAxes(ta, blArray9);
        boolean[] blArray10 = new boolean[3];
        blArray10[2] = true;
        this.testDatasetAxes(ta, blArray10);
        this.testDatasetAxes(ta, new boolean[3]);
        ta.setShape(new int[]{size / 128, 16, 8});
        TestUtils.verbosePrintf((String)" Shape: %s\n", (Object[])new Object[]{Arrays.toString(ta.getShapeRef())});
        this.testDataset(ta);
        this.testDatasetSteps(ta, new int[]{1, 1, 3});
        this.testDatasetSteps(ta, new int[]{1, 2, 1});
        this.testDatasetSteps(ta, new int[]{3, 1, 1});
        this.testDatasetSteps(ta, new int[]{3, 1, 2});
        this.testDatasetSteps(ta, new int[]{3, -1, 2});
        this.testDatasetAxes(ta, new boolean[]{true, true, true});
        boolean[] blArray11 = new boolean[3];
        blArray11[0] = true;
        blArray11[1] = true;
        this.testDatasetAxes(ta, blArray11);
        boolean[] blArray12 = new boolean[3];
        blArray12[0] = true;
        blArray12[2] = true;
        this.testDatasetAxes(ta, blArray12);
        boolean[] blArray13 = new boolean[3];
        blArray13[0] = true;
        this.testDatasetAxes(ta, blArray13);
        boolean[] blArray14 = new boolean[3];
        blArray14[1] = true;
        blArray14[2] = true;
        this.testDatasetAxes(ta, blArray14);
        boolean[] blArray15 = new boolean[3];
        blArray15[1] = true;
        this.testDatasetAxes(ta, blArray15);
        boolean[] blArray16 = new boolean[3];
        blArray16[2] = true;
        this.testDatasetAxes(ta, blArray16);
        this.testDatasetAxes(ta, new boolean[3]);
    }

    private void testDataset(Dataset ta) {
        SliceIterator iter = (SliceIterator)ta.getSliceIterator(null, null, null);
        int[] pos = iter.getPos();
        int i = 0;
        while (iter.hasNext()) {
            Assert.assertEquals((double)i, (double)ta.getDouble(pos), (double)(1.0E-5 * (double)i));
            ++i;
        }
    }

    private void testDatasetSteps(Dataset ta, int[] step) {
        SliceIterator iter = (SliceIterator)ta.getSliceIterator(null, null, step);
        int[] pos = iter.getPos();
        int[] shape = ta.getShapeRef();
        int endrank = shape.length - 1;
        int[] tpos = new int[shape.length];
        int j = 0;
        while (j <= endrank) {
            if (step[j] < 0) {
                tpos[j] = shape[j] - 1;
            }
            ++j;
        }
        block1: while (iter.hasNext()) {
            j = 0;
            while (j <= endrank) {
                Assert.assertEquals((String)("  step: " + Arrays.toString(step) + "; shape: " + Arrays.toString(shape) + "; dim " + j), (double)tpos[j], (double)pos[j], (double)(1.0E-5 * (double)tpos[j]));
                ++j;
            }
            j = endrank;
            while (j >= 0) {
                if (step[j] > 0) {
                    int n = j;
                    tpos[n] = tpos[n] + step[j];
                    if (tpos[j] < shape[j]) continue block1;
                    tpos[j] = 0;
                } else {
                    int n = j;
                    tpos[n] = tpos[n] + step[j];
                    if (tpos[j] >= 0) continue block1;
                    tpos[j] = shape[j] - 1;
                }
                --j;
            }
        }
    }

    private void testDatasetSlice(Dataset ta, int[] start, int[] stop) {
        SliceIterator iter = (SliceIterator)ta.getSliceIterator(start, stop, null);
        int[] pos = iter.getPos();
        int[] shape = ta.getShapeRef();
        int endrank = shape.length - 1;
        int[] tpos = new int[shape.length];
        int j = 0;
        while (j <= endrank) {
            tpos[j] = start[j];
            ++j;
        }
        block1: while (iter.hasNext()) {
            j = 0;
            while (j <= endrank) {
                Assert.assertEquals((String)(" start: " + Arrays.toString(start) + "; stop: " + Arrays.toString(stop) + "; dim " + j), (double)tpos[j], (double)pos[j], (double)(1.0E-5 * (double)tpos[j]));
                ++j;
            }
            j = endrank;
            while (j >= 0) {
                int n = j;
                tpos[n] = tpos[n] + 1;
                if (tpos[j] < stop[j]) continue block1;
                tpos[j] = start[j];
                --j;
            }
        }
    }

    private void testDatasetAxes(Dataset ta, boolean[] axes) {
        SliceIterator iter = ta.getSliceIteratorFromAxes(null, axes);
        int[] pos = iter.getPos();
        int[] shape = ta.getShapeRef();
        int endrank = shape.length - 1;
        int[] tpos = new int[shape.length];
        block0: while (iter.hasNext()) {
            int j = 0;
            while (j <= endrank) {
                Assert.assertEquals((String)("  axes: " + Arrays.toString(axes) + "; shape: " + Arrays.toString(shape) + "; dim " + j), (double)tpos[j], (double)pos[j], (double)(1.0E-5 * (double)tpos[j]));
                ++j;
            }
            j = endrank;
            while (j >= 0) {
                if (axes[j]) {
                    int n = j;
                    tpos[n] = tpos[n] + 1;
                    if (tpos[j] < shape[j]) continue block0;
                    tpos[j] = 0;
                }
                --j;
            }
        }
    }
}

