/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.FloatDataset;
import org.eclipse.january.dataset.IndexIterator;
import org.junit.Assert;
import org.junit.Test;

public class FloatDatasetTest {
    @Test
    public void testConstructor() {
        Assert.assertEquals((long)0L, (long)new FloatDataset().getSize());
        Assert.assertEquals((long)0L, (long)DatasetFactory.createFromObject((Object)Float.valueOf(1.0f)).getRank());
        float[] da = new float[]{0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 10.0f, 11.0f};
        FloatDataset a = new FloatDataset(da, new int[0]);
        IndexIterator it = a.getIterator();
        int i = 0;
        while (it.hasNext()) {
            Assert.assertEquals((double)i, (double)a.getElementDoubleAbs(it.index), (double)(1.0E-5 * (double)i));
            ++i;
        }
        FloatDataset b = new FloatDataset(da, new int[]{3, 4});
        it = b.getIterator();
        int i2 = 0;
        while (it.hasNext()) {
            Assert.assertEquals((double)i2, (double)b.getElementDoubleAbs(it.index), (double)(1.0E-5 * (double)i2));
            ++i2;
        }
        a.hashCode();
        b.hashCode();
    }

    @Test
    public void testStats() {
        Dataset a = DatasetFactory.createRange(FloatDataset.class, (double)12.0);
        Assert.assertEquals((Object)Float.valueOf(11.0f), (Object)a.max(new boolean[0]));
        Assert.assertEquals((double)0.0, (double)a.min(new boolean[0]).doubleValue(), (double)1.0E-6);
        Assert.assertEquals((double)5.5, (double)((Number)a.mean(new boolean[0])).doubleValue(), (double)1.0E-6);
        Assert.assertEquals((double)3.605551275463989, (double)a.stdDeviation(), (double)1.0E-6);
        Assert.assertEquals((double)13.0, (double)a.variance(), (double)1.0E-6);
    }
}

