/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.io.IOException;
import org.apache.commons.math3.random.MersenneTwister;
import org.apache.commons.math3.random.RandomDataGenerator;
import org.apache.commons.math3.random.RandomGenerator;
import org.eclipse.january.IMonitor;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.IDataset;
import org.eclipse.january.dataset.ILazyDataset;
import org.eclipse.january.dataset.IntegerDataset;
import org.eclipse.january.dataset.LazyDataset;
import org.eclipse.january.dataset.SliceND;
import org.eclipse.january.io.ILazyLoader;

public class Random {
    private static final RandomGenerator generator = new MersenneTwister();
    private static final RandomDataGenerator prng = new RandomDataGenerator(generator);

    public static void seed(int seed) {
        generator.setSeed(seed);
    }

    public static void seed(int[] seed) {
        generator.setSeed(seed);
    }

    public static void seed(long seed) {
        generator.setSeed(seed);
    }

    public static DoubleDataset rand(int ... shape) {
        DoubleDataset data = DatasetFactory.zeros(DoubleDataset.class, shape);
        double[] buf = data.getData();
        int i = 0;
        while (i < buf.length) {
            buf[i] = generator.nextDouble();
            ++i;
        }
        return data;
    }

    public static DoubleDataset rand(double low, double high, int ... shape) {
        DoubleDataset data = DatasetFactory.zeros(DoubleDataset.class, shape);
        double[] buf = data.getData();
        int i = 0;
        while (i < buf.length) {
            buf[i] = prng.nextUniform(low, high);
            ++i;
        }
        return data;
    }

    public static DoubleDataset randn(int ... shape) {
        DoubleDataset data = DatasetFactory.zeros(DoubleDataset.class, shape);
        double[] buf = data.getData();
        int i = 0;
        while (i < buf.length) {
            buf[i] = generator.nextGaussian();
            ++i;
        }
        return data;
    }

    public static DoubleDataset randn(double mean, double std, int ... shape) {
        DoubleDataset data = DatasetFactory.zeros(DoubleDataset.class, shape);
        double[] buf = data.getData();
        int i = 0;
        while (i < buf.length) {
            buf[i] = prng.nextGaussian(mean, std);
            ++i;
        }
        return data;
    }

    public static IntegerDataset randint(int low, int high, int[] shape) {
        return Random.random_integers(low, high - 1, shape);
    }

    public static IntegerDataset random_integers(int low, int high, int[] shape) {
        IntegerDataset data = DatasetFactory.zeros(IntegerDataset.class, shape);
        int[] buf = data.getData();
        if (low == high) {
            int i = 0;
            while (i < buf.length) {
                buf[i] = low;
                ++i;
            }
        } else {
            int i = 0;
            while (i < buf.length) {
                buf[i] = prng.nextInt(low, high);
                ++i;
            }
        }
        return data;
    }

    public static DoubleDataset exponential(double beta, int ... shape) {
        DoubleDataset data = DatasetFactory.zeros(DoubleDataset.class, shape);
        double[] buf = data.getData();
        int i = 0;
        while (i < buf.length) {
            buf[i] = prng.nextExponential(beta);
            ++i;
        }
        return data;
    }

    public static IntegerDataset poisson(double lam, int ... shape) {
        IntegerDataset data = DatasetFactory.zeros(IntegerDataset.class, shape);
        int[] buf = data.getData();
        int i = 0;
        while (i < buf.length) {
            buf[i] = (int)prng.nextPoisson(lam);
            ++i;
        }
        return data;
    }

    public static ILazyDataset lazyRand(int ... shape) {
        return Random.lazyRand(6, "random", shape);
    }

    public static ILazyDataset lazyRand(String name, int ... shape) {
        return Random.lazyRand(6, name, shape);
    }

    public static ILazyDataset lazyRand(int dtype, String name, int ... shape) {
        return new LazyDataset(name, dtype, shape, new ILazyLoader(){
            private static final long serialVersionUID = -611684979804645511L;

            @Override
            public boolean isFileReadable() {
                return true;
            }

            @Override
            public IDataset getDataset(IMonitor mon, SliceND slice) throws IOException {
                return Random.rand(slice.getShape());
            }
        });
    }
}

