/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.Arrays;
import org.eclipse.january.dataset.AggregateDataset;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DatasetUtils;
import org.eclipse.january.dataset.IDataset;
import org.eclipse.january.dataset.ILazyDataset;
import org.eclipse.january.dataset.Slice;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AggregateDatasetTest {
    ILazyDataset[] datasets;

    @Before
    public void init() {
        this.datasets = new ILazyDataset[]{DatasetFactory.zeros((int[])new int[]{2, 6}, (int)3).fill((Object)0), DatasetFactory.zeros((int[])new int[]{2, 6}, (int)3).fill((Object)1), DatasetFactory.zeros((int[])new int[]{2, 6}, (int)3).fill((Object)2), DatasetFactory.zeros((int[])new int[]{2, 6}, (int)3).fill((Object)3), DatasetFactory.zeros((int[])new int[]{2, 6}, (int)3).fill((Object)4)};
    }

    @Test
    public void testConstructorFailures() {
        try {
            new AggregateDataset(true, new ILazyDataset[0]);
        }
        catch (Exception exception) {
            try {
                new AggregateDataset(false, new ILazyDataset[0]);
            }
            catch (Exception exception2) {
                try {
                    new AggregateDataset(false, new ILazyDataset[]{DatasetFactory.ones((int[])new int[]{2, 3}, (int)0), DatasetFactory.ones((int[])new int[]{3, 4}, (int)0)});
                }
                catch (Exception exception3) {
                    try {
                        new AggregateDataset(true, new ILazyDataset[]{DatasetFactory.ones((int[])new int[]{2, 3}, (int)0), DatasetFactory.ones((int[])new int[]{3, 3}, (int)0)});
                    }
                    catch (Exception exception4) {
                        System.out.println("Success!");
                        return;
                    }
                }
            }
        }
        Assert.fail((String)"No exceptions thrown!");
    }

    @Test
    public void testUnextendedShape() throws Exception {
        AggregateDataset a = new AggregateDataset(false, this.datasets);
        Assert.assertEquals((String)"Incorrect rank", (long)this.datasets[0].getRank(), (long)a.getRank());
        Assert.assertArrayEquals((String)"Incorrect shape", (int[])new int[]{2 * this.datasets.length, 6}, (int[])a.getShape());
        Dataset s = DatasetUtils.convertToDataset((IDataset)a.getSlice(new Slice[]{null, null}));
        Assert.assertArrayEquals((String)"Incorrect shape", (int[])new int[]{2 * this.datasets.length, 6}, (int[])s.getShape());
        s = DatasetUtils.convertToDataset((IDataset)a.getSlice(null, new int[]{2, 2}, null));
        Assert.assertArrayEquals((String)"Incorrect shape", (int[])new int[]{2, 2}, (int[])s.getShape());
        int[] nArray = new int[2];
        nArray[0] = 1;
        s = DatasetUtils.convertToDataset((IDataset)a.getSlice(nArray, new int[]{2, 2}, null));
        Assert.assertArrayEquals((String)"Incorrect shape", (int[])new int[]{1, 2}, (int[])s.getShape());
        AggregateDataset l = a.getSliceView(null, new int[]{2, 2}, null);
        s = DatasetUtils.convertToDataset((IDataset)l.getSlice(new Slice[0]));
        System.out.println("View is " + l + "; slice is " + s);
        s = DatasetUtils.convertToDataset((IDataset)l.getSlice(new Slice[0]));
        Assert.assertArrayEquals((String)"Incorrect shape", (int[])new int[]{2, 2}, (int[])s.getShape());
        int[] nArray2 = new int[2];
        nArray2[0] = 1;
        l = a.getSliceView(nArray2, new int[]{2, 2}, null);
        s = DatasetUtils.convertToDataset((IDataset)l.getSlice(new Slice[0]));
        System.out.println("View is " + l + "; slice is " + s);
        s = DatasetUtils.convertToDataset((IDataset)l.getSlice(new Slice[0]));
        Assert.assertArrayEquals((String)"Incorrect shape", (int[])new int[]{1, 2}, (int[])s.getShape());
    }

    @Test
    public void testExtendedShape() throws Exception {
        AggregateDataset a = new AggregateDataset(true, this.datasets);
        Assert.assertEquals((String)"Incorrect rank", (long)(this.datasets[0].getRank() + 1), (long)a.getRank());
        Assert.assertArrayEquals((String)"Incorrect shape", (int[])new int[]{this.datasets.length, 2, 6}, (int[])a.getShape());
        Dataset s = DatasetUtils.convertToDataset((IDataset)a.getSlice(new Slice[]{null, null, null}));
        Assert.assertArrayEquals((String)"Incorrect shape", (int[])new int[]{this.datasets.length, 2, 6}, (int[])s.getShape());
        s = DatasetUtils.convertToDataset((IDataset)a.getSlice(null, new int[]{2, 2, 2}, null));
        Assert.assertArrayEquals((String)"Incorrect shape", (int[])new int[]{2, 2, 2}, (int[])s.getShape());
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArray[2] = 1;
        s = DatasetUtils.convertToDataset((IDataset)a.getSlice(nArray, new int[]{2, 2, 3}, new int[]{1, 1, 2}));
        Assert.assertArrayEquals((String)"Incorrect shape", (int[])new int[]{1, 2, 1}, (int[])s.getShape());
        int[] nArray2 = new int[3];
        nArray2[2] = 1;
        AggregateDataset l = a.getSliceView(nArray2, new int[]{2, 2, 6}, new int[]{1, 1, 3});
        s = DatasetUtils.convertToDataset((IDataset)l.getSlice(new Slice[0]));
        System.out.println("View is " + l + "; slice is " + s);
        Assert.assertArrayEquals((String)"Incorrect shape", (int[])new int[]{2, 2, 2}, (int[])s.getShape());
    }

    @Test
    public void testRepeatedDataset() throws Exception {
        Dataset a = DatasetFactory.createRange((double)3.0, (int)6);
        Object[] as = new Dataset[5];
        Arrays.fill(as, a);
        AggregateDataset b = new AggregateDataset(true, (ILazyDataset[])as);
        Assert.assertEquals((String)"Incorrect rank", (long)(a.getRank() + 1), (long)b.getRank());
        Assert.assertArrayEquals((String)"Incorrect shape", (int[])new int[]{as.length, 3}, (int[])b.getShape());
        int[] nArray = new int[2];
        nArray[0] = 1;
        Dataset s = DatasetUtils.convertToDataset((IDataset)b.getSlice(nArray, new int[]{2, 2}, null));
        Assert.assertArrayEquals((String)"Incorrect shape", (int[])new int[]{1, 2}, (int[])s.getShape());
        Assert.assertArrayEquals((String)"Incorrect values", (double[])new double[]{0.0, 1.0}, (double[])((double[])s.getBuffer()), (double)1.0E-5);
        int[] nArray2 = new int[2];
        nArray2[1] = 1;
        s = DatasetUtils.convertToDataset((IDataset)b.getSlice(nArray2, new int[]{2, 2}, null));
        Assert.assertArrayEquals((String)"Incorrect shape", (int[])new int[]{2, 1}, (int[])s.getShape());
        Assert.assertArrayEquals((String)"Incorrect values", (double[])new double[]{1.0, 1.0}, (double[])((double[])s.getBuffer()), (double)1.0E-5);
        int[] nArray3 = new int[2];
        nArray3[0] = 1;
        AggregateDataset l = b.getSliceView(nArray3, new int[]{2, 2}, null);
        s = DatasetUtils.convertToDataset((IDataset)l.getSlice(new Slice[0]));
        System.out.println("View is " + l + "; slice is " + s);
        Assert.assertArrayEquals((String)"Incorrect shape", (int[])new int[]{1, 2}, (int[])s.getShape());
        Assert.assertArrayEquals((String)"Incorrect values", (double[])new double[]{0.0, 1.0}, (double[])((double[])s.getBuffer()), (double)1.0E-5);
        int[] nArray4 = new int[2];
        nArray4[1] = 1;
        l = b.getSliceView(nArray4, new int[]{2, 2}, null);
        s = DatasetUtils.convertToDataset((IDataset)l.getSlice(new Slice[0]));
        System.out.println("View is " + l + "; slice is " + s);
        Assert.assertArrayEquals((String)"Incorrect shape", (int[])new int[]{2, 1}, (int[])s.getShape());
        Assert.assertArrayEquals((String)"Incorrect values", (double[])new double[]{1.0, 1.0}, (double[])((double[])s.getBuffer()), (double)1.0E-5);
    }
}

