/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.geometry;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.january.geometry.GeometryFactory;
import org.eclipse.january.geometry.INode;
import org.eclipse.january.geometry.Shape;
import org.eclipse.january.geometry.Triangle;
import org.eclipse.january.geometry.Union;
import org.eclipse.january.geometry.Vertex;

public interface BoundingBox
extends EObject {
    public double getMaxX();

    public void setMaxX(double var1);

    public double getMaxY();

    public void setMaxY(double var1);

    public double getMaxZ();

    public void setMaxZ(double var1);

    public double getMinX();

    public void setMinX(double var1);

    public double getMinY();

    public void setMinY(double var1);

    public double getMinZ();

    public void setMinZ(double var1);

    public void addArea(BoundingBox var1);

    public static BoundingBox getBounds(Shape shape) {
        BoundingBox bounds = null;
        if (!shape.getTriangles().isEmpty()) {
            double minz;
            double miny;
            double minx;
            bounds = GeometryFactory.eINSTANCE.createBoundingBox();
            double maxx = minx = ((Vertex)((Triangle)shape.getTriangles().get(0)).getVertices().get(0)).getX();
            double maxy = miny = ((Vertex)((Triangle)shape.getTriangles().get(0)).getVertices().get(0)).getY();
            double maxz = minz = ((Vertex)((Triangle)shape.getTriangles().get(0)).getVertices().get(0)).getZ();
            for (Triangle tri : shape.getTriangles()) {
                for (Vertex vert : tri.getVertices()) {
                    minx = Math.min(minx, vert.getX());
                    maxx = Math.max(maxx, vert.getX());
                    miny = Math.min(miny, vert.getY());
                    maxy = Math.max(maxy, vert.getY());
                    minz = Math.min(minz, vert.getZ());
                    maxz = Math.max(maxz, vert.getZ());
                }
            }
            Vertex center = shape.getCenter();
            bounds.setMinX(minx + center.getX());
            bounds.setMinY(miny + center.getY());
            bounds.setMinZ(minz + center.getZ());
            bounds.setMaxX(maxx + center.getX());
            bounds.setMaxY(maxy + center.getY());
            bounds.setMaxZ(maxz + center.getZ());
        }
        return bounds;
    }

    public static BoundingBox getBounds(Union union) {
        BoundingBox bounds = null;
        if (union != null && !union.getNodes().isEmpty()) {
            bounds = GeometryFactory.eINSTANCE.createBoundingBox();
            for (INode node : union.getNodes()) {
                if (!(node instanceof Shape)) continue;
                bounds.addArea(BoundingBox.getBounds((Shape)node));
            }
        }
        return bounds;
    }

    public static Vertex getCenter(BoundingBox bounds) {
        Vertex center = null;
        if (bounds != null) {
            center = GeometryFactory.eINSTANCE.createVertex();
            center.setX((bounds.getMinX() + bounds.getMaxX()) / 2.0);
            center.setY((bounds.getMinY() + bounds.getMaxY()) / 2.0);
            center.setZ((bounds.getMinZ() + bounds.getMaxZ()) / 2.0);
        }
        return center;
    }
}

