/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.form;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.eclipse.january.form.ICEObject;
import org.eclipse.january.form.IEntry;

@XmlRootElement(name="ICEResource")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ICEResource
extends ICEObject {
    @XmlAttribute
    private File file;
    @XmlAttribute
    private URI path;
    @XmlElementWrapper
    @XmlAnyElement(lax=true)
    private ArrayList<IEntry> properties;
    @XmlAttribute
    private boolean isPicture;

    public ICEResource() {
        this.setName(null);
        this.setDescription(null);
        this.file = null;
        this.path = null;
        this.properties = new ArrayList();
        this.isPicture = false;
    }

    public ICEResource(File resourceFile) throws IOException {
        this.setName(resourceFile.getName());
        this.setId(1);
        this.setDescription(resourceFile.getAbsolutePath());
        this.setContents(resourceFile);
        this.properties = new ArrayList();
        this.isPicture = false;
    }

    public String getLastModificationDate() {
        Date fileDate = null;
        String retVal = "0";
        if (this.file != null) {
            fileDate = new Date(this.file.lastModified());
            retVal = fileDate.toString();
        }
        return retVal;
    }

    public File getContents() {
        return this.file;
    }

    public URI getPath() {
        if (this.file != null) {
            this.path = this.file.toURI();
        }
        return this.path;
    }

    public void setPath(URI path) {
        if (path == null) {
            return;
        }
        this.path = path;
        if (!this.file.toURI().equals(path)) {
            this.file = new File(path);
        }
    }

    public ArrayList<IEntry> getProperties() {
        return this.properties;
    }

    public void setProperties(ArrayList<IEntry> props) {
        if (props == null) {
            return;
        }
        this.properties = props;
    }

    public boolean isPictureType() {
        return this.isPicture;
    }

    @XmlTransient
    public void setPictureType(boolean isPicture) {
        this.isPicture = isPicture;
    }

    public void copy(ICEResource otherResource) {
        if (otherResource == null) {
            return;
        }
        super.copy(otherResource);
        this.file = otherResource.file;
        this.path = otherResource.path;
        this.properties.clear();
        int i = 0;
        while (i < otherResource.properties.size()) {
            this.properties.add((IEntry)otherResource.getProperties().get(i).clone());
            ++i;
        }
        this.isPicture = otherResource.isPicture;
    }

    @Override
    public Object clone() {
        ICEResource resource = null;
        resource = new ICEResource();
        resource.copy(this);
        return resource;
    }

    @Override
    public boolean equals(Object otherICEResource) {
        if (this == otherICEResource) {
            return true;
        }
        if (otherICEResource == null || !(otherICEResource instanceof ICEResource)) {
            return false;
        }
        if (!super.equals(otherICEResource)) {
            return false;
        }
        ICEResource castedResource = (ICEResource)otherICEResource;
        return this.file.equals(castedResource.file) && this.path.equals(castedResource.path) && this.properties.equals(castedResource.properties) && this.isPicture == castedResource.isPicture;
    }

    @Override
    public int hashCode() {
        int hash = 11;
        hash = 31 * hash + super.hashCode();
        hash = 31 * hash + (this.file == null ? 0 : this.file.hashCode());
        hash = 31 * hash + (this.path == null ? 0 : this.path.hashCode());
        hash = 31 * hash + this.properties.hashCode();
        hash = 31 * hash + (!this.isPicture ? 0 : 1);
        return hash;
    }

    @XmlTransient
    public void setContents(File resourceFile) throws IOException, NullPointerException {
        this.file = resourceFile;
        this.path = resourceFile.toURI();
    }
}

