/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import org.eclipse.january.DatasetException;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetUtils;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.IDataset;
import org.eclipse.january.dataset.IndexIterator;
import org.eclipse.january.dataset.Slice;

public class RunningAverage {
    private DoubleDataset average;
    private DoubleDataset sqAveError;
    private int count = 1;

    public RunningAverage(IDataset dataset) {
        this.average = (DoubleDataset)(dataset.getElementClass().equals(Double.class) ? DatasetUtils.convertToDataset(dataset).clone() : DatasetUtils.cast(dataset, 6));
        this.sqAveError = null;
        Dataset eb = this.average.getErrorBuffer();
        if (eb != null) {
            this.sqAveError = eb.getDType() != 6 ? (DoubleDataset)DatasetUtils.cast(eb, 6) : (DoubleDataset)eb;
        }
    }

    public void update(IDataset dataset) {
        ++this.count;
        IndexIterator it = this.average.getIterator(true);
        int[] pos = it.getPos();
        double f = 1.0 / (double)this.count;
        if (this.sqAveError == null) {
            while (it.hasNext()) {
                double m = this.average.getAbs(it.index);
                double v = f * (dataset.getDouble(pos) - m);
                this.average.setAbs(it.index, m + v);
            }
        } else {
            double fs = f * f;
            double gs = 2 * this.count - 1;
            if (dataset instanceof Dataset) {
                Dataset d = (Dataset)dataset;
                Dataset e = d.getErrorBuffer();
                while (it.hasNext()) {
                    double m = this.average.getAbs(it.index);
                    double v = f * (d.getDouble(pos) - m);
                    this.average.setAbs(it.index, m + v);
                    if (e == null) continue;
                    m = this.sqAveError.getDouble(pos);
                    v = fs * (e.getDouble(pos) - gs * m);
                    this.sqAveError.setItem(m + v, pos);
                }
            } else {
                IDataset le = dataset.getError();
                IDataset e = null;
                if (le instanceof IDataset) {
                    e = le;
                } else if (le != null) {
                    try {
                        e = le.getSlice(new Slice[0]);
                    }
                    catch (DatasetException datasetException) {}
                }
                while (it.hasNext()) {
                    double m = this.average.getAbs(it.index);
                    double v = f * (dataset.getDouble(pos) - m);
                    this.average.setAbs(it.index, m + v);
                    if (e == null) continue;
                    m = this.sqAveError.getDouble(pos);
                    v = e.getDouble(pos);
                    v = fs * (v * v - gs * m);
                    this.sqAveError.setItem(m + v, pos);
                }
            }
        }
    }

    public int getCount() {
        return this.count;
    }

    public Dataset getCurrentAverage() {
        if (this.sqAveError != null) {
            DoubleDataset e = this.sqAveError.clone();
            DatasetUtils.makeFinite(e);
            this.average.setErrorBuffer(e);
        }
        return this.average;
    }
}

