/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.Arrays;
import org.eclipse.january.dataset.IndexIterator;

public class DiscontiguousIterator
extends IndexIterator {
    private final int[] shape;
    private final int endrank;
    private final int[] gaps;
    private final int imax;
    private final int istep;
    private final int[] pos;

    public DiscontiguousIterator(int[] shape, int[] dataShape, int length) {
        this(shape, dataShape, length, 1);
    }

    public DiscontiguousIterator(int[] shape, int[] dataShape, int length, int isize) {
        this.shape = shape;
        this.endrank = shape.length - 1;
        this.istep = isize;
        this.pos = new int[this.endrank + 1];
        this.pos[this.endrank] = -1;
        this.index = -isize;
        this.imax = length;
        this.gaps = new int[this.endrank + 1];
        int chunk = isize;
        int i = this.endrank;
        while (i >= 0) {
            this.gaps[i] = (dataShape[i] - shape[i]) * chunk;
            chunk *= dataShape[i];
            --i;
        }
    }

    @Override
    public boolean hasNext() {
        int j = this.endrank;
        while (j >= 0) {
            int n = j;
            this.pos[n] = this.pos[n] + 1;
            if (this.pos[j] < this.shape[j]) break;
            this.pos[j] = 0;
            this.index += this.gaps[j];
            --j;
        }
        if (j == -1) {
            this.index = this.imax;
            return false;
        }
        this.index += this.istep;
        return this.index < this.imax;
    }

    @Override
    public int[] getPos() {
        return this.pos;
    }

    @Override
    public void reset() {
        Arrays.fill(this.pos, 0);
        this.pos[this.endrank] = -1;
        this.index = -this.istep;
    }

    @Override
    public int[] getShape() {
        return this.shape;
    }
}

