/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.text.MessageFormat;
import org.eclipse.january.dataset.BooleanDatasetBase;
import org.eclipse.january.dataset.BroadcastSelfIterator;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.IndexIterator;
import org.eclipse.january.dataset.SliceIterator;

public class BooleanDataset
extends BooleanDatasetBase {
    private static final long serialVersionUID = -6891075135217265625L;

    BooleanDataset() {
    }

    BooleanDataset(int ... shape) {
        super(shape);
    }

    BooleanDataset(boolean[] data, int ... shape) {
        super(data, shape);
    }

    BooleanDataset(BooleanDataset dataset) {
        super(dataset);
    }

    BooleanDataset(Dataset dataset) {
        super(dataset);
    }

    @Override
    public BooleanDataset getView(boolean deepCopyMetadata) {
        BooleanDataset view = new BooleanDataset();
        BooleanDataset.copyToView(this, view, true, deepCopyMetadata);
        view.setData();
        return view;
    }

    @Override
    public BooleanDataset clone() {
        return new BooleanDataset(this);
    }

    static BooleanDataset createFromObject(Object obj) {
        BooleanDatasetBase result = BooleanDatasetBase.createFromObject(obj);
        return new BooleanDataset(result.data, result.shape);
    }

    static BooleanDataset ones(int ... shape) {
        BooleanDatasetBase result = BooleanDatasetBase.ones(shape);
        return new BooleanDataset(result.data, result.shape);
    }

    @Override
    public boolean getElementBooleanAbs(int index) {
        return this.data[index];
    }

    @Override
    public double getElementDoubleAbs(int index) {
        return this.data[index] ? 1 : 0;
    }

    @Override
    public long getElementLongAbs(int index) {
        return this.data[index] ? 1 : 0;
    }

    @Override
    public double getDouble(int i) {
        return this.getInt(i);
    }

    @Override
    public double getDouble(int i, int j) {
        return this.getInt(i, j);
    }

    @Override
    public double getDouble(int ... pos) {
        return this.getInt(pos);
    }

    @Override
    public float getFloat(int i) {
        return this.getInt(i);
    }

    @Override
    public float getFloat(int i, int j) {
        return this.getInt(i, j);
    }

    @Override
    public float getFloat(int ... pos) {
        return this.getInt(pos);
    }

    @Override
    public long getLong(int i) {
        return this.getInt(i);
    }

    @Override
    public long getLong(int i, int j) {
        return this.getInt(i, j);
    }

    @Override
    public long getLong(int ... pos) {
        return this.getInt(pos);
    }

    @Override
    public int getInt(int i) {
        return this.get(i) ? 1 : 0;
    }

    @Override
    public int getInt(int i, int j) {
        return this.get(i, j) ? 1 : 0;
    }

    @Override
    public int getInt(int ... pos) {
        return this.get(pos) ? 1 : 0;
    }

    @Override
    public short getShort(int i) {
        return (short)this.getInt(i);
    }

    @Override
    public short getShort(int i, int j) {
        return (short)this.getInt(i, j);
    }

    @Override
    public short getShort(int ... pos) {
        return (short)this.getInt(pos);
    }

    @Override
    public byte getByte(int i) {
        return (byte)this.getInt(i);
    }

    @Override
    public byte getByte(int i, int j) {
        return (byte)this.getInt(i, j);
    }

    @Override
    public byte getByte(int ... pos) {
        return (byte)this.getInt(pos);
    }

    @Override
    public boolean getBoolean(int i) {
        return this.get(i);
    }

    @Override
    public boolean getBoolean(int i, int j) {
        return this.get(i, j);
    }

    @Override
    public boolean getBoolean(int ... pos) {
        return this.get(pos);
    }

    @Override
    public String getStringAbs(int index) {
        return this.stringFormat instanceof MessageFormat ? this.stringFormat.format(this.data[index]) : String.format("%b", this.data[index]);
    }

    @Override
    public BooleanDataset getSlice(SliceIterator siter) {
        BooleanDatasetBase base = super.getSlice(siter);
        BooleanDataset slice = new BooleanDataset();
        BooleanDataset.copyToView(base, slice, false, false);
        slice.setData();
        return slice;
    }

    @Override
    public BooleanDataset iadd(Object b) {
        Dataset bds = b instanceof Dataset ? (Dataset)b : DatasetFactory.createFromObject(b);
        BroadcastSelfIterator it = BroadcastSelfIterator.createIterator(this, bds);
        while (it.hasNext()) {
            int n = it.aIndex;
            this.data[n] = this.data[n] | bds.getElementBooleanAbs(it.bIndex);
        }
        this.setDirty();
        return this;
    }

    @Override
    public BooleanDataset isubtract(Object b) {
        Dataset bds = b instanceof Dataset ? (Dataset)b : DatasetFactory.createFromObject(b);
        BroadcastSelfIterator it = BroadcastSelfIterator.createIterator(this, bds);
        while (it.hasNext()) {
            int n = it.aIndex;
            this.data[n] = this.data[n] ^ bds.getElementBooleanAbs(it.bIndex);
        }
        this.setDirty();
        return this;
    }

    @Override
    public BooleanDataset imultiply(Object b) {
        Dataset bds = b instanceof Dataset ? (Dataset)b : DatasetFactory.createFromObject(b);
        BroadcastSelfIterator it = BroadcastSelfIterator.createIterator(this, bds);
        while (it.hasNext()) {
            int n = it.aIndex;
            this.data[n] = this.data[n] & bds.getElementBooleanAbs(it.bIndex);
        }
        this.setDirty();
        return this;
    }

    @Override
    public BooleanDataset idivide(Object b) {
        return this.imultiply(b);
    }

    @Override
    public BooleanDataset iremainder(Object b) {
        logger.error("Unsupported method for class");
        throw new UnsupportedOperationException("Unsupported method for class");
    }

    @Override
    public BooleanDataset ipower(Object b) {
        logger.error("Unsupported method for class");
        throw new UnsupportedOperationException("Unsupported method for class");
    }

    @Override
    public double residual(Object b, Dataset w, boolean ignoreNaNs) {
        Dataset bds = b instanceof Dataset ? (Dataset)b : DatasetFactory.createFromObject(b);
        BroadcastSelfIterator it = BroadcastSelfIterator.createIterator(this, bds);
        double sum = 0.0;
        if (w == null) {
            while (it.hasNext()) {
                if (!(this.data[it.aIndex] ^ bds.getElementBooleanAbs(it.bIndex))) continue;
                sum += 1.0;
            }
        } else {
            IndexIterator itw = w.getIterator();
            double comp = 0.0;
            while (it.hasNext() && itw.hasNext()) {
                if (!(this.data[it.aIndex] ^ bds.getElementBooleanAbs(it.bIndex))) continue;
                double err = w.getElementDoubleAbs(itw.index) - comp;
                double temp = sum + err;
                comp = temp - sum - err;
                sum = temp;
            }
        }
        return sum;
    }
}

