/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.query.apitests;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.query.apitests.Department;
import ee.jakarta.tck.persistence.core.query.apitests.Employee;
import ee.jakarta.tck.persistence.core.query.apitests.Insurance;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.NoResultException;
import jakarta.persistence.NonUniqueResultException;
import jakarta.persistence.Parameter;
import jakarta.persistence.Query;
import jakarta.persistence.TemporalType;
import jakarta.persistence.TransactionRequiredException;
import jakarta.persistence.TypedQuery;
import java.io.Serializable;
import java.sql.Date;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class Client1
extends PMClientBase {
    private final Employee[] empRef = new Employee[21];
    private final Date d1 = this.getSQLDate("2000-02-14");
    private final java.util.Date dateId = this.getUtilDate("2009-01-10");
    final Department[] deptRef = new Department[5];
    private static final DecimalFormat df = new DecimalFormat();

    public static void main(String[] args) {
        Client1 theTests = new Client1();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createTestData();
            this.logTrace("Done creating test data");
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception caught in Setup: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFirstResultTest() throws Exception {
        int gfr;
        Query query;
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = true;
        boolean pass11 = false;
        boolean pass12 = false;
        boolean pass13 = false;
        boolean pass14 = true;
        Object[][] expectedResultSet = new Object[][]{{4, 4}, {4, 9}, {4, 14}, {4, 19}, {5, 5}, {5, 10}, {5, 15}, {5, 20}};
        try {
            int i;
            this.getEntityTransaction().begin();
            this.logMsg("Testing Query version");
            query = this.getEntityManager().createQuery("select d.id, e.id from Department d join d.employees e where d.id <= 5  order by d.id, e.id");
            gfr = query.getFirstResult();
            if (gfr != 0) {
                this.logErr("getFirstResult() - Expecting result=0, actual=" + gfr);
            } else {
                pass1 = true;
            }
            query.setFirstResult(13);
            gfr = query.getFirstResult();
            if (gfr != 13) {
                this.logErr("getFirstResult() - Expecting result=11, actual=" + gfr);
            } else {
                pass2 = true;
            }
            List q = query.getResultList();
            if (TestUtil.traceflag) {
                this.logTrace("query returned " + q.size() + " results.");
                i = 0;
                for (Object obj : q) {
                    this.logTrace(i++ + "=" + Arrays.asList((Object[])obj));
                }
            }
            if (q.size() == 8) {
                this.logTrace("Expected size received, verify contents . . . ");
                i = 0;
                pass3 = true;
                for (Object obj : q) {
                    Object[] expected = expectedResultSet[i++];
                    Object[] departmentIdEmpId = null;
                    if (obj instanceof Object[]) {
                        this.logTrace("The element in the result list is of type Object[], continue . . .");
                        departmentIdEmpId = (Object[])obj;
                        if (Arrays.equals(expected, departmentIdEmpId)) continue;
                        this.logErr("Expecting element value: " + Arrays.asList(expected) + ", actual element value: " + Arrays.asList(departmentIdEmpId));
                        pass4 = false;
                    } else {
                        this.logErr("The element in the result list is not of type Object[]:" + obj);
                        pass4 = false;
                    }
                    break;
                }
            } else {
                this.logErr("Did not get expected results.  Expected: 10, got: " + q.size());
                this.logErr("Expected results:");
                i = 0;
                for (Object[] obj : expectedResultSet) {
                    this.logErr(i++ + "=" + Arrays.toString(obj));
                }
                this.logErr("Actual results:");
                i = 0;
                for (Object obj : q) {
                    this.logErr(i++ + "=" + Arrays.asList((Object[])obj));
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in while rolling back TX:", re);
            }
        }
        this.logMsg("Testing TypedQuery version");
        try {
            this.getEntityTransaction().begin();
            query = this.getEntityManager().createQuery("select e.id from Employee e where e.id <= 10 order by e.id", Integer.class);
            gfr = query.getFirstResult();
            if (gfr != 0) {
                this.logErr("getFirstResult() - Expecting result=0, actual=" + gfr);
            } else {
                pass11 = true;
            }
            query.setFirstResult(5);
            gfr = query.getFirstResult();
            if (gfr != 5) {
                this.logErr("getFirstResult() - Expecting result=5, actual=" + gfr);
            } else {
                pass12 = true;
            }
            List actual = query.getResultList();
            String[] expected = new String[]{"6", "7", "8", "9", "10"};
            if (!this.checkEntityPK(actual, expected)) {
                this.logErr("Did not get expected results. Expected " + expected.length + " references, got: " + actual.size());
            } else {
                this.logTrace("Expected results received");
                pass13 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass14 = false;
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in while rolling back TX:", re);
            }
        }
        if (!(pass1 && pass2 && pass3 && pass4 && pass11 && pass12 && pass13 && pass14)) {
            throw new Exception("setFirstResultTest failed");
        }
    }

    public void setFirstResultIllegalArgumentExceptionTest() throws Exception {
        Query query;
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.logMsg("Testing Query version");
            query = this.getEntityManager().createQuery("select e.id from Employee e where e.id <= 10 order by e.id");
            query.setFirstResult(-5);
            this.logErr("IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException iae) {
            this.logTrace("Received expected IllegalArgumentException");
            pass1 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        this.logMsg("Testing TypedQuery version");
        try {
            query = this.getEntityManager().createQuery("select e.id from Employee e where e.id <= 10 order by e.id", Integer.class);
            query.setFirstResult(-5);
            this.logErr("IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException iae) {
            this.logTrace("Received expected IllegalArgumentException");
            pass2 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("setFirstResultIllegalArgumentExceptionTest failed");
        }
    }

    public void getParameterTest() throws Exception {
        String s;
        Parameter p;
        Query q;
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.logMsg("Testing Query version");
            q = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName").setParameter("fName", (Object)"Stephen");
            p = q.getParameter("fName", String.class);
            s = p.getName();
            if (!s.equals("fName")) {
                this.logErr("getName() - Expected:fName, actual:" + s);
            } else {
                pass1 = true;
            }
        }
        catch (IllegalStateException ise) {
            pass1 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        this.logMsg("Testing TypedQuery version");
        try {
            q = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName", Employee.class).setParameter("fName", (Object)"Stephen");
            p = q.getParameter("fName", String.class);
            s = p.getName();
            if (!s.equals("fName")) {
                this.logErr("getName() - Expected:fName, actual:" + s);
            } else {
                pass2 = true;
            }
        }
        catch (IllegalStateException ise) {
            pass2 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("getParameterTest failed");
        }
    }

    public void getParameterIllegalArgumentExceptionTest() throws Exception {
        Query q;
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.logMsg("Testing Query version");
            q = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName");
            q.getParameter("doesnotexist", String.class);
            this.logErr("IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException iae) {
            this.logTrace("Received expected IllegalArgumentException");
            pass1 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        this.logMsg("Testing TypedQuery version");
        try {
            q = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName", Employee.class);
            q.getParameter("doesnotexist", String.class);
            this.logErr("IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException iae) {
            this.logTrace("Received expected IllegalArgumentException");
            pass2 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("getParameterIllegalArgumentExceptionTest failed");
        }
    }

    public void getParameterIllegalArgumentException2Test() throws Exception {
        Query q;
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.logMsg("Testing Query version");
            q = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName");
            q.getParameter("doesnotexist");
            this.logErr("IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException iae) {
            this.logTrace("Received expected IllegalArgumentException");
            pass1 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        this.logMsg("Testing TypedQuery version");
        try {
            q = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName", Employee.class);
            q.getParameter("doesnotexist");
            this.logErr("IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException iae) {
            this.logTrace("Received expected IllegalArgumentException");
            pass2 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("getParameterIllegalArgumentException2Test failed");
        }
    }

    public void getParameterIntClassTest() throws Exception {
        String s;
        Parameter p;
        Query q;
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.logMsg("Testing Query version");
            q = this.getEntityManager().createQuery("select e from Employee e where e.firstName = ?1").setParameter(1, (Object)"Stephen");
            p = q.getParameter(1, String.class);
            s = p.getName();
            if (s != null) {
                this.logErr("getName() - Expected:null, actual:" + s);
            } else {
                pass1 = true;
            }
        }
        catch (IllegalStateException ise) {
            pass1 = true;
            this.logTrace("Received expected IllegalArgumentException");
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        this.logMsg("Testing TypedQuery version");
        try {
            q = this.getEntityManager().createQuery("select e from Employee e where e.firstName = ?1", Employee.class).setParameter(1, (Object)"Stephen");
            p = q.getParameter(1, String.class);
            s = p.getName();
            if (s != null) {
                this.logErr("getName() - Expected:null, actual:" + s);
            } else {
                pass2 = true;
            }
        }
        catch (IllegalStateException ise) {
            pass2 = true;
            this.logTrace("Received expected IllegalArgumentException");
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("getParameterIntClassTest failed");
        }
    }

    public void getParameterIntIllegalArgumentExceptionTest() throws Exception {
        Query query;
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.logTrace("Creating query for getParameterIntIllegalArgumentExceptionTest");
            this.logMsg("Testing Query version");
            query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = ?1").setParameter(1, (Object)"foo");
            query.getParameter(99);
            this.logErr("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            this.logTrace("Received expected IllegalArgumentException");
            pass1 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        this.logMsg("Testing TypedQuery version");
        try {
            query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = ?1", Employee.class).setParameter(1, (Object)"foo");
            query.getParameter(99);
            this.logErr("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            this.logTrace("Received expected IllegalArgumentException");
            pass2 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("getParameterIntIllegalArgumentExceptionTest failed");
        }
    }

    public void getParameterValueParameterTest() throws Exception {
        String s;
        Parameter p;
        Query query;
        boolean pass1 = false;
        boolean pass2 = false;
        String expectedName = "fName";
        String expectedValue = "Stephen";
        try {
            this.logMsg("Testing Query version");
            query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName").setParameter(expectedName, (Object)expectedValue);
            p = query.getParameter(expectedName);
            if (p != null) {
                s = (String)query.getParameterValue(p);
                if (!s.equals(expectedValue)) {
                    this.logErr("Expected:" + expectedValue + ",Actual=" + s);
                } else {
                    pass1 = true;
                }
            } else {
                this.logErr("getParameter returned null");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        this.logMsg("Testing TypedQuery version");
        try {
            query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName", Employee.class).setParameter(expectedName, (Object)expectedValue);
            p = query.getParameter(expectedName);
            if (p != null) {
                s = (String)query.getParameterValue(p);
                if (!s.equals(expectedValue)) {
                    this.logErr("Expected:" + expectedValue + ",Actual=" + s);
                } else {
                    pass2 = true;
                }
            } else {
                this.logErr("getParameter returned null");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("getParameterValueParameterTest failed");
        }
    }

    public void getParameterValueParameterIllegalArgumentExceptionTest() throws Exception {
        Parameter p;
        Query query2;
        Query query1;
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.logMsg("Testing Query version");
            query1 = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fname1").setParameter("fname1", (Object)"fnameValue1");
            query2 = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fname2").setParameter("fname2", (Object)"fnameValue2");
            p = query2.getParameter("fname2");
            query1.getParameterValue(p);
            this.logErr("IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException iae) {
            this.logTrace("Received expected IllegalArgumentException");
            pass1 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        this.logMsg("Testing TypedQuery version");
        try {
            query1 = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fname1", Employee.class).setParameter("fname1", (Object)"fnameValue1");
            query2 = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fname2", Employee.class).setParameter("fname2", (Object)"fnameValue2");
            p = query2.getParameter("fname2");
            query1.getParameterValue(p);
            this.logErr("IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException iae) {
            this.logTrace("Received expected IllegalArgumentException");
            pass2 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("getParameterValueParameterIllegalArgumentExceptionTest failed");
        }
    }

    public void getParameterValueParameterIllegalStateExceptionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        this.logMsg("Testing Query version");
        Query query1 = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName1");
        Set set = query1.getParameters();
        if (set.size() != 1) {
            this.logErr("Expected one parameter, actual=" + set.size());
            for (Object p : set) {
                this.logErr("Parameter:" + p.toString());
            }
        } else {
            pass1 = true;
        }
        try {
            for (Object p : set) {
                query1.getParameterValue((Parameter)p);
            }
            this.logErr("IllegalStateException was not thrown");
        }
        catch (IllegalStateException iae) {
            this.logTrace("Received expected IllegalStateException");
            pass2 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        this.logMsg("Testing TypedQuery version");
        TypedQuery tquery1 = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName1", Employee.class);
        set = tquery1.getParameters();
        if (set.size() != 1) {
            this.logErr("Expected one parameter, actual=" + set.size());
            for (Parameter p : set) {
                this.logErr("Parameter:" + p.toString());
            }
        } else {
            pass3 = true;
        }
        try {
            for (Parameter p : set) {
                tquery1.getParameterValue(p);
            }
            this.logErr("IllegalStateException was not thrown");
        }
        catch (IllegalStateException iae) {
            this.logTrace("Received expected IllegalStateException");
            pass4 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new Exception("getParameterValueParameterIllegalStateExceptionTest failed");
        }
    }

    public void setParameterParameterObjectIllegalArgumentExceptionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        this.logMsg("Testing Query version");
        Query query1 = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName1");
        Query query2 = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName2");
        Set set = query2.getParameters();
        if (set.size() != 1) {
            this.logErr("Expected one parameter, actual=" + set.size());
            for (Parameter p : set) {
                this.logErr("Parameter:" + p.toString());
            }
        } else {
            pass1 = true;
        }
        try {
            for (Parameter p : set) {
                query1.setParameter(p, (Object)"object1");
            }
            this.logErr("IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException iae) {
            this.logTrace("Received expected IllegalArgumentException");
            pass2 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        this.logMsg("Testing TypedQuery version");
        TypedQuery tquery1 = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName1", Employee.class);
        TypedQuery tquery2 = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName2", Employee.class);
        set = tquery2.getParameters();
        if (set.size() != 1) {
            this.logErr("Expected one parameter, actual=" + set.size());
            for (Parameter p : set) {
                this.logErr("Parameter:" + p.toString());
            }
        } else {
            pass3 = true;
        }
        try {
            for (Parameter p : set) {
                tquery1.setParameter(p, (Object)"object1");
            }
            this.logErr("IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException iae) {
            this.logTrace("Received expected IllegalArgumentException");
            pass4 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new Exception("setParameterParameterObjectIllegalArgumentExceptionTest failed");
        }
    }

    public void setParameterParameterCalendarTemporalTypeIllegalArgumentExceptionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        this.logMsg("Testing Query version");
        Query query1 = this.getEntityManager().createQuery("select e from Employee e where e.hireDate = :date1");
        Query query2 = this.getEntityManager().createQuery("select e from Employee e where e.hireDate = :date2");
        Set set = query2.getParameters();
        if (set.size() != 1) {
            this.logErr("Expected one parameter, actual=" + set.size());
            for (Parameter p : set) {
                this.logErr("Parameter:" + p.toString());
            }
        } else {
            pass1 = true;
        }
        try {
            for (Parameter p : set) {
                query1.setParameter(p, this.getCalDate(), TemporalType.DATE);
            }
            this.logErr("IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException iae) {
            this.logTrace("Received expected IllegalArgumentException");
            pass2 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        this.logMsg("Testing TypedQuery version");
        TypedQuery tquery1 = this.getEntityManager().createQuery("select e from Employee e where e.hireDate = :date1", Employee.class);
        TypedQuery tquery2 = this.getEntityManager().createQuery("select e from Employee e where e.hireDate = :date2", Employee.class);
        set = tquery2.getParameters();
        if (set.size() != 1) {
            this.logErr("Expected one parameter, actual=" + set.size());
            for (Parameter p : set) {
                this.logErr("Parameter:" + p.toString());
            }
        } else {
            pass3 = true;
        }
        try {
            for (Parameter p : set) {
                tquery1.setParameter(p, this.getCalDate(), TemporalType.DATE);
            }
            this.logErr("IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException iae) {
            this.logTrace("Received expected IllegalArgumentException");
            pass4 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new Exception("setParameterParameterCalendarTemporalTypeIllegalArgumentExceptionTest failed");
        }
    }

    public void setParameterParameterDateTemporalTypeIllegalArgumentExceptionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        this.logMsg("Testing Query version");
        Query query1 = this.getEntityManager().createQuery("select e from Employee e where e.hireDate = :date1");
        Query query2 = this.getEntityManager().createQuery("select e from Employee e where e.hireDate = :date2");
        Set set = query2.getParameters();
        if (set.size() != 1) {
            this.logErr("Expected one parameter, actual=" + set.size());
            for (Parameter p : set) {
                this.logErr("Parameter:" + p.toString());
            }
        } else {
            pass1 = true;
        }
        try {
            for (Parameter p : set) {
                query1.setParameter(p, this.dateId, TemporalType.DATE);
            }
            this.logErr("IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException iae) {
            this.logTrace("Received expected IllegalArgumentException");
            pass2 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        this.logMsg("Testing TypedQuery version");
        TypedQuery tquery1 = this.getEntityManager().createQuery("select e from Employee e where e.hireDate = :date1", Employee.class);
        TypedQuery tquery2 = this.getEntityManager().createQuery("select e from Employee e where e.hireDate = :date2", Employee.class);
        set = tquery2.getParameters();
        if (set.size() != 1) {
            this.logErr("Expected one parameter, actual=" + set.size());
            for (Parameter p : set) {
                this.logErr("Parameter:" + p.toString());
            }
        } else {
            pass3 = true;
        }
        try {
            for (Parameter p : set) {
                tquery1.setParameter(p, this.dateId, TemporalType.DATE);
            }
            this.logErr("IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException iae) {
            this.logTrace("Received expected IllegalArgumentException");
            pass4 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new Exception("setParameterParameterDateTemporalTypeIllegalArgumentExceptionTest failed");
        }
    }

    public void getParameterValueStringTest() throws Exception {
        String s;
        Query query;
        boolean pass1 = false;
        boolean pass2 = false;
        String expectedName = "fName";
        String expectedValue = "Stephen";
        try {
            this.logMsg("Testing Query version");
            query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName").setParameter(expectedName, (Object)expectedValue);
            s = (String)query.getParameterValue(expectedName);
            if (!s.equals(expectedValue)) {
                this.logErr("Expected:" + expectedValue + ",Actual=" + s);
            } else {
                pass1 = true;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        this.logMsg("Testing TypedQuery version");
        try {
            query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName", Employee.class).setParameter(expectedName, (Object)expectedValue);
            s = (String)query.getParameterValue(expectedName);
            if (!s.equals(expectedValue)) {
                this.logErr("Expected:" + expectedValue + ",Actual=" + s);
            } else {
                pass2 = true;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("getParameterValueStringTest failed");
        }
    }

    public void getParameterValueStringIllegalArgumentExceptionTest() throws Exception {
        Query query;
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.logMsg("Testing Query version");
            query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName1").setParameter("fName1", (Object)"fnameValue");
            query.getParameterValue("fName2");
            this.logErr("IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException iae) {
            this.logTrace("Received expected IllegalArgumentException");
            pass1 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        this.logMsg("Testing TypedQuery version");
        try {
            query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName1", Employee.class).setParameter("fName1", (Object)"fnameValue");
            query.getParameterValue("fName2");
            this.logErr("IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException iae) {
            this.logTrace("Received expected IllegalArgumentException");
            pass2 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("getParameterValueStringIllegalArgumentExceptionTest failed");
        }
    }

    public void getParameterValueStringIllegalStateExceptionTest() throws Exception {
        Query query;
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.logMsg("Testing Query version");
            query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fname1");
            query.getParameterValue("fname1");
            this.logErr("IllegalStateException was not thrown");
        }
        catch (IllegalStateException iae) {
            this.logTrace("Received expected IllegalStateException");
            pass1 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        this.logMsg("Testing TypedQuery version");
        try {
            query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fname1", Employee.class);
            query.getParameterValue("fname1");
            this.logErr("IllegalStateException was not thrown");
        }
        catch (IllegalStateException iae) {
            this.logTrace("Received expected IllegalStateException");
            pass2 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("getParameterValueStringIllegalStateExceptionTest failed");
        }
    }

    public void getParameterValueIntTest() throws Exception {
        String s;
        Query query;
        boolean pass1 = false;
        boolean pass2 = false;
        String expectedValue = "Stephen";
        try {
            this.logMsg("Testing Query version");
            query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = ?1").setParameter(1, (Object)expectedValue);
            s = (String)query.getParameterValue(1);
            if (!s.equals(expectedValue)) {
                this.logErr("Expected:" + expectedValue + ",Actual=" + s);
            } else {
                pass1 = true;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        this.logMsg("Testing TypedQuery version");
        try {
            query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = ?1", Employee.class).setParameter(1, (Object)expectedValue);
            s = (String)query.getParameterValue(1);
            if (!s.equals(expectedValue)) {
                this.logErr("Expected:" + expectedValue + ",Actual=" + s);
            } else {
                pass2 = true;
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("getParameterValueIntTest failed");
        }
    }

    public void getParameterValueIntIllegalArgumentExceptionTest() throws Exception {
        Query query;
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.logMsg("Testing Query version");
            query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = ?1").setParameter(1, (Object)"foo");
            query.getParameterValue(99);
            this.logErr("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            this.logTrace("Received expected IllegalArgumentException");
            pass1 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        this.logMsg("Testing TypedQuery version");
        try {
            query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = ?1", Employee.class).setParameter(1, (Object)"foo");
            query.getParameterValue(99);
            this.logErr("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            this.logTrace("Received expected IllegalArgumentException");
            pass2 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("getParameterValueIntIllegalArgumentExceptionTest failed");
        }
    }

    public void getParameterValueIntIllegalStateExceptionTest() throws Exception {
        Query query;
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.logMsg("Testing Query version");
            query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = ?1");
            query.getParameterValue(1);
            this.logErr("IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            this.logTrace("Received expected IllegalStateException");
            pass1 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        this.logMsg("Testing TypedQuery version");
        try {
            query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = ?1", Employee.class);
            query.getParameterValue(1);
            this.logErr("IllegalStateException not thrown");
        }
        catch (IllegalStateException e) {
            this.logTrace("Received expected IllegalStateException");
            pass2 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("getParameterValueIntIllegalStateExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameter1Test() throws Exception {
        List result;
        Query query;
        boolean pass1 = false;
        boolean pass2 = false;
        Integer[] expected = new Integer[]{this.empRef[4].getId(), this.empRef[6].getId()};
        try {
            this.logMsg("Testing Query version");
            this.getEntityTransaction().begin();
            query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName").setParameter("fName", (Object)"Stephen");
            result = query.getResultList();
            if (!this.checkEntityPK(result, expected)) {
                this.logErr("Did not get expected results. Expected " + expected.length + " references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass1 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in while rolling back TX:", re);
            }
        }
        this.logMsg("Testing TypedQuery version");
        try {
            this.getEntityTransaction().begin();
            query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName", Employee.class).setParameter("fName", (Object)"Stephen");
            result = query.getResultList();
            if (!this.checkEntityPK(result, expected)) {
                this.logErr("Did not get expected results. Expected " + expected.length + " references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in while rolling back TX:", re);
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("setParameter1Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameter2Test() throws Exception {
        boolean pass = false;
        Integer[] expected = new Integer[]{this.empRef[0].getId(), this.empRef[4].getId(), this.empRef[6].getId()};
        try {
            this.getEntityTransaction().begin();
            Query query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName or e.firstName = :Fname").setParameter("fName", (Object)"Stephen").setParameter("Fname", (Object)"Alan");
            List result = query.getResultList();
            if (!this.checkEntityPK(result, expected)) {
                this.logErr("Did not get expected results. Expected " + expected.length + " references, got: " + result.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in while rolling back TX:", re);
            }
        }
        if (!pass) {
            throw new Exception("setParameter2Test failed");
        }
    }

    public void setParameterStringObject1IllegalArgumentExceptionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        this.logMsg("Testing Query version");
        try {
            this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName").setParameter("fName", (Object)Float.valueOf(5.0f));
            this.logErr("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            this.logTrace("Received expected IllegalArgumentException");
            pass1 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        this.logMsg("Testing TypedQuery version");
        try {
            this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName", Employee.class).setParameter("fName", (Object)Float.valueOf(5.0f));
            this.logErr("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            this.logTrace("Received expected IllegalArgumentException");
            pass2 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("setParameterStringObject1IllegalArgumentExceptionTest failed");
        }
    }

    public void setParameterStringObject2IllegalArgumentExceptionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        this.logMsg("Testing Query version");
        try {
            this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName").setParameter("doesnotexist", (Object)"foo");
            this.logErr("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            this.logTrace("Received expected IllegalArgumentException");
            pass1 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        this.logMsg("Testing TypedQuery version");
        try {
            this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName", Employee.class).setParameter("doesnotexist", (Object)"foo");
            this.logErr("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException e) {
            this.logTrace("Received expected IllegalArgumentException");
            pass2 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("setParameterStringObject2IllegalArgumentExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameterStringDateTemporalTypeTest() throws Exception {
        List q;
        boolean pass1 = false;
        boolean pass2 = false;
        ArrayList<Employee> cEmp = new ArrayList<Employee>();
        cEmp.add(this.empRef[0]);
        cEmp.add(this.empRef[19]);
        this.logMsg("Testing Query version");
        try {
            this.getEntityTransaction().begin();
            Query query = this.getEntityManager().createQuery("select e from Employee e where e.hireDate = :hDate");
            q = query.setParameter("hDate", (java.util.Date)this.d1, TemporalType.DATE).getResultList();
            if (!this.checkEntityPK(q, cEmp)) {
                this.logErr("Did not get expected results. Expected " + cEmp.size() + " references, got: " + q.size());
            } else {
                this.logTrace("Expected results received");
                pass1 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in while rolling back TX:", re);
            }
        }
        this.logMsg("Testing TypedQuery version");
        try {
            this.getEntityTransaction().begin();
            TypedQuery tquery = this.getEntityManager().createQuery("select e from Employee e where e.hireDate = :hDate", Employee.class);
            q = tquery.setParameter("hDate", (java.util.Date)this.d1, TemporalType.DATE).getResultList();
            if (!this.checkEntityPK(q, cEmp)) {
                this.logErr("Did not get expected results. Expected " + cEmp.size() + " references, got: " + q.size());
            } else {
                this.logTrace("Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in while rolling back TX:", re);
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("setParameterStringDateTemporalTypeTest failed");
        }
    }

    public void setParameterStringDateTemporalTypeIllegalArgumentExceptionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        this.logMsg("Testing Query version");
        try {
            this.getEntityManager().createQuery("select e from Employee e where e.hireDate = :hDate").setParameter("doesnotexist", (java.util.Date)this.d1, TemporalType.DATE);
            this.logErr("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException iae) {
            this.logTrace("IllegalArgumentException Caught as Expected");
            pass1 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        this.logMsg("Testing TypedQuery version");
        try {
            this.getEntityManager().createQuery("select e from Employee e where e.hireDate = :hDate", Employee.class).setParameter("doesnotexist", (java.util.Date)this.d1, TemporalType.DATE);
            this.logErr("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException iae) {
            this.logTrace("IllegalArgumentException Caught as Expected");
            pass2 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("setParameterStringDateTemporalTypeIllegalArgumentExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameterStringCalendarTemporalTypeTest() throws Exception {
        List q;
        boolean pass1 = false;
        boolean pass2 = false;
        ArrayList<Employee> cEmp = new ArrayList<Employee>();
        cEmp.add(this.empRef[20]);
        try {
            this.logMsg("Testing Query version");
            this.getEntityTransaction().begin();
            Query query = this.getEntityManager().createQuery("select e from Employee e where e.hireDate = :hDate");
            q = query.setParameter("hDate", this.getCalDate(), TemporalType.DATE).getResultList();
            if (!this.checkEntityPK(q, cEmp)) {
                this.logErr("Did not get expected results. Expected " + cEmp.size() + " references, got: " + q.size());
            } else {
                this.logTrace("Expected results received");
                pass1 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in while rolling back TX:", re);
            }
        }
        this.logMsg("Testing TypedQuery version");
        try {
            this.getEntityTransaction().begin();
            TypedQuery tquery = this.getEntityManager().createQuery("select e from Employee e where e.hireDate = :hDate", Employee.class);
            q = tquery.setParameter("hDate", this.getCalDate(), TemporalType.DATE).getResultList();
            if (!this.checkEntityPK(q, cEmp)) {
                this.logErr("Did not get expected results. Expected " + cEmp.size() + " references, got: " + q.size());
            } else {
                this.logTrace("Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in while rolling back TX:", re);
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("setParameterStringCalendarTemporalTypeTest failed");
        }
    }

    public void setParameterStringCalendarTemporalTypeTestIllegalArgumentExceptionTest() throws Exception {
        Calendar c = Calendar.getInstance();
        boolean pass1 = false;
        boolean pass2 = false;
        this.logMsg("Testing Query version");
        try {
            this.getEntityManager().createQuery("select d from Department d where :param > 1").setParameter("badName", c, TemporalType.TIMESTAMP);
            this.logErr("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException iae) {
            this.logTrace("IllegalArgumentException Caught as Expected");
            pass1 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        this.logMsg("Testing TypedQuery version");
        try {
            this.getEntityManager().createQuery("select d from Department d where :param > 1", Department.class).setParameter("badName", c, TemporalType.TIMESTAMP);
            this.logErr("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException iae) {
            this.logTrace("IllegalArgumentException Caught as Expected");
            pass2 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("setParameterStringCalendarTemporalTypeTestIllegalArgumentExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameterIntObjectTest() throws Exception {
        List q;
        boolean pass1 = false;
        boolean pass2 = false;
        ArrayList<Employee> cEmp = new ArrayList<Employee>();
        cEmp.add(this.empRef[4]);
        cEmp.add(this.empRef[6]);
        try {
            this.logMsg("Testing Query version");
            this.getEntityTransaction().begin();
            Query query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = ?1");
            q = query.setParameter(1, (Object)"Stephen").getResultList();
            if (!this.checkEntityPK(q, cEmp)) {
                this.logErr("Did not get expected results. Expected " + cEmp.size() + " references, got: " + q.size());
            } else {
                this.logTrace("Expected results received");
                pass1 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in while rolling back TX:", re);
            }
        }
        this.logMsg("Testing TypedQuery version");
        try {
            this.getEntityTransaction().begin();
            TypedQuery tquery = this.getEntityManager().createQuery("select e from Employee e where e.firstName = ?1", Employee.class);
            q = tquery.setParameter(1, (Object)"Stephen").getResultList();
            if (!this.checkEntityPK(q, cEmp)) {
                this.logErr("Did not get expected results. Expected " + cEmp.size() + " references, got: " + q.size());
            } else {
                this.logTrace("Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in while rolling back TX:", re);
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("setParameterIntObjectTest failed");
        }
    }

    public void setParameterIntObjectIllegalArgumentExceptionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        this.logMsg("Testing query version");
        try {
            this.logMsg("Testing a parm that does not exist ");
            this.getEntityManager().createQuery("select e from Employee e where e.firstName = ?1").setParameter(1, (Object)"Kellie").setParameter(2, (Object)"Lee");
            this.logErr("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException iae) {
            this.logTrace("IllegalArgumentException Caught as Expected");
            pass1 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        try {
            this.logMsg("Testing a parm of incorrect type");
            this.getEntityManager().createQuery("select e from Employee e where e.firstName = ?1").setParameter(1, (Object)1);
            this.logErr("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException iae) {
            this.logTrace("IllegalArgumentException Caught as Expected");
            pass2 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        this.logMsg("Testing TypedQuery version");
        try {
            this.logMsg("Testing a parm that does not exist");
            this.getEntityManager().createQuery("select e from Employee e where e.firstName = ?1", Employee.class).setParameter(1, (Object)"Kellie").setParameter(2, (Object)"Lee");
            this.logErr("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException iae) {
            this.logTrace("IllegalArgumentException Caught as Expected");
            pass3 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        try {
            this.logMsg("Testing a parm of incorrect type");
            this.getEntityManager().createQuery("select e from Employee e where e.firstName = ?1", Employee.class).setParameter(1, (Object)1);
            this.logErr("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException iae) {
            this.logTrace("IllegalArgumentException Caught as Expected");
            pass4 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new Exception("setParameterIntObjectIllegalArgumentExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameterIntDateTemporalTypeTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        ArrayList<Employee> cEmp = new ArrayList<Employee>();
        cEmp.add(this.empRef[0]);
        cEmp.add(this.empRef[19]);
        try {
            this.logMsg("Testing Query version");
            this.getEntityTransaction().begin();
            List q = this.getEntityManager().createQuery("select e from Employee e where e.hireDate = ?1").setParameter(1, (java.util.Date)this.d1, TemporalType.DATE).getResultList();
            if (!this.checkEntityPK(q, cEmp)) {
                this.logErr("Did not get expected results. Expected " + cEmp.size() + " references, got: " + q.size());
            } else {
                this.logTrace("Expected results received");
                pass1 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in while rolling back TX:", re);
            }
        }
        this.logMsg("Testing TypedQuery version");
        try {
            this.getEntityTransaction().begin();
            TypedQuery tquery = this.getEntityManager().createQuery("select e from Employee e where e.hireDate = ?1", Employee.class);
            List q = tquery.setParameter(1, (java.util.Date)this.d1, TemporalType.DATE).getResultList();
            if (!this.checkEntityPK(q, cEmp)) {
                this.logErr("Did not get expected results. Expected " + cEmp.size() + " references, got: " + q.size());
            } else {
                this.logTrace("Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in while rolling back TX:", re);
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("setParameterIntDateTemporalTypeTest failed");
        }
    }

    public void setParameterIntDateTemporalTypeIllegalArgumentException1Test() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        this.logMsg("Testing Query version");
        try {
            this.getEntityManager().createQuery("select d from Department d where :hDate > 1").setParameter(5, (java.util.Date)this.d1, TemporalType.DATE);
            this.logErr("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException iae) {
            this.logTrace("IllegalArgumentException Caught as Expected");
            pass1 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        this.logMsg("Testing TypedQuery version");
        try {
            this.getEntityManager().createQuery("select d from Department d where :hDate > 1", Department.class).setParameter(5, (java.util.Date)this.d1, TemporalType.DATE);
            this.logErr("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException iae) {
            this.logTrace("IllegalArgumentException Caught as Expected");
            pass2 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("setParameterIntDateTemporalTypeIllegalArgumentException1Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameterIntCalendarTemporalTypeTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        ArrayList<Employee> cEmp = new ArrayList<Employee>();
        cEmp.add(this.empRef[20]);
        try {
            this.logMsg("Testing Query version");
            this.getEntityTransaction().begin();
            List q = this.getEntityManager().createQuery("select e from Employee e where e.hireDate = ?1").setParameter(1, this.getCalDate(), TemporalType.DATE).getResultList();
            if (!this.checkEntityPK(q, cEmp)) {
                this.logErr("Did not get expected results. Expected " + cEmp.size() + " references, got: " + q.size());
            } else {
                this.logTrace("Expected results received");
                pass1 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in while rolling back TX:", re);
            }
        }
        this.logMsg("Testing TypedQuery version");
        try {
            this.getEntityTransaction().begin();
            TypedQuery tquery = this.getEntityManager().createQuery("select e from Employee e where e.hireDate = ?1", Employee.class);
            List q = tquery.setParameter(1, this.getCalDate(), TemporalType.DATE).getResultList();
            if (!this.checkEntityPK(q, cEmp)) {
                this.logErr("Did not get expected results. Expected " + cEmp.size() + " references, got: " + q.size());
            } else {
                this.logTrace("Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in while rolling back TX:", re);
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("setParameterIntCalendarTemporalTypeTest failed");
        }
    }

    public void setParameterIntCalendarTemporalTypeIllegalArgumentExceptionTest() throws Exception {
        Calendar c = Calendar.getInstance();
        boolean pass1 = false;
        boolean pass2 = false;
        this.logMsg("Testing Query version");
        try {
            this.getEntityManager().createQuery("select d from Department d where ?1 > 1").setParameter(5, c, TemporalType.TIMESTAMP);
            this.logErr("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException iae) {
            this.logTrace("IllegalArgumentException Caught as Expected");
            pass1 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        this.logMsg("Testing TypedQuery version");
        try {
            this.getEntityManager().createQuery("select d from Department d where ?1 > 1", Department.class).setParameter(5, c, TemporalType.TIMESTAMP);
            this.logErr("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException iae) {
            this.logTrace("IllegalArgumentException Caught as Expected");
            pass2 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("setParameterIntCalendarTemporalTypeIllegalArgumentExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameter7Test() throws Exception {
        List q;
        Parameter p;
        Query query;
        boolean pass1 = false;
        boolean pass2 = false;
        ArrayList<Employee> cEmp = new ArrayList<Employee>();
        cEmp.add(this.empRef[1]);
        try {
            this.logMsg("Testing Query version");
            this.getEntityTransaction().begin();
            query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = ?1").setParameter(1, (Object)"Stephen");
            p = query.getParameter(1);
            query.setParameter(p, (Object)"Arthur");
            q = query.getResultList();
            if (!this.checkEntityPK(q, cEmp)) {
                this.logErr("Did not get expected results. Expected " + cEmp.size() + " references, got: " + q.size());
            } else {
                this.logTrace("Expected results received");
                pass1 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in while rolling back TX:", re);
            }
        }
        this.logMsg("Testing TypedQuery version");
        try {
            this.getEntityTransaction().begin();
            query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = ?1", Employee.class).setParameter(1, (Object)"Stephen");
            p = query.getParameter(1);
            query.setParameter(p, (Object)"Arthur");
            q = query.getResultList();
            if (!this.checkEntityPK(q, cEmp)) {
                this.logErr("Did not get expected results. Expected " + cEmp.size() + " references, got: " + q.size());
            } else {
                this.logTrace("Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in while rolling back TX:", re);
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("setParameter7Test failed");
        }
    }

    public void setParameterParameterCalendarTemporalTypeTest() throws Exception {
        List q;
        Parameter p;
        boolean pass1 = false;
        boolean pass2 = false;
        ArrayList<Employee> cEmp = new ArrayList<Employee>();
        cEmp.add(this.empRef[20]);
        try {
            this.getEntityTransaction().begin();
            this.logMsg("Testing Query version");
            Query query = this.getEntityManager().createQuery("select e from Employee e where e.hireDate = ?1");
            p = query.getParameter(1);
            query.setParameter(p, this.getCalDate(), TemporalType.DATE);
            q = query.getResultList();
            if (!this.checkEntityPK(q, cEmp)) {
                this.logErr("Did not get expected results. Expected " + cEmp.size() + " references, got: " + q.size());
            } else {
                this.logTrace("Expected results received");
                pass1 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        this.logMsg("Testing TypedQuery version");
        try {
            this.getEntityTransaction().begin();
            TypedQuery tquery = this.getEntityManager().createQuery("select e from Employee e where e.hireDate = ?1", Employee.class);
            p = tquery.getParameter(1);
            tquery.setParameter(p, this.getCalDate(), TemporalType.DATE);
            q = tquery.getResultList();
            if (!this.checkEntityPK(q, cEmp)) {
                this.logErr("Did not get expected results. Expected " + cEmp.size() + " references, got: " + q.size());
            } else {
                this.logTrace("Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("setParameterParameterCalendarTemporalTypeTest failed");
        }
    }

    public void setParameterParameterDateTemporalTypeTest() throws Exception {
        List q;
        Parameter p;
        boolean pass1 = false;
        boolean pass2 = false;
        ArrayList<Employee> cEmp = new ArrayList<Employee>();
        cEmp.add(this.empRef[5]);
        cEmp.add(this.empRef[14]);
        try {
            this.getEntityTransaction().begin();
            this.logMsg("Testing Query version");
            Query query = this.getEntityManager().createQuery("select e from Employee e where e.hireDate = ?1");
            p = query.getParameter(1);
            query.setParameter(p, this.getUtilDate("2005-02-18"), TemporalType.DATE);
            q = query.getResultList();
            if (!this.checkEntityPK(q, cEmp)) {
                this.logErr("Did not get expected results. Expected " + cEmp.size() + " references, got: " + q.size());
            } else {
                this.logTrace("Expected results received");
                pass1 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        this.logMsg("Testing TypedQuery version");
        try {
            this.getEntityTransaction().begin();
            TypedQuery tquery = this.getEntityManager().createQuery("select e from Employee e where e.hireDate = ?1", Employee.class);
            p = tquery.getParameter(1);
            tquery.setParameter(p, this.getUtilDate("2005-02-18"), TemporalType.DATE);
            q = tquery.getResultList();
            if (!this.checkEntityPK(q, cEmp)) {
                this.logErr("Did not get expected results. Expected " + cEmp.size() + " references, got: " + q.size());
            } else {
                this.logTrace("Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("setParameterParameterDateTemporalTypeTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameter8Test() throws Exception {
        List q;
        boolean pass1 = false;
        boolean pass2 = false;
        ArrayList<Employee> cEmp = new ArrayList<Employee>();
        cEmp.add(this.empRef[5]);
        cEmp.add(this.empRef[14]);
        try {
            this.logMsg("Testing Query version");
            this.getEntityTransaction().begin();
            q = this.getEntityManager().createQuery("select e from Employee e where e.hireDate = ?1").setParameter(1, this.getUtilDate("2005-02-18"), TemporalType.DATE).getResultList();
            if (!this.checkEntityPK(q, cEmp)) {
                this.logErr("Did not get expected results. Expected " + cEmp.size() + " references, got: " + q.size());
            } else {
                this.logTrace("Expected results received");
                pass1 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in while rolling back TX:", re);
            }
        }
        this.logMsg("Testing TypedQuery version");
        try {
            this.getEntityTransaction().begin();
            q = this.getEntityManager().createQuery("select e from Employee e where e.hireDate = ?1", Employee.class).setParameter(1, this.getUtilDate("2005-02-18"), TemporalType.DATE).getResultList();
            if (!this.checkEntityPK(q, cEmp)) {
                this.logErr("Did not get expected results. Expected " + cEmp.size() + " references, got: " + q.size());
            } else {
                this.logTrace("Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in while rolling back TX:", re);
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("setParameter8Test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSingleResultNoResultExceptionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.getEntityTransaction().begin();
            this.logMsg("Testing Query version");
            this.getEntityManager().createQuery("select d.name from Department d where d.id = 99").getSingleResult();
            this.logErr("NoResultException was not thrown");
            this.getEntityTransaction().commit();
        }
        catch (NoResultException nre) {
            this.logTrace("Exception Caught as Expected:" + nre);
            pass1 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in while rolling back TX:", re);
            }
        }
        this.logMsg("Testing TypedQuery version");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createQuery("select d.name from Department d where d.id = 99", String.class).getSingleResult();
            this.logErr("NoResultException was not thrown");
            this.getEntityTransaction().commit();
        }
        catch (NoResultException nre) {
            this.logTrace("Exception Caught as Expected:" + nre);
            pass2 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in while rolling back TX:", re);
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("getSingleResultNoResultExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSingleResultTransactionRequiredException() throws Exception {
        Query q;
        boolean pass1 = false;
        boolean pass2 = false;
        this.logMsg("Testing Query version");
        try {
            q = this.getEntityManager().createQuery("select d from  Department d where d.id = 1");
            q.setLockMode(LockModeType.WRITE);
            q.getSingleResult();
            this.logErr("TransactionRequiredException was not thrown");
        }
        catch (TransactionRequiredException ise) {
            this.logTrace("Exception Caught as Expected");
            pass1 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in while rolling back TX:", re);
            }
        }
        this.logMsg("Testing TypedQuery version");
        try {
            q = this.getEntityManager().createQuery("select d from  Department d where d.id = 1", Department.class);
            q.setLockMode(LockModeType.WRITE);
            q.getSingleResult();
            this.logErr("TransactionRequiredException was not thrown");
        }
        catch (TransactionRequiredException ise) {
            this.logTrace("Exception Caught as Expected");
            pass2 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in while rolling back TX:", re);
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("getSingleResultTransactionRequiredException failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSingleResultNonUniqueResultExceptionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.logMsg("Testing Query version");
            this.getEntityTransaction().begin();
            this.getEntityManager().createQuery("select d.name from Department d where d.id > 1").getSingleResult();
            this.logErr("NoResultException was not thrown");
            this.getEntityTransaction().commit();
        }
        catch (NonUniqueResultException nure) {
            this.logTrace("Exception Caught as Expected:" + nure);
            pass1 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in while rolling back TX:", re);
            }
        }
        this.logMsg("Testing TypedQuery version");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createQuery("select d.name from Department d where d.id > 1", String.class).getSingleResult();
            this.logErr("NoResultException was not thrown");
            this.getEntityTransaction().commit();
        }
        catch (NonUniqueResultException nure) {
            this.logTrace("Exception Caught as Expected:" + nure);
            pass2 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in while rolling back TX:", re);
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("getSingleResultNonUniqueResultExceptionTest failed");
        }
    }

    public void isBoundTest() throws Exception {
        Parameter p;
        Query query;
        boolean pass1 = false;
        boolean pass2 = false;
        String expectedName = "fName";
        String expectedValue = "Stephen";
        try {
            this.logTrace("Creating query for isBoundTest");
            this.logMsg("Testing Query version");
            query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName").setParameter(expectedName, (Object)expectedValue);
            p = query.getParameter(expectedName);
            if (p != null) {
                if (!query.isBound(p)) {
                    this.logErr("isbound returned false even though a value is bound to the parameter " + expectedName + "[" + p.getName() + "]");
                } else {
                    pass1 = true;
                }
            } else {
                this.logErr("getParameter returned null");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        this.logMsg("Testing TypedQuery version");
        try {
            query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = :fName", Employee.class).setParameter(expectedName, (Object)expectedValue);
            p = query.getParameter(expectedName);
            if (p != null) {
                if (!query.isBound(p)) {
                    this.logErr("isbound returned false even though a value is bound to the parameter " + expectedName + "[" + p.getName() + "]");
                } else {
                    pass2 = true;
                }
            } else {
                this.logErr("getParameter returned null");
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("isBoundTest failed");
        }
    }

    public void setFirstResult() throws Exception {
        List actual;
        boolean pass1 = false;
        boolean pass2 = false;
        ArrayList<Integer> expected = new ArrayList<Integer>();
        expected.add(2);
        expected.add(3);
        expected.add(3);
        expected.add(4);
        expected.add(4);
        expected.add(5);
        this.logMsg("Testing query");
        try {
            this.getEntityTransaction().begin();
            Query q = this.getEntityManager().createQuery("select e.department.id from Employee e where e.id < 10 order by e.department.id").setFirstResult(3);
            actual = q.getResultList();
            if (!this.checkEntityPK(actual, expected, true)) {
                this.logErr("Did not get expected results. Expected " + expected.size() + " references, got: " + actual.size());
            } else {
                this.logTrace("Expected results received");
                pass1 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        try {
            this.getEntityTransaction().begin();
            this.logMsg("Testing TypedQuery");
            TypedQuery tq = this.getEntityManager().createQuery("select e.department.id from Employee e where e.id < 10 order by e.department.id", Integer.class).setFirstResult(3);
            actual = tq.getResultList();
            if (!this.checkEntityPK(actual, expected, true)) {
                this.logErr("Did not get expected results. Expected " + expected.size() + " references, got: " + actual.size());
            } else {
                this.logTrace("Expected results received");
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("setFirstResult failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryAPITest11() throws Exception {
        boolean pass = false;
        try {
            this.logMsg("Testing Query version");
            this.getEntityTransaction().begin();
            Query query = null;
            try {
                query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = ?1 and e.lastName = ?3").setParameter(1, (Object)"Kellie").setParameter(2, (Object)"Lee");
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("IllegalArgumentException Caught as Expected");
                pass = true;
            }
            catch (Exception e) {
                this.logErr("Received unexpected exeception", e);
            }
            if (!pass) {
                try {
                    query.getResultList();
                }
                catch (RuntimeException e) {
                    this.logMsg("Did not get expected IllegalArgumentException when setting an invalid parameter on a query, but got expected RuntimeException when executing the query: " + e);
                    pass = true;
                }
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in while rolling back TX:", re);
            }
        }
        if (!pass) {
            throw new Exception("queryAPITest11 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryAPITest12() throws Exception {
        boolean pass = false;
        this.logTrace("invoke query for queryAPITest12 ...");
        this.logMsg("Testing Query version");
        try {
            this.getEntityTransaction().begin();
            Query query = null;
            try {
                query = this.getEntityManager().createQuery("select e from Employee e where e.firstName = ?1 and e.lastName = ?2").setParameter(1, (Object)"Kate").setParameter(2, (Object)10);
            }
            catch (IllegalArgumentException iae) {
                this.logTrace("IllegalArgumentException Caught as Expected");
                pass = true;
            }
            catch (Exception e) {
                this.logErr("Received unexpected exeception", e);
            }
            if (!pass) {
                try {
                    query.getResultList();
                }
                catch (RuntimeException e) {
                    this.logMsg("Did not get expected IllegalArgumentException when setting an invalid parameter on a query, but got expected RuntimeException when executing the query: " + e);
                    pass = true;
                }
            }
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in while rolling back TX:", re);
            }
        }
        if (!pass) {
            throw new Exception("queryAPITest12 failed");
        }
    }

    public void setFirstResultIllegalArgumentException() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        this.getEntityTransaction().begin();
        this.logMsg("Testing query version");
        try {
            this.getEntityManager().createQuery("select d from Department d").setFirstResult(-3);
            this.logErr("IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException iae) {
            this.logTrace("IllegalArgumentException Caught as Expected");
            pass1 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        this.logMsg("Testing TypedQuery version");
        try {
            this.getEntityManager().createQuery("select d from Department d", Department.class).setFirstResult(-3);
            this.logErr("IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException iae) {
            this.logTrace("IllegalArgumentException Caught as Expected");
            pass2 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        this.getEntityTransaction().rollback();
        if (!pass1 || !pass2) {
            throw new Exception("setFirstResultIllegalArgumentException failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGetMaxResultsTest() throws Exception {
        List q;
        int gmr;
        Query query;
        boolean pass1 = false;
        boolean pass2 = false;
        Integer[] expected = new Integer[]{1, 2, 3, 4, 5};
        try {
            this.logMsg("Testing Query version");
            this.getEntityTransaction().begin();
            query = this.getEntityManager().createQuery("select d from Department d order by d.id");
            gmr = query.getMaxResults();
            if (gmr != Integer.MAX_VALUE) {
                this.logErr("getMaxResults() called when setMaxResults() not called - Expected:2147483647, actual:" + gmr);
                pass1 = false;
            } else {
                query.setMaxResults(15);
                gmr = query.getMaxResults();
                if (gmr != 15) {
                    this.logErr("getMaxResults() - Expected: 15, Actual:" + gmr);
                    pass1 = false;
                } else {
                    q = query.getResultList();
                    if (!this.checkEntityPK(q, expected)) {
                        this.logErr("Did not get expected results. Expected " + expected.length + " references, got: " + q.size());
                    } else {
                        this.logTrace("Expected results received");
                        pass1 = true;
                    }
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass1 = false;
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in while rolling back TX:", re);
            }
        }
        this.logMsg("Testing TypedQuery version");
        try {
            this.getEntityTransaction().begin();
            query = this.getEntityManager().createQuery("select d from Department d order by d.id", Department.class);
            gmr = query.getMaxResults();
            if (gmr != Integer.MAX_VALUE) {
                this.logErr("getMaxResults() called when setMaxResults() not called - Expected:2147483647, actual:" + gmr);
                pass2 = false;
            } else {
                query.setMaxResults(15);
                gmr = query.getMaxResults();
                if (gmr != 15) {
                    this.logErr("getMaxResults() - Expected: 15, Actual:" + gmr);
                    pass2 = false;
                } else {
                    q = query.getResultList();
                    if (!this.checkEntityPK(q, expected)) {
                        this.logErr("Did not get expected results. Expected " + expected.length + " references, got: " + q.size());
                    } else {
                        this.logTrace("Expected results received");
                        pass2 = true;
                    }
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            pass2 = false;
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in while rolling back TX:", re);
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("setGetMaxResultsTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxResultsIllegalArgumentExceptionTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.logMsg("Testing Query version");
            this.getEntityTransaction().begin();
            this.getEntityManager().createQuery("select d from Department d order by d.id").setMaxResults(-15);
            this.logErr("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException iae) {
            this.logTrace("Received expected IllegalArgumentException");
            pass1 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in while rolling back TX:", re);
            }
        }
        this.logMsg("Testing TypedQuery version");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createQuery("select d from Department d order by d.id", Department.class).setMaxResults(-15);
            this.logErr("IllegalArgumentException not thrown");
        }
        catch (IllegalArgumentException iae) {
            this.logTrace("Received expected IllegalArgumentException");
            pass2 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in while rolling back TX:", re);
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("setMaxResultsIllegalArgumentExceptionTest failed");
        }
    }

    public void getResultListTransactionRequiredExceptionTest() throws Exception {
        Query query;
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.logMsg("Testing Query version");
            query = this.getEntityManager().createQuery("select d from Department d ");
            query.setLockMode(LockModeType.READ);
            query.getResultList();
            this.logErr("TransactionRequiredException not thrown");
        }
        catch (TransactionRequiredException tre) {
            this.logTrace("Received expected TransactionRequiredException ");
            pass1 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        this.logMsg("Testing TypedQuery version");
        try {
            query = this.getEntityManager().createQuery("select d from Department d ", Department.class);
            query.setLockMode(LockModeType.READ);
            query.getResultList();
        }
        catch (TransactionRequiredException tre) {
            this.logTrace("Received expected TransactionRequiredException ");
            pass2 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass1 || !pass2) {
            throw new Exception("getResultListTransactionRequiredExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxResults() throws Exception {
        boolean pass = false;
        boolean found = false;
        Integer[] expected = new Integer[]{4, 1};
        try {
            this.logTrace("Invoking query");
            this.getEntityTransaction().begin();
            List q = this.getEntityManager().createQuery("select d from Department d order by d.name").setMaxResults(2).getResultList();
            if (!this.checkEntityPK(q, expected)) {
                this.logErr("Did not get expected results. Expected " + expected.length + " references, got: " + q.size());
            } else {
                this.logTrace("Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in while rolling back TX:", re);
            }
        }
        if (!pass) {
            throw new Exception("setMaxResults failed");
        }
    }

    public void queryAPITest16() throws Exception {
        boolean pass1 = false;
        try {
            this.logMsg("Testing Query version");
            this.getEntityTransaction().begin();
            Query q = this.getEntityManager().createQuery("UPDATE Employee e SET e.salary = e.salary * 10.0 where e.salary > :minsal").setParameter("minsal", (Object)Float.valueOf(50000.0f));
            q.getResultList();
            this.getEntityTransaction().commit();
            this.logErr("IllegalStateException not thrown");
        }
        catch (IllegalStateException ise) {
            this.logTrace("IllegalStateException Caught as Expected");
            pass1 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in while rolling back TX:", re);
            }
        }
        if (!pass1) {
            throw new Exception("queryAPITest16 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryAPITest17() throws Exception {
        boolean pass = false;
        try {
            this.logTrace("Invoking query");
            this.getEntityTransaction().begin();
            Query q = this.getEntityManager().createQuery("DELETE FROM Employee e where e.salary > :minsal").setParameter("minsal", (Object)Float.valueOf(50000.0f));
            q.getResultList();
            this.getEntityTransaction().commit();
        }
        catch (IllegalStateException ise) {
            this.logTrace("IllegalStateException Caught as Expected");
            pass = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in while rolling back TX:", re);
            }
        }
        if (!pass) {
            throw new Exception("queryAPITest17 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getSingleResultTest() throws Exception {
        Query q;
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            this.logMsg("Testing Query version");
            this.getEntityTransaction().begin();
            q = this.getEntityManager().createQuery("select e from Employee e where e.id = 1");
            Object o = q.getSingleResult();
            if (o instanceof Employee) {
                Employee e = (Employee)o;
                if (e.getId() != 1) {
                    this.logErr("Expected employee with id:1, actual:" + e.getId());
                } else {
                    pass1 = true;
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in while rolling back TX:", re);
            }
        }
        this.logMsg("Testing TypedQuery version");
        try {
            this.getEntityTransaction().begin();
            q = this.getEntityManager().createQuery("select e from Employee e where e.id = 1", Employee.class);
            Employee e = (Employee)q.getSingleResult();
            if (e.getId() != 1) {
                this.logErr("Expected employee with id:1, actual:" + e.getId());
            } else {
                pass2 = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in while rolling back TX:", re);
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("getSingleResultTest failed");
        }
    }

    public void getSingleResultIllegalStateException() throws Exception {
        Query q;
        boolean pass1 = false;
        boolean pass2 = false;
        this.getEntityTransaction().begin();
        this.logMsg("Testing delete query");
        try {
            q = this.getEntityManager().createQuery("DELETE FROM Employee e where e.salary > 50000.0");
            q.getSingleResult();
            this.logErr("IllegalStateException was not thrown");
        }
        catch (IllegalStateException ise) {
            this.logTrace("IllegalStateException Caught as Expected");
            pass1 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        this.logMsg("Testing update query");
        try {
            q = this.getEntityManager().createQuery("Update Employee e SET e.salary = e.salary * 10.0");
            q.getSingleResult();
            this.logErr("IllegalStateException was not thrown");
        }
        catch (IllegalStateException ise) {
            this.logTrace("IllegalStateException Caught as Expected");
            pass2 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        try {
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception re) {
            this.logErr("Unexpected Exception in while rolling back TX:", re);
        }
        if (!pass1 || !pass2) {
            throw new Exception("getSingleResultIllegalStateException failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeUpdateIllegalStateException() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        this.logMsg("Testing Query version");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createQuery("select d.id from Department d").executeUpdate();
            this.logErr("IllegalStateException was not thrown");
            this.getEntityTransaction().commit();
        }
        catch (IllegalStateException ise) {
            this.logTrace("IllegalStateException Caught as Expected");
            pass1 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in while rolling back TX:", re);
            }
        }
        this.logMsg("Testing TypedQuery version");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createQuery("select d.id from Department d", Integer.class).executeUpdate();
            this.logErr("IllegalStateException was not thrown");
            this.getEntityTransaction().commit();
        }
        catch (IllegalStateException ise) {
            this.logTrace("IllegalStateException Caught as Expected");
            pass2 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in while rolling back TX:", re);
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("executeUpdateIllegalStateException failed");
        }
    }

    public void executeUpdateTransactionRequiredExceptionTest() throws Exception {
        boolean pass1 = false;
        this.logMsg("Testing Query version");
        try {
            this.getEntityManager().createQuery("update Department d  set d.name = NULLIF(d.name, 'Engineering')").executeUpdate();
            this.logErr("TransactionRequiredException was not thrown");
        }
        catch (TransactionRequiredException ise) {
            this.logTrace("TransactionRequiredException Caught as Expected");
            pass1 = true;
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in while rolling back TX:", re);
            }
        }
        if (!pass1) {
            throw new Exception("executeUpdateTransactionRequiredExceptionTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryAPITest21() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("Starting queryAPITest21");
            Department dept1 = (Department)this.getEntityManager().find(Department.class, (Object)1);
            dept1.setName("Research and Development");
            this.getEntityManager().createQuery("SELECT d FROM Department d WHERE d.name = 'Research and Development'").setFlushMode(FlushModeType.AUTO).getResultList();
            Department newDepartment = (Department)this.getEntityManager().find(Department.class, (Object)1);
            if (newDepartment.getName().equals("Research and Development")) {
                this.logTrace("Expected results received");
                pass = true;
            } else {
                this.logErr("Expected result:Research and Development, actual:" + newDepartment.getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Caught exception:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in while rolling back TX:", re);
            }
        }
        if (!pass) {
            throw new Exception("queryAPITest21 failed");
        }
    }

    public void queryAPITest22() throws Exception {
        int result_size = 0;
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("Setting department name to IT for id 1");
            Query q = this.getEntityManager().createQuery("update Department d set d.name='IT' where d.id=1");
            result_size = q.executeUpdate();
            if (result_size == 1) {
                this.logTrace("Updated 1 rows");
            }
            this.doFlush();
            this.clearCache();
            Department dept = (Department)this.getEntityManager().find(Department.class, (Object)1);
            if (dept != null) {
                if (dept.getId() == 1) {
                    if (dept.getName().equals("IT")) {
                        this.logTrace("Received expected name:" + dept.getName());
                        pass = true;
                    } else {
                        this.logErr("Received unexpected d.name =" + dept.getName());
                    }
                } else {
                    this.logErr("Received incorrect Department, expected id=1 and name=IT, actual id=" + dept.getId() + " and name=" + dept.getName());
                }
            } else {
                this.logErr("department returned was null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Exception("queryAPITest22 failed");
        }
    }

    public void queryAPITest23() throws Exception {
        int result_size = 0;
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("Deleting Employee where id 1");
            Query q = this.getEntityManager().createQuery("delete from Employee e where e.id=1");
            result_size = q.executeUpdate();
            if (result_size == 1) {
                this.logTrace("Updated 1 rows");
            }
            this.doFlush();
            this.clearCache();
            Employee emp = (Employee)this.getEntityManager().find(Employee.class, (Object)1);
            if (emp == null) {
                this.logTrace("Employee returned expected null");
                pass = true;
            } else {
                this.logErr("Expected null Employee, instead got:" + emp.toString());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Exception("queryAPITest23 failed");
        }
    }

    public void queryAPITest24() throws Exception {
        int result_size = 0;
        boolean pass = true;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("Setting department name to IT for ids < 5");
            Query q = this.getEntityManager().createQuery("update Department d set d.name='IT' where d.id<5");
            result_size = q.executeUpdate();
            if (result_size == 4) {
                this.logTrace("Updated 4 rows");
            }
            this.doFlush();
            this.clearCache();
            this.logMsg("Testing ids 1 to 4");
            for (int i = 1; i < 5; ++i) {
                Department dept = (Department)this.getEntityManager().find(Department.class, (Object)i);
                if (dept != null) {
                    if (dept.getId() == i) {
                        if (dept.getName().equals("IT")) {
                            this.logTrace("Received expected name:" + dept.getName());
                            continue;
                        }
                        this.logErr("Received unexpected d.name =" + dept.getName());
                        pass = false;
                        continue;
                    }
                    this.logErr("Received incorrect Department, expected id=1 and name=IT, actual id=" + dept.getId() + " and name=" + dept.getName());
                    continue;
                }
                this.logErr("department returned was null");
            }
            this.logMsg("Testing id 5");
            Department dept = (Department)this.getEntityManager().find(Department.class, (Object)5);
            if (dept != null) {
                if (dept.getId() == 5) {
                    if (dept.getName().equals(this.deptRef[4].getName())) {
                        this.logTrace("Received expected name:" + dept.getName());
                    } else {
                        this.logErr("Received unexpected name =" + dept.getName());
                        pass = false;
                    }
                } else {
                    this.logErr("Received incorrect Department, expected id=1 and name=IT, actual id=" + dept.getId() + " and name=" + dept.getName());
                }
            } else {
                this.logErr("department returned was null");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Exception("queryAPITest24 failed");
        }
    }

    public void queryAPITest25() throws Exception {
        int result_size = 0;
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.logTrace("Deleting Employee where id < 21");
            Query q = this.getEntityManager().createQuery("delete from Employee e where e.id<21");
            result_size = q.executeUpdate();
            if (result_size == 20) {
                this.logTrace("Updated 20 rows");
            }
            this.doFlush();
            this.clearCache();
            for (int i = 1; i < 21; ++i) {
                Employee emp = (Employee)this.getEntityManager().find(Employee.class, (Object)i);
                if (emp == null) {
                    this.logTrace("Employee " + i + " returned was null");
                    pass = true;
                    continue;
                }
                this.logErr("Expected null Employee, instead got:" + emp.toString());
            }
            Employee emp = (Employee)this.getEntityManager().find(Employee.class, (Object)21);
            if (emp != null) {
                this.logTrace("Employee 21 returned was expected non-null");
                pass = true;
            } else {
                this.logErr("Expected non-null Employee for id 21");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        if (!pass) {
            throw new Exception("queryAPITest25 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryAPITest27() throws Exception {
        int result_size = 0;
        boolean pass1 = false;
        boolean pass2 = true;
        try {
            this.logTrace("Invoking query");
            this.getEntityTransaction().begin();
            Query q = this.getEntityManager().createQuery("select e.hireDate from Employee e where e.hireDate = {d '2000-02-14'}");
            List result = q.getResultList();
            result_size = result.size();
            this.logTrace("Result Size = " + result_size);
            if (result_size == 2) {
                Date expectedHireDate = Date.valueOf("2000-02-14");
                pass1 = true;
                this.logTrace("Received expected count 2");
                for (Date d : result) {
                    this.logTrace("date=" + d);
                    if (d.equals(expectedHireDate)) {
                        this.logTrace("Received expected HireDate ");
                        continue;
                    }
                    this.logErr("Received unexpected Employee HireDate = " + d.toString());
                    pass2 = false;
                }
            } else {
                this.logTrace("Received unexpected count " + result);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected exception occurred", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in while rolling back TX:", re);
            }
        }
        if (!pass1 || !pass2) {
            throw new Exception("queryAPITest27 failed");
        }
    }

    public void getResultListIllegalStateException() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        this.logMsg("Testing Delete");
        this.getEntityTransaction().begin();
        Query query = this.getEntityManager().createQuery("DELETE FROM Employee e where e.id in (1,2,3)");
        try {
            query.getResultList();
            this.logTrace("Did not throw IllegalStateException");
        }
        catch (IllegalStateException ise) {
            this.logTrace("Received expected IllegalStateException");
            pass1 = true;
        }
        catch (Exception ex) {
            this.logErr("Received unexpected exception", ex);
        }
        this.logMsg("Testing Update");
        Query q = this.getEntityManager().createQuery("Update Employee e SET e.salary=0 where e.id in (1,2,3)");
        try {
            q.getResultList();
            this.logTrace("Did not throw IllegalStateException");
        }
        catch (IllegalStateException ise) {
            this.logTrace("Received expected IllegalStateException");
            pass2 = true;
        }
        catch (Exception ex) {
            this.logErr("Received unexpected exception", ex);
        }
        try {
            if (this.getEntityTransaction().isActive()) {
                this.getEntityTransaction().rollback();
            }
        }
        catch (Exception re) {
            this.logErr("Unexpected Exception while rolling back TX:", re);
        }
        if (!pass1 || !pass2) {
            throw new Exception("getResultListIllegalStateException failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void noTransactionLockModeTypeNoneTest() throws Exception {
        Employee e;
        Query q;
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        this.logMsg("Query getSingleResult test");
        try {
            q = this.getEntityManager().createQuery("select e from Employee e where e.id = 1");
            q.setLockMode(LockModeType.NONE);
            Object o = q.getSingleResult();
            if (o instanceof Employee) {
                e = (Employee)o;
                if (e.getId() == 1) {
                    pass1 = true;
                    this.logTrace("Received expected employee id:" + e.getId());
                } else {
                    this.logErr("Expected employee with id:1, actual:" + e.getId());
                }
            } else {
                this.logErr("Received non Employee object:" + o);
            }
        }
        catch (Exception e2) {
            this.logErr("Unexpected exception occurred", e2);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in while rolling back TX:", re);
            }
        }
        this.logMsg("TypedQuery getSingleResult test");
        try {
            q = this.getEntityManager().createQuery("select e from Employee e where e.id = 1", Employee.class);
            q.setLockMode(LockModeType.NONE);
            Employee e3 = (Employee)q.getSingleResult();
            if (e3.getId() == 1) {
                pass2 = true;
                this.logTrace("Received expected employee id:" + e3.getId());
            } else {
                this.logErr("Expected employee with id:1, actual:" + e3.getId());
            }
        }
        catch (Exception e4) {
            this.logErr("Unexpected exception occurred", e4);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in while rolling back TX:", re);
            }
        }
        this.logMsg("Query getResultList test");
        try {
            q = this.getEntityManager().createQuery("select e from Employee e where e.id = 1");
            q.setLockMode(LockModeType.NONE);
            List c = q.getResultList();
            if (c.size() == 1) {
                Object o = c.iterator().next();
                if (o instanceof Employee) {
                    Employee e5 = (Employee)o;
                    if (e5.getId() == 1) {
                        pass3 = true;
                        this.logTrace("Received expected employee id:" + e5.getId());
                    } else {
                        this.logErr("Expected employee with id:1, actual:" + e5.getId());
                    }
                } else {
                    this.logErr("Received non Employee object:" + o);
                }
            } else {
                this.logErr("Got more than one result");
            }
        }
        catch (Exception e6) {
            this.logErr("Unexpected exception occurred", e6);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in while rolling back TX:", re);
            }
        }
        this.logMsg("TypedQuery getResultList test");
        try {
            q = this.getEntityManager().createQuery("select e from Employee e where e.id = 1", Employee.class);
            q.setLockMode(LockModeType.NONE);
            List le = q.getResultList();
            if (le.size() == 1) {
                e = (Employee)le.get(0);
                if (e.getId() == 1) {
                    pass4 = true;
                    this.logTrace("Received expected employee id:" + e.getId());
                } else {
                    this.logErr("Expected employee with id:1, actual:" + e.getId());
                }
            } else {
                this.logErr("Got more than one result");
            }
        }
        catch (Exception e7) {
            this.logErr("Unexpected exception occurred", e7);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in while rolling back TX:", re);
            }
        }
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new Exception("noTransactionLockModeTypeNoneTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTestData() throws Exception {
        this.logTrace("createTestData");
        Insurance[] insRef = new Insurance[5];
        Date d2 = this.getSQLDate("2001-06-27");
        Date d3 = this.getSQLDate("2002-07-07");
        Date d4 = this.getSQLDate("2003-03-03");
        Date d5 = this.getSQLDate("2004-04-10");
        Date d6 = this.getSQLDate("2005-02-18");
        Date d7 = this.getSQLDate("2000-09-17");
        Date d8 = this.getSQLDate("2001-11-14");
        Date d9 = this.getSQLDate("2002-10-04");
        Date d10 = this.getSQLDate("2003-01-25");
        Date d11 = this.getSQLDate();
        try {
            this.getEntityTransaction().begin();
            this.deptRef[0] = new Department(1, "Engineering");
            this.deptRef[1] = new Department(2, "Marketing");
            this.deptRef[2] = new Department(3, "Sales");
            this.deptRef[3] = new Department(4, "Accounting");
            this.deptRef[4] = new Department(5, "Training");
            this.logTrace("Start to persist departments ");
            for (Department department : this.deptRef) {
                if (department == null) continue;
                this.getEntityManager().persist((Object)department);
                this.logTrace("persisted department " + department);
            }
            insRef[0] = new Insurance(1, "Prudential");
            insRef[1] = new Insurance(2, "Cigna");
            insRef[2] = new Insurance(3, "Sentry");
            this.logTrace("Start to persist insurance ");
            for (Serializable serializable : insRef) {
                if (serializable == null) continue;
                this.getEntityManager().persist((Object)serializable);
                this.logTrace("persisted insurance " + (Insurance)serializable);
            }
            this.empRef[0] = new Employee(1, "Alan", "Frechette", this.d1, 35000.0f);
            this.empRef[0].setDepartment(this.deptRef[0]);
            this.empRef[0].setInsurance(insRef[0]);
            this.empRef[1] = new Employee(2, "Arthur", "Frechette", d2, 35000.0f);
            this.empRef[1].setDepartment(this.deptRef[1]);
            this.empRef[1].setInsurance(insRef[1]);
            this.empRef[2] = new Employee(3, "Shelly", "McGowan", d3, 50000.0f);
            this.empRef[2].setDepartment(this.deptRef[2]);
            this.empRef[2].setInsurance(insRef[2]);
            this.empRef[3] = new Employee(4, "Robert", "Bissett", d4, 55000.0f);
            this.empRef[3].setDepartment(this.deptRef[3]);
            this.empRef[3].setInsurance(insRef[0]);
            this.empRef[4] = new Employee(5, "Stephen", "DMilla", d5, 25000.0f);
            this.empRef[4].setDepartment(this.deptRef[4]);
            this.empRef[4].setInsurance(insRef[1]);
            this.empRef[5] = new Employee(6, "Karen", "Tegan", d6, 80000.0f);
            this.empRef[5].setDepartment(this.deptRef[0]);
            this.empRef[5].setInsurance(insRef[2]);
            this.empRef[6] = new Employee(7, "Stephen", "Cruise", d7, 90000.0f);
            this.empRef[6].setDepartment(this.deptRef[1]);
            this.empRef[6].setInsurance(insRef[0]);
            this.empRef[7] = new Employee(8, "Irene", "Caruso", d8, 20000.0f);
            this.empRef[7].setDepartment(this.deptRef[2]);
            this.empRef[7].setInsurance(insRef[1]);
            this.empRef[8] = new Employee(9, "William", "Keaton", d9, 35000.0f);
            this.empRef[8].setDepartment(this.deptRef[3]);
            this.empRef[8].setInsurance(insRef[2]);
            this.empRef[9] = new Employee(10, "Kate", "Hudson", d10, 20000.0f);
            this.empRef[9].setDepartment(this.deptRef[4]);
            this.empRef[9].setInsurance(insRef[0]);
            this.empRef[10] = new Employee(11, "Jonathan", "Smith", d10, 40000.0f);
            this.empRef[10].setDepartment(this.deptRef[0]);
            this.empRef[10].setInsurance(insRef[1]);
            this.empRef[11] = new Employee(12, "Mary", "Macy", d9, 40000.0f);
            this.empRef[11].setDepartment(this.deptRef[1]);
            this.empRef[11].setInsurance(insRef[2]);
            this.empRef[12] = new Employee(13, "Cheng", "Fang", d8, 40000.0f);
            this.empRef[12].setDepartment(this.deptRef[2]);
            this.empRef[12].setInsurance(insRef[0]);
            this.empRef[13] = new Employee(14, "Julie", "OClaire", d7, 60000.0f);
            this.empRef[13].setDepartment(this.deptRef[3]);
            this.empRef[13].setInsurance(insRef[1]);
            this.empRef[14] = new Employee(15, "Steven", "Rich", d6, 60000.0f);
            this.empRef[14].setDepartment(this.deptRef[4]);
            this.empRef[14].setInsurance(insRef[2]);
            this.empRef[15] = new Employee(16, "Kellie", "Lee", d5, 60000.0f);
            this.empRef[15].setDepartment(this.deptRef[0]);
            this.empRef[15].setInsurance(insRef[0]);
            this.empRef[16] = new Employee(17, "Nicole", "Martin", d4, 60000.0f);
            this.empRef[16].setDepartment(this.deptRef[1]);
            this.empRef[16].setInsurance(insRef[1]);
            this.empRef[17] = new Employee(18, "Mark", "Francis", d3, 60000.0f);
            this.empRef[17].setDepartment(this.deptRef[2]);
            this.empRef[17].setInsurance(insRef[2]);
            this.empRef[18] = new Employee(19, "Will", "Forrest", d2, 60000.0f);
            this.empRef[18].setDepartment(this.deptRef[3]);
            this.empRef[18].setInsurance(insRef[0]);
            this.empRef[19] = new Employee(20, "Katy", "Hughes", this.d1, 60000.0f);
            this.empRef[19].setDepartment(this.deptRef[4]);
            this.empRef[19].setInsurance(insRef[1]);
            this.empRef[20] = new Employee(21, "Jane", "Smmith", d11, 60000.0f);
            this.empRef[20].setDepartment(this.deptRef[0]);
            this.empRef[20].setInsurance(insRef[2]);
            for (Serializable serializable : this.empRef) {
                if (serializable == null) continue;
                this.getEntityManager().persist((Object)serializable);
                this.logTrace("persisted employee " + (Employee)serializable);
            }
            this.getEntityTransaction().commit();
            this.logTrace("Created TestData");
        }
        catch (Exception re) {
            this.logErr("Unexpected Exception in createTestData:", re);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in createTestData while rolling back TX:", re);
            }
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM EMPLOYEE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DEPARTMENT").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM INSURANCE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DATATYPES2").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

