/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.spec.requestdispatcher;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import servlet.tck.common.servlets.GenericTCKServlet;

public class ForwardedServlet
extends GenericTCKServlet {
    private static final String TEST_HEADER = "testname";
    private static final Class[] TEST_ARGS = new Class[]{ServletRequest.class, ServletResponse.class};
    private static final String TEST1_HEADER = "TestName";

    @Override
    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        String test = req.getParameter(TEST_HEADER);
        try {
            Method method = ((Object)((Object)this)).getClass().getMethod(test, TEST_ARGS);
            method.invoke((Object)this, req, res);
        }
        catch (InvocationTargetException ite) {
            throw new ServletException(ite.getTargetException());
        }
        catch (NoSuchMethodException nsme) {
            if (req.getAttribute(TEST1_HEADER) != null) {
                String tmp = (String)req.getAttribute(TEST1_HEADER);
                if (tmp.indexOf("attributes") < 0) {
                    throw new ServletException("Test: " + test + " does not exist");
                }
                this.attributes(req, res);
            }
            throw new ServletException("Test: " + test + " does not exist");
        }
        catch (Throwable t) {
            throw new ServletException("Error executing test: " + test, t);
        }
    }

    public void thrownIOException(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        throw new IOException("IOException_from_checkedException");
    }

    public void thrownServletException(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        throw new ServletException("ServletException from thrownServletException");
    }

    public void thrownUnCheckedException(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        throw new RuntimeException("RuntimeException_from_unCheckedException");
    }

    public void thrownCheckedException(ServletRequest request, ServletResponse response) throws ServletException, IOException, ClassNotFoundException {
        throw new ClassNotFoundException("ClassNotFoundException from throwCheckedException");
    }

    public void bufferContent(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        pw.println("bufferContent_in_ForwardedServlet_invoked");
    }

    public void attributes(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        int i;
        PrintWriter pw = response.getWriter();
        String[] aname = new String[]{"jakarta.servlet.forward.request_uri", "jakarta.servlet.forward.context_path", "jakarta.servlet.forward.servlet_path", "jakarta.servlet.forward.path_info", "jakarta.servlet.forward.query_string"};
        String[] avalue = new String[]{"/servlet_spec_requestdispatcher_web/TestServlet", "/servlet_spec_requestdispatcher_web", "/TestServlet", "*", "testname=" + request.getParameter("query")};
        String[] types = new String[]{"=SET_GOOD;", "=SET_WRONGVALUE;", "=SET_BADTYPE;", "=SET_NO;"};
        String[] results = new String[5];
        for (i = 0; i < aname.length; ++i) {
            Object o = request.getAttribute(aname[i]);
            if (o != null) {
                if (o instanceof String) {
                    String attr = (String)o;
                    if (!attr.equals(avalue[i])) {
                        results[i] = types[1];
                        pw.println("attribute " + aname[i] + " set with incorrect value=" + attr + ", expecting " + avalue[i]);
                        continue;
                    }
                    results[i] = types[0];
                    pw.println("attribute " + aname[i] + " set with correct value=" + attr);
                    continue;
                }
                results[i] = types[2];
                pw.println("attribute " + aname[i] + " set to non-String type");
                continue;
            }
            results[i] = types[3];
            pw.println("attribute " + aname[i] + " not set");
        }
        for (i = 0; i < 5; ++i) {
            pw.print(aname[i] + results[i]);
        }
        pw.println("");
    }
}

