/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.tck.tests.jslxml;

import com.ibm.jbatch.tck.utils.AssertionUtils;
import com.ibm.jbatch.tck.utils.BaseJUnit5Test;
import com.ibm.jbatch.tck.utils.JobOperatorBridge;
import com.ibm.jbatch.tck.utils.TCKJobExecutionWrapper;
import ee.jakarta.tck.batch.util.Reporter;
import jakarta.batch.runtime.BatchStatus;
import jakarta.batch.runtime.StepExecution;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ContextAndListenerTests
extends BaseJUnit5Test {
    private static final Logger logger = Logger.getLogger(ContextAndListenerTests.class.getName());
    private static JobOperatorBridge jobOp = null;

    @BeforeEach
    public void setUp() throws Exception {
        jobOp = new JobOperatorBridge();
    }

    @Test
    public void testExamineJobContextInArtifact() throws Exception {
        String METHOD = "testExamineJobContextInArtifact()";
        try {
            Reporter.log((String)"Locate job XML file: JobContextTestBatchlet.xml<p>");
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"app.timeinterval=10<p>");
            jobParams.put("app.timeinterval", "10");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("JobContextTestBatchlet", jobParams);
            String testString = "JobName=job1;JobInstanceId=" + jobOp.getJobInstance(execution1.getExecutionId()).getInstanceId() + ";JobExecutionId=" + execution1.getExecutionId();
            Reporter.log((String)"EXPECTED JobExecution getBatchStatus()=COMPLETED<p>");
            Reporter.log((String)("ACTUAL JobExecution getBatchStatus()=" + execution1.getBatchStatus() + "<p>"));
            Reporter.log((String)("EXPECTED JobExecution getExitStatus()=" + testString + "<p>"));
            Reporter.log((String)("ACTUAL JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing batch status", BatchStatus.COMPLETED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing exit status", testString, execution1.getExitStatus());
        }
        catch (Exception e) {
            ContextAndListenerTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testExamineStepContextInArtifact() throws Exception {
        String METHOD = "testExamineStepContextInArtifact()";
        try {
            Reporter.log((String)"Locate job XML file: StepContextTestBatchlet.xml<p>");
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"app.timeinterval=10<p>");
            jobParams.put("app.timeinterval", "10");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("StepContextTestBatchlet", jobParams);
            List<StepExecution> steps = jobOp.getStepExecutions(execution1.getExecutionId());
            AssertionUtils.assertWithMessage("list of step executions == 1", steps.size() == 1);
            String testString = "StepName=step1;StepExecutionId=" + steps.get(0).getStepExecutionId();
            Reporter.log((String)"EXPECTED JobExecution getBatchStatus()=COMPLETED<p>");
            Reporter.log((String)("ACTUAL JobExecution getBatchStatus()=" + execution1.getBatchStatus() + "<p>"));
            Reporter.log((String)("EXPECTED JobExecution getExitStatus()=" + testString + "<p>"));
            Reporter.log((String)("ACTUAL JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing batch status", BatchStatus.COMPLETED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing exit status", testString, execution1.getExitStatus());
        }
        catch (Exception e) {
            ContextAndListenerTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testOneArtifactIsJobAndStepListener() throws Exception {
        String METHOD = "testOneArtifactIsJobAndStepListener";
        try {
            String expectedStr = "BeforeJobBeforeStepUnusedExitStatusForPartitionsAfterStepBeforeStepUnusedExitStatusForPartitionsAfterStepAfterJob";
            Reporter.log((String)"Locate job XML file: oneArtifactIsJobAndStepListener.xml<p>");
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"app.timeinterval=10<p>");
            jobParams.put("app.timeinterval", "10");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("oneArtifactIsJobAndStepListener", jobParams);
            Reporter.log((String)"EXPECTED JobExecution getBatchStatus()=COMPLETED<p>");
            Reporter.log((String)("ACTUAL JobExecution getBatchStatus()=" + execution1.getBatchStatus() + "<p>"));
            Reporter.log((String)("EXPECTED JobExecution getExitStatus()=" + expectedStr + "<p>"));
            Reporter.log((String)("ACTUAL JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing batch status", BatchStatus.COMPLETED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing exit status", expectedStr, execution1.getExitStatus());
        }
        catch (Exception e) {
            ContextAndListenerTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testgetException() throws Exception {
        String METHOD = "testgetException";
        try {
            String expectedStr = "MyChunkListener: found instanceof MyParentException";
            Reporter.log((String)"Locate job XML file: job_chunk_getException.xml<p>");
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"fail.immediate=true<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("job_chunk_getException", jobParams);
            Reporter.log((String)"EXPECTED JobExecution getBatchStatus()=FAILED<p>");
            Reporter.log((String)("ACTUAL JobExecution getBatchStatus()=" + execution1.getBatchStatus() + "<p>"));
            Reporter.log((String)("EXPECTED JobExecution getExitStatus()=" + expectedStr + "<p>"));
            Reporter.log((String)("ACTUAL JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing batch status", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing exit status", expectedStr, execution1.getExitStatus());
        }
        catch (Exception e) {
            ContextAndListenerTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testgetExceptionListenerBased() throws Exception {
        String METHOD = "testgetExceptionListenerBased";
        try {
            String expectedStr = "MyChunkListener: found instanceof MyParentException";
            Reporter.log((String)"Locate job XML file: job_chunk_getExceptionListeners.xml<p>");
            Reporter.log((String)"Create job parameters for execution #1:<p>");
            Properties jobParams = new Properties();
            Reporter.log((String)"fail.immediate=true<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult for execution #1<p>");
            TCKJobExecutionWrapper execution1 = jobOp.startJobAndWaitForResult("job_chunk_getExceptionListeners", jobParams);
            Reporter.log((String)"EXPECTED JobExecution getBatchStatus()=FAILED<p>");
            Reporter.log((String)("ACTUAL JobExecution getBatchStatus()=" + execution1.getBatchStatus() + "<p>"));
            Reporter.log((String)("EXPECTED JobExecution getExitStatus()=" + expectedStr + "<p>"));
            Reporter.log((String)("ACTUAL JobExecution getExitStatus()=" + execution1.getExitStatus() + "<p>"));
            AssertionUtils.assertWithMessage("Testing batch status", BatchStatus.FAILED, execution1.getBatchStatus());
            AssertionUtils.assertWithMessage("Testing exit status", expectedStr, execution1.getExitStatus());
        }
        catch (Exception e) {
            ContextAndListenerTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testJobContextIsUniqueForMainThreadAndPartitions() throws Exception {
        String METHOD = "testJobContextIsUniqueForMainThreadAndPartitions";
        this.begin(METHOD);
        try {
            Reporter.log((String)"Locate job XML file: job_partitioned_1step.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExecution = jobOp.startJobAndWaitForResult("job_partitioned_1step");
            Reporter.log((String)("JobExecution getBatchStatus()=" + jobExecution.getBatchStatus() + "<p>"));
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExecution.getBatchStatus());
            AssertionUtils.assertObjEquals("COMPLETED", jobExecution.getExitStatus());
        }
        catch (Exception e) {
            ContextAndListenerTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testJobContextIsUniqueForMainThreadAndFlowsInSplits() throws Exception {
        String METHOD = "testJobContextIsUniqueForMainThreadAndFlowsInSplits";
        this.begin(METHOD);
        try {
            Reporter.log((String)"Locate job XML file: job_split_batchlet_4steps.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper execution = jobOp.startJobAndWaitForResult("job_split_batchlet_4steps");
            Reporter.log((String)("JobExecution getBatchStatus()=" + execution.getBatchStatus() + "<p>"));
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, execution.getBatchStatus());
            AssertionUtils.assertObjEquals("COMPLETED", execution.getExitStatus());
        }
        catch (Exception e) {
            ContextAndListenerTests.handleException(METHOD, e);
        }
    }

    @Test
    public void testStepContextIsUniqueForMainThreadAndPartitions() throws Exception {
        String METHOD = "testStepContextIsUniqueForMainThreadAndPartitions";
        this.begin(METHOD);
        try {
            Reporter.log((String)"Locate job XML file: job_partitioned_1step.xml<p>");
            Reporter.log((String)"Invoke startJobAndWaitForResult<p>");
            TCKJobExecutionWrapper jobExecution = jobOp.startJobAndWaitForResult("job_partitioned_1step");
            Reporter.log((String)("JobExecution getBatchStatus()=" + jobExecution.getBatchStatus() + "<p>"));
            AssertionUtils.assertObjEquals(BatchStatus.COMPLETED, jobExecution.getBatchStatus());
            List<StepExecution> stepExecs = jobOp.getStepExecutions(jobExecution.getExecutionId());
            StepExecution stepExec = stepExecs.get(0);
            AssertionUtils.assertObjEquals("COMPLETED", stepExec.getExitStatus());
        }
        catch (Exception e) {
            ContextAndListenerTests.handleException(METHOD, e);
        }
    }

    private static void handleException(String methodName, Exception e) throws Exception {
        Reporter.log((String)("Caught exception: " + e.getMessage() + "<p>"));
        Reporter.log((String)(methodName + " failed<p>"));
        throw e;
    }

    private void begin(String str) {
        Reporter.log((String)("Begin test method: " + str + "<p>"));
    }
}

