/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.exporter.client;

import java.util.LinkedHashSet;
import org.eclipse.mylyn.docs.intent.collab.common.query.IntentDocumentQuery;
import org.eclipse.mylyn.docs.intent.collab.handlers.RepositoryObjectHandler;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.ReadOnlyException;
import org.eclipse.mylyn.docs.intent.collab.handlers.adapters.RepositoryAdapter;
import org.eclipse.mylyn.docs.intent.collab.handlers.impl.ReadWriteRepositoryObjectHandlerImpl;
import org.eclipse.mylyn.docs.intent.collab.handlers.impl.notification.elementList.ElementListNotificator;
import org.eclipse.mylyn.docs.intent.collab.handlers.notification.Notificator;
import org.eclipse.mylyn.docs.intent.collab.repository.Repository;
import org.eclipse.mylyn.docs.intent.core.document.IntentDocument;
import org.eclipse.mylyn.docs.intent.exporter.client.IntentExporterClient;

public final class IntentExporterClientCreator {
    private IntentExporterClientCreator() {
    }

    public static IntentExporterClient createIntentExporterClient(Repository repository) throws ReadOnlyException {
        RepositoryAdapter repositoryAdapter = repository.createRepositoryAdapter();
        repositoryAdapter.openSaveContext();
        ReadWriteRepositoryObjectHandlerImpl handler = new ReadWriteRepositoryObjectHandlerImpl(repositoryAdapter);
        LinkedHashSet<IntentDocument> intentDocument = new LinkedHashSet<IntentDocument>();
        intentDocument.add(new IntentDocumentQuery(repositoryAdapter).getOrCreateIntentDocument());
        ElementListNotificator listenedElementsNotificator = new ElementListNotificator(intentDocument, repositoryAdapter);
        handler.addNotificator((Notificator)listenedElementsNotificator);
        IntentExporterClient exporter = new IntentExporterClient(repository);
        exporter.addRepositoryObjectHandler((RepositoryObjectHandler)handler);
        return exporter;
    }
}

