/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.docs.intent.client.ui.editor.annotation.image;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationPainter;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.mylyn.docs.intent.client.ui.editor.IntentEditor;
import org.eclipse.mylyn.docs.intent.client.ui.editor.annotation.image.AbstractIntentImageAnnotation;
import org.eclipse.mylyn.docs.intent.client.ui.editor.annotation.image.IntentImageStyleRange;
import org.eclipse.mylyn.docs.intent.client.ui.editor.configuration.IntentFontConstants;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class IntentImageAnnotationDrawingStrategy
implements AnnotationPainter.IDrawingStrategy {
    private IntentEditor editor;
    private final ISourceViewer viewer;

    public IntentImageAnnotationDrawingStrategy(IntentEditor editor, ISourceViewer viewer) {
        this.editor = editor;
        this.viewer = viewer;
    }

    public void draw(Annotation annotation, GC gc, StyledText textWidget, int eventOffset, int length, Color color) {
        if (!(annotation instanceof AbstractIntentImageAnnotation) || !this.editor.isInitialFoldingStructureComplete()) {
            return;
        }
        try {
            int offset = eventOffset;
            if (gc != null) {
                Position position = this.viewer.getAnnotationModel().getPosition(annotation);
                if (position != null) {
                    AbstractIntentImageAnnotation imageAnnotation = (AbstractIntentImageAnnotation)annotation;
                    Image image = imageAnnotation.getImage();
                    if (image != null && !image.isDisposed()) {
                        offset = position.offset;
                        Point imagePosition = this.computeImagePosition(textWidget, offset, length, position);
                        Color foreground = gc.getForeground();
                        Color background = gc.getBackground();
                        gc.setForeground(textWidget.getForeground());
                        gc.setBackground(textWidget.getBackground());
                        Rectangle bounds = image.getBounds();
                        gc.fillRectangle(new Rectangle(imagePosition.x, imagePosition.y, bounds.width, bounds.height));
                        this.updateStyleRange(textWidget, offset, bounds.height, gc);
                        gc.setForeground(foreground);
                        gc.setBackground(background);
                        gc.drawImage(image, imagePosition.x, imagePosition.y);
                    }
                } else {
                    this.updateStyleRange(textWidget, offset, 1, gc);
                }
            } else {
                textWidget.redrawRange(offset, 1, true);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    private Point computeImagePosition(StyledText textWidget, int offset, int length, Position position) {
        Point imagePosition = textWidget.getLocationAtOffset(offset);
        if (position == null && length > 0) {
            Point right = textWidget.getLocationAtOffset(offset + length);
            if (imagePosition.x > right.x) {
                imagePosition.x = 0;
                imagePosition.y = right.y;
            }
        }
        return imagePosition;
    }

    private void updateStyleRange(StyledText textWidget, int offset, int expectedHeight, GC gc) {
        Iterable newArrayList = Iterables.filter((Iterable)Lists.newArrayList((Object[])new StyleRange[]{textWidget.getStyleRangeAtOffset(offset)}), IntentImageStyleRange.class);
        int length = 1;
        StyleRange styleRange = null;
        styleRange = !newArrayList.iterator().hasNext() ? new IntentImageStyleRange(offset, length, gc.getForeground(), gc.getBackground(), 0) : (StyleRange)newArrayList.iterator().next();
        Font oldFont = gc.getFont();
        Font referenceFont = IntentFontConstants.getImageReferenceFont();
        gc.setFont(referenceFont);
        float referenceFontHeightInPX = gc.getFontMetrics().getAscent();
        float expectedFontSizeFloat = (float)expectedHeight / referenceFontHeightInPX;
        expectedFontSizeFloat = (float)((double)expectedFontSizeFloat + 0.5);
        int expectedFontSizeInPoints = Math.round(expectedFontSizeFloat);
        gc.setFont(oldFont);
        if (styleRange.font == null || styleRange.font.getFontData()[0].getHeight() != expectedFontSizeInPoints) {
            Font coverringImageFont;
            styleRange.font = coverringImageFont = new Font(referenceFont.getDevice(), referenceFont.getFontData()[0].getName(), expectedFontSizeInPoints * referenceFont.getFontData()[0].getHeight(), 0);
            StyleRange[] ranges = new StyleRange[]{styleRange};
            textWidget.replaceStyleRanges(offset, length, ranges);
        }
    }
}

