/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.quickoutline;

import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.eclipse.handly.ui.quickoutline.IOutlinePopupHost;
import org.eclipse.handly.ui.quickoutline.OutlinePopup;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public abstract class FilteringOutlinePopup
extends OutlinePopup {
    private Text filterText;
    private Predicate<Object> patternMatcher;
    private Composite viewMenuButtonComposite;

    @Override
    public void init(IOutlinePopupHost host, KeyStroke invokingKeyStroke) {
        super.init(host, invokingKeyStroke);
        TreeViewer treeViewer = this.getTreeViewer();
        treeViewer.setExpandPreCheckFilters(true);
        treeViewer.addFilter((ViewerFilter)new PatternBasedFilter());
    }

    protected final Text getFilterText() {
        return this.filterText;
    }

    protected final Predicate<Object> getPatternMatcher() {
        return this.patternMatcher;
    }

    @Override
    protected Control getFocusControl() {
        return this.filterText;
    }

    @Override
    protected void setTabOrder(Composite composite) {
        this.viewMenuButtonComposite.setTabList(new Control[]{this.filterText});
        composite.setTabList(new Control[]{this.viewMenuButtonComposite, this.getTreeViewer().getTree()});
    }

    @Override
    protected TreeViewer createTreeViewer(Composite parent) {
        TreeViewer baseTreeViewer = super.createTreeViewer(parent);
        return new FilteringOutlineTreeViewer(baseTreeViewer.getTree());
    }

    protected Control createTitleMenuArea(Composite parent) {
        this.viewMenuButtonComposite = (Composite)super.createTitleMenuArea(parent);
        return this.viewMenuButtonComposite;
    }

    protected Control createTitleControl(Composite parent) {
        this.filterText = this.createFilterText(parent);
        return this.filterText;
    }

    protected Text createFilterText(Composite parent) {
        Text filterText = new Text(parent, 0);
        Dialog.applyDialogFont((Control)filterText);
        GridData data = new GridData(768);
        data.horizontalAlignment = 4;
        data.verticalAlignment = 2;
        filterText.setLayoutData((Object)data);
        filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    FilteringOutlinePopup.this.gotoSelectedElement();
                } else if (e.keyCode == 0x1000002 || e.keyCode == 0x1000001) {
                    FilteringOutlinePopup.this.getTreeViewer().getControl().setFocus();
                } else if (e.character == '\u001b') {
                    FilteringOutlinePopup.this.close();
                }
            }
        });
        if (this.getInvokingKeyStroke() != null) {
            filterText.addKeyListener(this.getInvokingKeyListener());
        }
        filterText.addModifyListener(e -> this.updatePatternMatcher(((Text)e.widget).getText()));
        return filterText;
    }

    protected final void updatePatternMatcher(String pattern) {
        this.patternMatcher = this.createPatternMatcher(pattern);
        this.patternMatcherUpdated();
    }

    protected Predicate<Object> createPatternMatcher(String pattern) {
        int length = pattern.length();
        if (length == 0) {
            return null;
        }
        if (pattern.charAt(length - 1) != '*') {
            pattern = String.valueOf(pattern) + '*';
        }
        return new ElementMatcher(new StringMatcher(pattern, pattern.toLowerCase().equals(pattern)));
    }

    protected void patternMatcherUpdated() {
        TreeViewer treeViewer = this.getTreeViewer();
        try {
            treeViewer.getControl().setRedraw(false);
            treeViewer.refresh();
            treeViewer.expandAll();
        }
        finally {
            treeViewer.getControl().setRedraw(true);
        }
        this.selectFirstMatch();
    }

    protected void selectFirstMatch() {
        Object focalElement = this.getFocalElement();
        Widget focalItem = null;
        TreeViewer treeViewer = this.getTreeViewer();
        if (focalElement != null) {
            focalItem = treeViewer.testFindItem(focalElement);
        }
        Tree tree = treeViewer.getTree();
        TreeItem item = focalItem instanceof TreeItem ? this.findItem(new TreeItem[]{(TreeItem)focalItem}) : this.findItem(tree.getItems());
        if (item == null) {
            treeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        } else {
            tree.setSelection(item);
            tree.showItem(item);
        }
    }

    protected Object getFocalElement() {
        return this.getInitialSelection();
    }

    private TreeItem findItem(TreeItem[] items) {
        return this.findItem(items, null, true);
    }

    private TreeItem findItem(TreeItem[] items, TreeItem[] toBeSkipped, boolean allowToGoUp) {
        TreeItem item;
        if (this.patternMatcher == null) {
            return items.length > 0 ? items[0] : null;
        }
        int i = 0;
        while (i < items.length) {
            item = items[i];
            Object element = item.getData();
            if (this.patternMatcher.test(element)) {
                return item;
            }
            ++i;
        }
        i = 0;
        while (i < items.length) {
            item = items[i];
            TreeItem foundItem = this.findItem(FilteringOutlinePopup.selectItems(item.getItems(), toBeSkipped), null, false);
            if (foundItem != null) {
                return foundItem;
            }
            ++i;
        }
        if (!allowToGoUp || items.length == 0) {
            return null;
        }
        TreeItem parentItem = items[0].getParentItem();
        if (parentItem != null) {
            return this.findItem(new TreeItem[]{parentItem}, items, true);
        }
        return this.findItem(FilteringOutlinePopup.selectItems(items[0].getParent().getItems(), items), null, false);
    }

    private static boolean canSkip(TreeItem item, TreeItem[] toBeSkipped) {
        if (toBeSkipped == null) {
            return false;
        }
        int i = 0;
        while (i < toBeSkipped.length) {
            if (toBeSkipped[i] == item) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static TreeItem[] selectItems(TreeItem[] items, TreeItem[] toBeSkipped) {
        if (toBeSkipped == null || toBeSkipped.length == 0) {
            return items;
        }
        int j = 0;
        int i = 0;
        while (i < items.length) {
            TreeItem item = items[i];
            if (!FilteringOutlinePopup.canSkip(item, toBeSkipped)) {
                items[j++] = item;
            }
            ++i;
        }
        if (j == items.length) {
            return items;
        }
        TreeItem[] result = new TreeItem[j];
        System.arraycopy(items, 0, result, 0, j);
        return result;
    }

    protected class ElementMatcher
    implements Predicate<Object> {
        private final Predicate<String> stringMatcher;

        public ElementMatcher(Predicate<String> stringMatcher) {
            if (stringMatcher == null) {
                throw new IllegalArgumentException();
            }
            this.stringMatcher = stringMatcher;
        }

        @Override
        public final boolean test(Object element) {
            if (element == null) {
                return false;
            }
            return this.stringMatcher.test(this.getText(element));
        }

        protected String getText(Object element) {
            IBaseLabelProvider labelProvider = FilteringOutlinePopup.this.getTreeViewer().getLabelProvider();
            if (labelProvider instanceof ILabelProvider) {
                return ((ILabelProvider)labelProvider).getText(element);
            }
            if (labelProvider instanceof DelegatingStyledCellLabelProvider.IStyledLabelProvider) {
                return ((DelegatingStyledCellLabelProvider.IStyledLabelProvider)labelProvider).getStyledText(element).toString();
            }
            if (labelProvider instanceof DelegatingStyledCellLabelProvider) {
                return ((DelegatingStyledCellLabelProvider)labelProvider).getStyledStringProvider().getStyledText(element).toString();
            }
            return null;
        }
    }

    protected class FilteringOutlineTreeViewer
    extends OutlinePopup.OutlineTreeViewer {
        public FilteringOutlineTreeViewer(Tree tree) {
            super(FilteringOutlinePopup.this, tree);
        }

        @Override
        protected boolean canExpand(TreeItem item) {
            if (FilteringOutlinePopup.this.patternMatcher != null) {
                return true;
            }
            return super.canExpand(item);
        }
    }

    private class PatternBasedFilter
    extends ViewerFilter {
        private PatternBasedFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (FilteringOutlinePopup.this.patternMatcher == null) {
                return true;
            }
            if (FilteringOutlinePopup.this.patternMatcher.test(element)) {
                return true;
            }
            return this.hasUnfilteredChild((TreeViewer)viewer, element);
        }

        private boolean hasUnfilteredChild(TreeViewer treeViewer, Object element) {
            return treeViewer.isExpandable(element);
        }
    }

    protected static class StringMatcher
    implements Predicate<String> {
        private final String expression;
        private final boolean ignoreCase;
        private Pattern pattern;

        public StringMatcher(String pattern, boolean ignoreCase) {
            this.expression = this.translatePattern(pattern);
            this.ignoreCase = ignoreCase;
        }

        @Override
        public final boolean test(String text) {
            if (text == null) {
                return false;
            }
            return this.getPattern().matcher(text).find();
        }

        protected String translatePattern(String pattern) {
            String expression = pattern.replaceAll("\\(", "\\\\(");
            expression = expression.replaceAll("\\)", "\\\\)");
            expression = expression.replaceAll("\\[", "\\\\[");
            expression = expression.replaceAll("\\]", "\\\\]");
            expression = expression.replaceAll("\\{", "\\\\{");
            expression = expression.replaceAll("\\}", "\\\\}");
            expression = expression.replaceAll("\\*", ".*");
            if (!(expression = expression.replaceAll("\\?", ".")).startsWith("^")) {
                expression = "^" + expression;
            }
            return expression;
        }

        private Pattern getPattern() {
            if (this.pattern == null) {
                this.pattern = this.ignoreCase ? Pattern.compile(this.expression, 66) : Pattern.compile(this.expression);
            }
            return this.pattern;
        }
    }
}

