/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model.impl;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.handly.context.Contexts;
import org.eclipse.handly.context.IContext;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.impl.IReconcileStrategy;
import org.eclipse.handly.model.impl.IWorkingCopyInfo;
import org.eclipse.handly.model.impl.WorkingCopyCallback;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.snapshot.NonExpiringSnapshot;

public class DefaultWorkingCopyCallback
extends WorkingCopyCallback {
    private final Object reconcilingLock = new Object();
    private volatile ISnapshot reconciledSnapshot;

    @Override
    public final boolean needsReconciling() {
        return !this.getWorkingCopyInfo().getBuffer().getSnapshot().isEqualTo(this.reconciledSnapshot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void reconcile(IContext context, IProgressMonitor monitor) throws CoreException {
        if (context.containsKey(IReconcileStrategy.SOURCE_AST)) {
            throw new IllegalArgumentException();
        }
        Object object = this.reconcilingLock;
        synchronized (object) {
            boolean needsReconciling = this.needsReconciling();
            if (needsReconciling || context.getOrDefault(Elements.FORCE_RECONCILING).booleanValue()) {
                IWorkingCopyInfo info = this.getWorkingCopyInfo();
                NonExpiringSnapshot snapshot = new NonExpiringSnapshot(info.getBuffer());
                info.getReconcileStrategy().reconcile(Contexts.with(Contexts.of(IReconcileStrategy.SOURCE_CONTENTS, snapshot.getContents()), Contexts.of(IReconcileStrategy.SOURCE_SNAPSHOT, snapshot.getWrappedSnapshot()), Contexts.of(IReconcileStrategy.RECONCILING_FORCED, Boolean.valueOf(!needsReconciling)), context), monitor);
                this.reconciledSnapshot = snapshot.getWrappedSnapshot();
            }
        }
    }
}

