/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.actions;

import com.google.inject.Inject;
import java.util.List;
import java.util.Optional;
import org.eclipse.glsp.server.actions.AbstractActionHandler;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.actions.SaveModelAction;
import org.eclipse.glsp.server.actions.SetDirtyStateAction;
import org.eclipse.glsp.server.features.core.model.SourceModelStorage;
import org.eclipse.glsp.server.features.sourcemodelwatcher.SourceModelWatcher;
import org.eclipse.glsp.server.model.GModelState;

public class SaveModelActionHandler
extends AbstractActionHandler<SaveModelAction> {
    @Inject
    protected Optional<SourceModelWatcher> modelSourceWatcher;
    @Inject
    protected GModelState modelState;
    @Inject
    protected SourceModelStorage sourceModelStorage;

    @Override
    public List<Action> executeAction(SaveModelAction action) {
        this.modelSourceWatcher.ifPresent(watcher -> watcher.pauseWatching());
        try {
            this.sourceModelStorage.saveSourceModel(action);
            this.modelState.saveIsDone();
        }
        catch (Throwable throwable) {
            this.modelSourceWatcher.ifPresent(watcher -> watcher.continueWatching());
            throw throwable;
        }
        this.modelSourceWatcher.ifPresent(watcher -> watcher.continueWatching());
        return this.listOf(new SetDirtyStateAction(this.modelState.isDirty(), "save"));
    }
}

