/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.ide.editor.internal.actions;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.glsp.graph.GSeverity;
import org.eclipse.glsp.server.actions.ResponseAction;

public class NavigateToMarkerAction
extends ResponseAction {
    public static final String ID = "navigateToMarker";
    public static final List<String> ALL_SEVERITIES = GSeverity.VALUES.stream().map(GSeverity::toString).collect(Collectors.toList());
    private String direction;
    private List<String> selectedElementIds;
    private List<String> severities;

    public NavigateToMarkerAction() {
        super(ID);
    }

    public NavigateToMarkerAction(List<String> selectedElementsIDs) {
        this(Direction.NEXT, selectedElementsIDs, ALL_SEVERITIES);
    }

    public NavigateToMarkerAction(Direction direction, List<String> selectedElementsIDs) {
        this(direction, selectedElementsIDs, ALL_SEVERITIES);
    }

    public NavigateToMarkerAction(Direction direction, List<String> selectedElementsIDs, List<String> severities) {
        super(ID);
        this.direction = direction.name().toLowerCase();
        this.selectedElementIds = selectedElementsIDs;
        this.severities = severities;
    }

    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public Optional<List<String>> getSelectedElementIds() {
        return Optional.ofNullable(this.selectedElementIds);
    }

    public void setSelectedElementIds(List<String> selectedElementIds) {
        this.selectedElementIds = selectedElementIds;
    }

    public List<String> getSeverities() {
        return this.severities;
    }

    public void setSeverities(List<String> severities) {
        this.severities = severities;
    }

    public static enum Direction {
        NEXT,
        PREVIOUS;

    }
}

