/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.ide.editor.di;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.log4j.Logger;
import org.eclipse.glsp.ide.editor.initialization.ModelInitializationConstraint;
import org.eclipse.glsp.ide.editor.ui.GLSPIdeEditorPlugin;
import org.eclipse.glsp.server.actions.Action;
import org.eclipse.glsp.server.di.ClientId;
import org.eclipse.glsp.server.features.contextactions.RequestContextActions;
import org.eclipse.glsp.server.internal.actions.DefaultActionDispatcher;

public class IdeActionDispatcher
extends DefaultActionDispatcher {
    private static final Logger LOGGER = Logger.getLogger(IdeActionDispatcher.class);
    protected final CompletableFuture<Void> onModelInitialized;
    protected final ModelInitializationConstraint initializationConstraint;

    @Inject
    public IdeActionDispatcher(Injector injector, @ClientId String clientId, ModelInitializationConstraint initializationConstraint) {
        this.clientId = clientId;
        this.initializationConstraint = initializationConstraint;
        this.onModelInitialized = initializationConstraint.onInitialized();
        this.onModelInitialized.thenRun(() -> LOGGER.info((Object)"Model Initialized."));
        GLSPIdeEditorPlugin.getDefaultGLSPEditorRegistry().getGLSPEditor(clientId).ifPresent(editor -> editor.setInjector(injector));
    }

    public CompletableFuture<Void> onceModelInitialized() {
        return this.onModelInitialized;
    }

    protected List<CompletableFuture<Void>> runAction(Action action) {
        if (!this.handleLocally(action, this.clientId)) {
            List actions = super.runAction(action);
            this.initializationConstraint.notifyDispatched(action);
            return actions;
        }
        return Collections.emptyList();
    }

    protected boolean handleLocally(Action action, String clientId) {
        if (action instanceof RequestContextActions) {
            return this.handleRequestContextActions((RequestContextActions)action, clientId);
        }
        return false;
    }

    private boolean handleRequestContextActions(RequestContextActions action, String clientId) {
        GLSPIdeEditorPlugin.getDefaultGLSPEditorRegistry().getGLSPEditorOrThrow(clientId).handleRequestContext(action);
        return false;
    }
}

