/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.ide.editor;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.glsp.server.actions.ActionMessage;
import org.eclipse.glsp.server.protocol.GLSPClient;
import org.eclipse.glsp.server.protocol.GLSPServer;
import org.eclipse.glsp.server.session.ClientSessionManager;

public class IdeGLSPClient
implements GLSPClient {
    @Inject
    protected GLSPServer glspServer;
    @Inject
    protected ClientSessionManager clientSessionManager;
    protected Multimap<String, GLSPClient> clientProxies = HashMultimap.create();

    public void connect(String clientSessionId, GLSPClient glspClient) {
        this.clientProxies.put((Object)clientSessionId, (Object)glspClient);
    }

    public boolean disconnect(String clientSessionId) {
        Collection result = this.clientProxies.removeAll((Object)clientSessionId);
        if (!result.isEmpty()) {
            this.clientSessionManager.disposeClientSession(clientSessionId);
            return true;
        }
        return false;
    }

    public void disconnect(GLSPClient glspClient) {
        List<String> toDisconnect = this.clientProxies.entries().stream().filter(entry -> entry.getValue() == glspClient).map(Map.Entry::getKey).collect(Collectors.toList());
        toDisconnect.forEach(this::disconnect);
    }

    public void process(ActionMessage message) {
        Collection result = this.clientProxies.get((Object)message.getClientId());
        Preconditions.checkState((!result.isEmpty() ? 1 : 0) != 0, (Object)("Could not retrieve GLSPCLient proxy for client session with id: " + message.getClientId()));
        result.forEach(proxy -> proxy.process(message));
    }
}

